#ifndef GSMLIBRARY_H
#define GSMLIBRARY_H

#include "mbed.h"

#define TIME_CONST 1    //Specify length of each GSM tick (currently 1 seconds in our debugger)
#define SECONDS_TIMEOUT 30
#define SMS_END_CHAR "\x1A"     //Character that must be appended to end of text message before it will be sent
#define SMS_ESCAPE_CHAR "\x1A"  //Character that can be appended to end of text message to abort sending it

enum gsm_states{GSM_INITIALIZE, 
                    GSM_AT_OK,      //Make sure communication is established with GSM
                    GSM_AT_CSQ,     //Check signal strength
                    GSM_AT_CREG,    //Check if phone is connected to network
                    GSM_AT_CNMI,    //Turn off incoming SMS notifications
                    GSM_AT_CMGF,    //Change to text message mode
                    GSM_READ_MSG,   //Check for new messages.
                    GSM_AT_CMGS,    //Input phone number and indicate beginning of SMS message body
                    GSM_AT_SENDSMS, //Write message, finish with SMS_END_CHAR
                    GSM_DEL_R_MSGS  //Delete unread messages (if present)   
                };

//GSM state machine
void gsm_tick();
bool gsm_timeOut();
void gsm_printState();
void gsm_nextStateLogic();
void gsm_mealyOutputs();

//Initialize DMA data transfer, and UART3.
void gsm_initialize();

//returns 1 for ready to send again, 0 for busy.
bool gsm_ready();

//Have the GSM send data - L = long, S = short, hh/mm/ss for time, "lat ns" for latitute, "lon we" for longitude
void gsm_send_data(float L, float Lref, float S, float Sref, int hh, int mm, int ss, float lat, char ns, float lon, char we);

//Brings state machine back to initialize state (notice this is a bit different than the initialize function)
//This will set flags to their initial values and prepare gsm to start anew.
void gsm_reset();

//For debugging: print registers related to DMA and UART setup
void print_registers();

#endif