/* Copyright (c) 2010-2011 mbed.org, MIT License
*
* Permission is hereby granted, free of charge, to any person obtaining a copy of this software
* and associated documentation files (the "Software"), to deal in the Software without
* restriction, including without limitation the rights to use, copy, modify, merge, publish,
* distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included in all copies or
* substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
* BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
* NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
* DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/
#pragma once
#include "mbed.h"
#include "math.h"
#include "MBed_Adafruit_GPS.h"
#include "SDFileSystem.h"
#include "QAM.h"
#include "GPRSInterface.h"
#include "param.h"
#include "stdlib.h"

#define NUM_SIZE 250
/** On many platforms USBTX/USBRX overlap with serial on D1/D0 pins and enabling the below will interrupt the communication.
 *  You can use an LCD display to print the values or store them on an SD card etc.
 */
DigitalOut led_red(LED_RED);
Serial pc(USBTX, USBRX);
//Serial gsm(D1,D0);

/**************************************************
 **          SD FILE SYSTEM                       **
 **************************************************/
//SDFileSystem sdModem(PTE3, PTE1, PTE2, PTE4, "sd"); //MOSI, MISO, SCLK, SSEL. Tested on K64F, correct pins.
FILE *fpData;
FILE *fpLog;

/**************************************************
 **          GPS                                 **
 **************************************************/
Serial * gps_Serial;

/**************************************************
 **          GPRS                                 **
 **************************************************/
/**
 * D1 - TX pin (RX on the WiFi side)
 * D0 - RX pin (TX on the WiFi side)
 * 19200 - Baud rate
 * "apn" - APN name
 * "username" - APN username
 * "password" - APN passowrd
 */
GPRSInterface eth(D1,D0, 19200, "ndo","","");
/**************************************************
 **          SENSOR INPUTS                       **
 **************************************************/
AnalogIn An(A0);
AnalogIn AnRef(A2);
Ticker sample_tick;
bool takeSample = false;
void tick(){takeSample = true;}

/**************************************************
 **          SIN OUTPUT                          **
 **************************************************/
AnalogOut dac0(DAC0_OUT);
int sinRes = (int)1/(CARRIER_FREQ*TIME_CONST);
float sinWave[SIN_LENGTH] = {};
int sinIndex = 0;


/**************************************************
 **          QAM                                 **
 **************************************************/
float sQ[SAMPLE_LENGTH] = {};
float sI[SAMPLE_LENGTH] = {};
float sRefQ[SAMPLE_LENGTH] = {};
float sRefI[SAMPLE_LENGTH] = {};

float Iarray[SAMPLE_LENGTH] = {};
float Qarray[SAMPLE_LENGTH] = {};
int sampleIndex = 0;
float I = 0;
float Q = 0;
float lon = 0;
float lonRef = 0;

/*Global Variables */
char c;
int s;
bool run = 0;
bool fil = 0;
float filtered = 0;
float filteredRef = 0;
char gsm_header[250]; //String storing SMS message that will be sent (add 250 length to give leeway)
char gsm_msg[250];
char num[NUM_SIZE];   //Temporary string storage to help with concatenation of strings
   
void buildIQ(){
    for(int i = 0; i < SAMPLE_LENGTH; i++){
        Iarray[i] = cos(2*PI*CARRIER_FREQ*i*TIME_CONST);
        Qarray[i] = -sin(2*PI*CARRIER_FREQ*i*TIME_CONST);
    }
}

void create_sinWave(){
    int i = 0;
    for(i = 0; i < SIN_LENGTH; i++){
        sinWave[i] = 0.25 * sin(2.0*PI*i/sinRes) + 0.75;
    }
}
void init(Adafruit_GPS myGPS){
    
    //fprintf(fpLog, "%s\r\n", ":)\r\n");
 
    //fprintf(fpLog, "%s\r\n", "Initializing the GPS\r\n");

    myGPS.begin(9600);
    myGPS.sendCommand(PMTK_SET_NMEA_OUTPUT_RMCGGA);
    myGPS.sendCommand(PMTK_SET_NMEA_UPDATE_1HZ);
    myGPS.sendCommand(PGCMD_ANTENNA);
    //fprintf(fpLog, "%s\r\n", "GPS Initialized\r\n");
    
    // Initialize filtering structures.
    buildIQ();
    create_sinWave();
    
    
    
    //Intialize the dhcp (or die trying)
    s = eth.init();
    if (s != NULL) {
        printf(">>> Could not initialise. Halting!\n");
        exit(0);
    }
    
    //Check the SIM card
    s= eth.preInit();
    if(s == true) {
        //fprintf(fpLog, "%s\r\n", "SIM Card is good!\r\n");
    } else {
        //fprintf(fpLog, "%s\r\n", "check your baud rate\r\n");
    }
}
void gatherData(Adafruit_GPS myGPS){     
        //sample
        if(takeSample){
            
            dac0 = sinWave[sinIndex];
            
            lon = An.read();
            lonRef = AnRef.read();
            
            I = Iarray[sampleIndex];
            Q = Qarray[sampleIndex];
            sI[sampleIndex] = lon*I;
            sQ[sampleIndex] = lon*Q;
            sRefI[sampleIndex] = lonRef*I;
            sRefQ[sampleIndex] = lonRef*Q;
            
            takeSample = false;
            sinIndex++;
            if((sinIndex+1) > SIN_LENGTH){
                sinIndex = 0;
            }
            
            sampleIndex++;
            if(sampleIndex+1 > SAMPLE_LENGTH){
                fil = 1;
            }
        }
        //Filter
        if(fil==1){
            
            fil = 0;
            run = 1;
            sampleIndex = 0;
            filtered = 15*QAM(sI, sQ);
            filteredRef = QAM(sRefI, sRefQ);
        }  
        
        c = myGPS.read();
        if ( myGPS.newNMEAreceived() ) {
            if ( !myGPS.parse(myGPS.lastNMEA()) ) {
                //fprintf(fpLog, "%s\r\n", "Couldn't parse the GPS Data\r\n");
            }
        }
        if(run){
            run = 0;
            printf("Logged Data\r\n");
            /*fprintf(fpLog, "15CM: %f, ", filtered);
            fprintf(fpLog, "15CM Reference: %f\r\n", filteredRef);
            fprintf(fpLog, "15CM / 15CM Refernce: %f\r\n", (filteredRef ? (filtered/filteredRef) : 0));
            fprintf(fpLog, "GPS TIME: %d:%d:%d \r\n", myGPS.hour-6, myGPS.minute, myGPS.seconds);*/
            
            if (myGPS.fix){
               printf("Lat: %5.2f%c, Long: %5.2f%c\r\n", myGPS.latitude, myGPS.lat, myGPS.longitude, myGPS.lon);
               //fprintf(fpLog, "Lat: %5.2f%c, Long: %5.2f%c\r\n", myGPS.latitude, myGPS.lat, myGPS.longitude, myGPS.lon);
            }
            else{
                printf("No GPS FIX\r\n");
                /*fprintf(fpLog, "%s\r\n", "No GPS fix\r\n");
                fprintf(fpLog, "%s\r\n", "--------------------------------\r\n");*/
            }
            
            /*fpData = fopen("/sd/data.txt", "a");
            if (fpData != NULL){
                
                fprintf(fpData, "%f, ", filtered);
                fprintf(fpData, "%f, ", filteredRef);
                fprintf(fpData, "%d:%d:%d\r\n", myGPS.hour-6, myGPS.minute, myGPS.seconds);
                if (myGPS.fix) fprintf(fpData, "%5.2f%c, %5.2f%c\r\n", myGPS.latitude, myGPS.lat, myGPS.longitude, myGPS.lon);
                else           fprintf(fpData, "No_GPS_fix\r\n");
                
                fclose(fpData);    
            }*/
            
        }
    
}
int main()
{
    //set the baud rates
    //gsm.baud(19200);
    
    gps_Serial = new Serial(PTC4,PTC3); ////Serial gsm(D1,D0);
    Adafruit_GPS myGPS(gps_Serial);
    
    //Initialize SD Card with log and data
    /*fpLog = fopen("/sd/log.txt", "a");
    if (fpLog != NULL){
        fprintf(fpLog, "%s\r\n", "--------------- DCS LOG ------------------");
    }
    fpData = fopen("/sd/data.txt", "a");
    if (fpData != NULL){
        fprintf(fpData, "%s", "--------------- DCS DATA ------------------");
    }
    
    //Successful Connection Message
    fprintf(fpLog, "%s\r\n", "---DPG Connection Successful!---\r\n");*/
    
    //initialize gps, gprs, sd card etc...
    init(myGPS);
    
    //fprintf(fpLog, "%s\r\n", ">>> Get IP address...\r\n");
    while (1) {
        s = eth.connect(); // Connect to network
        if (s == false || s < 0) {
            printf(">>> Could not connect to network. Retrying!\r\n");
            wait(3);
        } else {
            break;
        }
    }
    //fprintf(fpLog, ">>> Got IP address: %s\r\n", eth.getIPAddress());
    
    //fprintf(fpLog, "%s\r\n", ">>> Create a TCP Socket Connection\r\n");
    TCPSocketConnection sock;
    sock.set_blocking(true,5000);
     
    sock.connect("api.pushingbox.com",80);
    
    //fprintf(fpLog, "%s\r\n", "Gathering Data...\r\n");
    while(1){
        
        //take a sample
        tick();
        gatherData(myGPS);
        //if(!myGPS.fix){
            printf("Done Gathering Data\r\n");
            
            //fprintf(fpLog, "%s\r\n", "Begin Sending data...\r\n");
            //Concatenate data
            gsm_msg[0] = NULL;
            gsm_header[0] = NULL;
            int contentLength = 0;
            snprintf(num, NUM_SIZE, "&phone=%s", "3852368101");
            contentLength += strlen(num);
            strcat(gsm_msg, num);
            snprintf(num, NUM_SIZE, "&data=%f", filtered);
            contentLength += strlen(num);
            strcat(gsm_msg, num);
            snprintf(num, NUM_SIZE, "&dataRef=%f", filteredRef);
            contentLength += strlen(num);
            strcat(gsm_msg, num);
            snprintf(num, NUM_SIZE, "&dataRatio=%f", (filteredRef ? (filtered/filteredRef) : 0));
            contentLength += strlen(num);
            strcat(gsm_msg, num);
            snprintf(num, NUM_SIZE, "&time=%02d:%02d:%02d", myGPS.hour, myGPS.minute, myGPS.seconds);   //If there is no data from GPS, the time will just be "00:00:00" (that is okay)
            contentLength += strlen(num);
            strcat(gsm_msg, num);
            if (myGPS.lat != NULL) //If there is a gps fix (i.e. the gps has data on our location), ns will be set
            { 
                snprintf(num, NUM_SIZE, "&latitude=%.4f&longitude=%.4f", (myGPS.lat == 'N') ? myGPS.latitude : -myGPS.latitude, (myGPS.lon == 'E') ? myGPS.longitude : -myGPS.longitude);   //Use + or - rather than N/S, E/W
                contentLength += strlen(num);
                strcat(gsm_msg, num);
            }
            else {
                snprintf(num, NUM_SIZE,"&latitude=0&longitude=0");
                strcat(gsm_msg, num);    //Otherwise just send 0's for latitude and longitude
                contentLength += strlen(num);
            }
        
            
            //header information    
            snprintf(num, NUM_SIZE, "%s", "POST /pushingbox?devid=v941C443DE0C7B14");
            strcat(gsm_header, num);
            strcat(gsm_header, gsm_msg);
            snprintf(num, NUM_SIZE, "%s\r\n"," HTTP/1.1");
            strcat(gsm_header, num);
            snprintf(num, NUM_SIZE, "%s\r\n","Host: api.pushingbox.com");
            strcat(gsm_header, num);
            snprintf(num, NUM_SIZE, "%s\r\n","Connection: Keep-Alive");
            strcat(gsm_header, num);
            snprintf(num, NUM_SIZE, "%s\r\n","User-Agent: FRDM-KD64");
            strcat(gsm_header, num);
            //must have two blank lines after so the server knows that this is the end of headers
            snprintf(num, NUM_SIZE, "Content-Length: %d\r\n\r\n\r\n", contentLength);
            strcat(gsm_header, num);
            
            //fprintf(fpLog, "%s\r\n", ">>> Sending data to the server: %s\r\n",gsm_header);
            int result = sock.send_all(gsm_header, contentLength);
            //sock.set_blocking(false);
            if (result > 0) {
                //fprintf(fpLog, "%s\r\n", ">>> Successfully Sent Data to Server\r\n");
                printf("Successfully send data\r\n");
            } else {
                //fprintf(fpLog, "%s\r\n", ">>> Failed to Send Data, Error Code: %d \r\n",result);
                printf("Data Not Sent!! Content-Length:%d\r\n", contentLength);
            }
            
            //check that we are still connected (if not reconnect)
            //sock.close();
            //printf("end of program\n");
            // Disconnect from network
            eth.disconnect();
            //return 0;
            /*}
        else{
                fprintf(fpLog, "%s\r\n", ">>>No GPS Fix\r\n");
        }*/
        //wait(4);
    }
    
}

