/*
  modem.cpp
  2014 Copyright (c) Seeed Technology Inc.  All right reserved.

  Author:lawliet zou(lawliet.zou@gmail.com)
  2014-2-24

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "modem.h"
//Serial pc(USBTX,USBRX);
SDFileSystem sd(PTE3, PTE1, PTE2, PTE4, "sd"); //MOSI, MISO, SCLK, SSEL. Tested on K64F, correct pins.
AnalogIn LM35(PTB2);
// added by Noah Milam
void Modem::gprs_response()
{
    printf("\nlistening for client\n");
    char buffer[100];
    int count = 0;
   
    mkdir("/sd/mydir", 0777); // makes directory if needed
    FILE *fp = fopen("/sd/mydir/chemData.csv", "w"); // creats new file to write
    fprintf(fp,"phone Number,chem data, latitude,longitude\n"); // writes in a header for the table
    fclose(fp); // closes file
    
    while(1)
    { if(serialModem.readable()) {
             
            while(serialModem.readable()) {
                char c = serialModem.getc();
                buffer[count++] = c;
                //pc.puts(&c);
                if(count == 64) break;
            }
            
            if(buffer[0] != '\0'){
                buffer[count] = '\0';
                FILE *fp = fopen("/sd/mydir/chemicalData.csv", "a"); // opens file to append it
                fprintf(fp,"%s\n",buffer);//writes to file
                fclose(fp); // closes file
            
                printf("%s \n",buffer); 
                for(int i = 0; i < count+2; i++) {
                    buffer[i] = NULL;
                }
            }
            count = 0;
        }
    }
}

void Modem::wait_for_sms(){
    printf("waiting for message\n");
    while(1){
        if(serialModem.readable()){
            return;
        }    
    }
}
void Modem::get_message(){
    char tempStr[30];
    int count= 0;
    int line_count = 0;
    for(int i= 0;i < strlen(IPAdd);i++){
            if(line_count == 3){
                tempStr[count++] = IPAdd[i];    
            }
            if(IPAdd[i] == '\n'){
                line_count++;
            }
    } 
    tempStr[count - 2] = '\0';
    count++;
    strncpy(IPAdd, tempStr, count);
   printf("IP Addr > %s \n", IPAdd);
   printf("text size > %d\n",strlen(IPAdd));
 } 
void Modem::storeResp(){
    
    int line_count = 0;
    int read = -1;
    char buffer[100];
     int count = 0;
     timeCnt.start();
     while(timeCnt.read() < 5)
     {  
       while(serialModem.readable()) {
            char c = serialModem.getc();
                buffer[count++] = c;
        }
    }
    timeCnt.stop();
    timeCnt.reset();
    buffer[count] = '\0';

     strncpy(IPAdd, buffer, count);
    printf("original>> %s",IPAdd);
   printf("size of text > %d",strlen(IPAdd));
    count = 0;
    get_message();
}   

char* Modem::get_server_IP(){
    return IPAdd;
}
//end added by Noah Milam
char Modem::readByte(void)
{
    return serialModem.getc();
}

bool Modem::readable()
{
    return serialModem.readable();
}

int Modem::readBuffer(char *buffer,int count, unsigned int timeOut)
{
    int i = 0;
    timeCnt.start();
    while(1) {
        while (serialModem.readable()) {
            char c = serialModem.getc();
            buffer[i++] = c;
            if(i >= count)break;
        }
        if(i >= count)break;
        if(timeCnt.read() > timeOut) {
            timeCnt.stop();
            timeCnt.reset();
            break;
        }
    }
    return 0;
}

void Modem::cleanBuffer(char *buffer, int count)
{
    for(int i=0; i < count; i++) {
        buffer[i] = '\0';
    }
}

void Modem::sendCmd(const char* cmd)
{
    serialModem.puts(cmd);
}
void Modem::sendCmdResp(const char* cmd)
{
    serialModem.puts(cmd);
}
void Modem::getResp()
{
   char buffer[1000];
     int count = 0;
     timeCnt.start();
     while(timeCnt.read() < 5)
     { while(serialModem.readable()) {
            char c = serialModem.getc();
            buffer[count++] = c;
            }
        }
       timeCnt.stop();
       timeCnt.reset();
       buffer[count] = '\0';
       printf("Response:--%s--\r\n",buffer);
        for(int i = 0; i < count+2; i++) {
                buffer[i] = NULL;
            }
            count = 0;
}


void Modem::sendATTest(void)
{
    sendCmdAndWaitForResp("AT\r\n","OK",DEFAULT_TIMEOUT,CMD);
}

bool Modem::respCmp(const char *resp, unsigned int len, unsigned int timeout)
{
    int sum=0;
    timeCnt.start();

    while(1) {
        if(serialModem.readable()) {
            char c = serialModem.getc();
            sum = (c==resp[sum]) ? sum+1 : 0;
            if(sum == len)break;
        }
        if(timeCnt.read() > timeout) {
            timeCnt.stop();
            timeCnt.reset();
            return false;
        }
    }
    timeCnt.stop();
    timeCnt.reset();

    return true;
}

int Modem::waitForResp(const char *resp, unsigned int timeout,DataType type)
{
    int len = strlen(resp);
    int sum=0;
    timeCnt.start();

    while(1) {
        if(serialModem.readable()) {
            char c = serialModem.getc();         
            sum = (c==resp[sum]) ? sum+1 : 0;
            if(sum == len)break;
        }
        if(timeCnt.read() > timeout) {
            timeCnt.stop();
            timeCnt.reset();
            return -1;
        }
    }
    
    timeCnt.stop();
    timeCnt.reset();
    
    if(type == CMD) {
        while(serialModem.readable()) {
            char c = serialModem.getc();
        }
        
    }
    return 0;
}

int Modem::sendCmdAndWaitForResp(const char* data, const char *resp, unsigned timeout,DataType type)
{
    sendCmd(data);
    return waitForResp(resp,timeout,type);
}
