#pragma once
#include "mbed.h"
#include "MBed_Adafruit_GPS.h"
#include "SDFileSystem.h"
#include "GSMLibrary.h"
#include "stdlib.h"
#include "GPRSInterface.h"
#include "Chemical_Sensor_DMA/pause.cpp"
#include "Chemical_Sensor_DMA/Sample/adc.h"
#include "Chemical_Sensor_DMA/Sample/pdb.h"
#include "Chemical_Sensor_DMA/SignalProcessing.h"

/**************************************************
 **          GPS                                 **
 **************************************************/
Serial * gps_Serial;
Serial pc(USBTX, USBRX);

/**************************************************
 **          SD FILE SYSTEM                       **
 **************************************************/
SDFileSystem sd(PTE3, PTE1, PTE2, PTE4, "sd");
FILE *fpLog;
FILE *fpData;

/**************************************************
 **          SENSOR INPUTS                       **
 **************************************************/
/*Global Variables*/
extern GPRSInterface eth;
uint16_t *p1;
float filteredLong,filteredLongRef;
/*End Global Variables*/

/*int main ()
{   
    Timer refresh_Timer; //sets up a timer for use in loop; how often do we print GPS info?
    const int refresh_Time = 1000; //refresh time in ms
    
    //set to 1 for daylight savings time
    int daylightsavings = 1;
    
    // GPS INITIALIZATION //////////////////////////////
    pc.printf("Initialize GPS\r\n");
    gps_Serial = new Serial(PTC4,PTC3);
    Adafruit_GPS myGPS(gps_Serial);
    char c;
    myGPS.begin(9600);
    myGPS.sendCommand(PMTK_SET_NMEA_OUTPUT_RMCONLY);
    myGPS.sendCommand(PMTK_SET_NMEA_UPDATE_1HZ);
    myGPS.sendCommand(PGCMD_ANTENNA);
    ////////////////////////////////////////////////////
    
    wait(2.3);
    
    
    pc.printf("Compute Tables\r\n");
    pre_compute_tables();
    
    pc.printf("Initialize\r\n");
    initialize();
    
    
    int startAddress = (int)&sample_array0[0];
    int destinationIndex = (DMA_TCD0_DADDR-startAddress)/2;
    int currentIndex = 0;
    
    pc.printf("hello :)\r\n");
    float filteredLong = 0.0;
    float filteredLongRef = 0.0;

    refresh_Timer.start();  //starts the clock on the timer
    
    //main while loop for data processing
    pc.printf("Begin Processing Data...\r\n");
    while(1) {
        //get GPS coordinates
        c = myGPS.read();
        if ( myGPS.newNMEAreceived() ) {
            if ( !myGPS.parse(myGPS.lastNMEA()) ) {
                //continue;
            }
        }
        //eth.setCellTime();  
        //filter the data stored in the DAC
        do
        {
            destinationIndex = getDestinationIndex();
        }while (currentIndex == destinationIndex);
        
        while (currentIndex!=destinationIndex)
        {
            filter100K(sample_array0[currentIndex], sample_array1[currentIndex]);
            currentIndex++;
            if (currentIndex>=2000){
                currentIndex = 0;
            }
            
        }
        
        //send data every second
        if (refresh_Timer.read_ms() >= refresh_Time) {
            refresh_Timer.reset();
            
            //pc.printf("\r\nCell Time: %s\r\n", eth.getCellTime());
            //gather all the data to be written
            filteredLong = getFiltered();
            filteredLongRef = getFilteredRef();
            //time
            int hours = myGPS.hour - (6 + daylightsavings);
            int minutes = myGPS.minute;

            //gps
            float latitude = myGPS.latitude;
            char lat = myGPS.lat;
            float longitude = myGPS.longitude;
            char lon  = myGPS.lon;
            
            
            
            //log data locally to sd card
            fpData = fopen("/sd/data.txt", "a");
            if (fpData != NULL) {
                fprintf(fpData, "%f,", filteredLong);
                fprintf(fpData, "%f,", filteredLongRef);
                fprintf(fpData, "%f,", filteredLongRef ? (filteredLong/filteredLongRef) : 0);
                fprintf(fpData, "%02d:%02d:%02d,", hours, minutes, myGPS.seconds);
                if (myGPS.fix){ 
                    fprintf(fpData, "%5.2f%c,%5.2f%c\r\n", latitude, lat, longitude, lon);
                }
                else{
                    fprintf(fpData, "%5.2f%c,%5.2f%c\r\n", 0.00, 'N', 0.00, 'E');   
                }
                fclose(fpData);
            }
            //send data to google spreadsheet
            if(myGPS.fix){
                gsm_send_data(filteredLong, filteredLongRef, hours, minutes, myGPS.seconds, latitude,lat, longitude,lon);
            }else{
                gsm_send_data(filteredLong, filteredLongRef,hours, minutes, myGPS.seconds, 0, 0, 0, 0);
            }
            //tick the state machine
            gsm_send_data(filteredLong, filteredLongRef,0, 0, 0, 0, 0, 0, 0);
            gsm_tick();
        }
        
        
    }
}*/
// for debug purposes
DigitalOut led_red(LED_RED);
DigitalOut led_green(LED_GREEN);
DigitalOut led_blue(LED_BLUE);
 
Timer t1;
using namespace std;
 
 
#define PDB_DACINTC0_TOE 0x01 // 0x01 -> PDB DAC interal trigger enabled
#define DAC0_DAT0 (uint16_t *)0x400CC000 // DAC word buffer base address

void setUpDac()
{
    SIM_SCGC2 |= SIM_SCGC2_DAC0_MASK;  // turn on clock to the DAC
    SIM_SCGC6 |= SIM_SCGC6_DAC0_MASK;  // turn on clock to the DAC
    DAC0_C0 = 0xC0;
    //DAC0_C0 |= DAC_C0_DACEN_MASK ;   // enable the DAC; must do before any of the following
    DAC0_C2 =9;//cycle through the first 10 values in the buffer
    DAC0_C1 |= 0x80;//enable the dac buffer
    p1 = DAC0_DAT0;
    for (int i = 0; i < 16; i++)//fill the buffer 
    {//460, 2870
        uint16_t value = (uint16_t) (cos(3.14159265359 * 2 * 10000 * .00001 * i) * 460.0 + 2870.0);
        *p1++ = value; // 3351.0
        printf("Pointer: %d\tValue: %d\n\r", (uint32_t)p1,value);
    }
    printf("data low: %d\tdata high: %d\tTotal: %d\n\r",DAC0_DAT0L,DAC0_DAT0H,DAC0_DAT0L|(DAC0_DAT0H<<8));
    printf("data low: %d\tdata high: %d\tTotal: %d\n\r",DAC0_DAT1L,DAC0_DAT1H,DAC0_DAT1L|(DAC0_DAT1H<<8));
    printf("data low: %d\tdata high: %d\tTotal: %d\n\r",DAC0_DAT2L,DAC0_DAT2H,DAC0_DAT2L|(DAC0_DAT2H<<8));
    printf("data low: %d\tdata high: %d\tTotal: %d\n\r",DAC0_DAT3L,DAC0_DAT3H,DAC0_DAT3L|(DAC0_DAT3H<<8));
    printf("data low: %d\tdata high: %d\tTotal: %d\n\r",DAC0_DAT4L,DAC0_DAT4H,DAC0_DAT4L|(DAC0_DAT4H<<8));
    printf("data low: %d\tdata high: %d\tTotal: %d\n\r",DAC0_DAT5L,DAC0_DAT5H,DAC0_DAT5L|(DAC0_DAT5H<<8));
    printf("data low: %d\tdata high: %d\tTotal: %d\n\r",DAC0_DAT6L,DAC0_DAT6H,DAC0_DAT6L|(DAC0_DAT6H<<8));
    printf("data low: %d\tdata high: %d\tTotal: %d\n\r",DAC0_DAT7L,DAC0_DAT7H,DAC0_DAT7L|(DAC0_DAT7H<<8));
    printf("data low: %d\tdata high: %d\tTotal: %d\n\r",DAC0_DAT8L,DAC0_DAT8H,DAC0_DAT8L|(DAC0_DAT8H<<8));
    printf("data low: %d\tdata high: %d\tTotal: %d\n\r",DAC0_DAT9L,DAC0_DAT9H,DAC0_DAT9L|(DAC0_DAT9H<<8));
 
}
int startAddress = (int)&sample_array0[0];
int getDestinationIndex()
{
    if ((int)(DMA_TCD0_DADDR-startAddress)/2-1<0)
        return 1999;
    else
        return (int)(DMA_TCD0_DADDR-startAddress)/2-1;
}
int main()
{
     Timer refresh_Timer; //sets up a timer for use in loop; how often do we print GPS info?
    const int refresh_Time = 1000; //refresh time in ms
    
    //set to 1 for daylight savings time
    int daylightsavings = 1;
    
    // GPS INITIALIZATION //////////////////////////////
    pc.printf("Initialize GPS\r\n");
    gps_Serial = new Serial(PTC4,PTC3);
    Adafruit_GPS myGPS(gps_Serial);
    char c;
    myGPS.begin(9600);
    myGPS.sendCommand(PMTK_SET_NMEA_OUTPUT_RMCONLY);
    myGPS.sendCommand(PMTK_SET_NMEA_UPDATE_1HZ);
    myGPS.sendCommand(PGCMD_ANTENNA);
    ////////////////////////////////////////////////////
    
    led_blue = 1;
    led_green = 1;
    led_red = 1;
    pre_compute_tables();
    
    pc.printf("Starting...\r\n");    
    for(int i = 0; i < 86; i++) 
    {
        if(NVIC_GetPriority((IRQn_Type) i) == 0) NVIC_SetPriority((IRQn_Type) i, 2);
    }
    
    // Give hardware associated with 
    // sampling the highest priority
    NVIC_SetPriority(ADC1_IRQn,0);
    NVIC_SetPriority(ADC0_IRQn,0);
    NVIC_SetPriority(PDB0_IRQn,0);
    NVIC_SetPriority(DMA0_IRQn,0);
    NVIC_SetPriority(DMA1_IRQn,0);
    NVIC_SetPriority(DMA2_IRQn,0);
    
    NVIC_SetPriority(ENET_1588_Timer_IRQn,1);
    NVIC_SetPriority(ENET_Transmit_IRQn,1);
    NVIC_SetPriority(ENET_Receive_IRQn,1);
    NVIC_SetPriority(ENET_Error_IRQn,1);
    
    adc_init(); // initialize ADCs (always initialize adc before dma)
    setUpDac();
    dma_init(); // initializes DMAs
    pdb_init(); // initialize PDB0 as the timer for ADCs and DMA2 
    
    // flash green led indicating startup complete
    led_red = 1;
    led_blue = 1;
    led_green = 0;
    pause_ms(500);
    led_green = 1;
    pause_ms(200);
    led_green = 0;
    pause_ms(500); 
    led_green = 1;
    pdb_start();
    
    int destinationIndex = (DMA_TCD0_DADDR-startAddress)/2;
    int currentIndex = 0;
    
    printf("DAC C2: %X\n\r",DAC0_C2);
    printf("DAC C0: %X\n\r",DAC0_C0);
    printf("DAC C1: %X\n\r",DAC0_C1);
    printf("DAC C2: %X\n\r",DAC0_C2);
    
    pc.printf("hello :)\r\n");


    refresh_Timer.start();  //starts the clock on the timer
    
    //main while loop for data processing
    pc.printf("Begin Processing Data...\r\n");
    while (1)
    {
        //filter the data stored in the DAC
        do
        {
            destinationIndex = getDestinationIndex();
            if((int)(DMA_TCD0_DADDR-startAddress)/2 ==currentIndex-1)
                pc.printf("Buffer overrun\n\r");
        }while (currentIndex == destinationIndex);
        
        while (currentIndex!=destinationIndex)
        {
            filter100K(sample_array0[currentIndex], sample_array1[currentIndex]);
            
            //send data every second
            if (refresh_Timer.read_ms() >= refresh_Time) {
                refresh_Timer.reset();
                
                //get GPS coordinates
                c = myGPS.read();
                if ( myGPS.newNMEAreceived() ) {
                    if ( !myGPS.parse(myGPS.lastNMEA()) ) {
                        //continue;
                    }
                }
                //pc.printf("\r\nCell Time: %s\r\n", eth.getCellTime());
                
                
                //time
                int hours = myGPS.hour - (6 + daylightsavings);
                int minutes = myGPS.minute;
    
                //gps
                float latitude = myGPS.latitude;
                char lat = myGPS.lat;
                float longitude = myGPS.longitude;
                char lon  = myGPS.lon;
                
                //log data locally to sd card
                fpData = fopen("/sd/data.txt", "a");
                if (fpData != NULL) {
                    fprintf(fpData, "%f,", filteredLong);
                    fprintf(fpData, "%f,", filteredLongRef);
                    fprintf(fpData, "%f,", filteredLongRef ? (filteredLong/filteredLongRef) : 0);
                    fprintf(fpData, "%02d:%02d:%02d,", hours, minutes, myGPS.seconds);
                    if (myGPS.fix){ 
                        fprintf(fpData, "%5.2f%c,%5.2f%c\r\n", latitude, lat, longitude, lon);
                    }
                    else{
                        fprintf(fpData, "%5.2f%c,%5.2f%c\r\n", 0.00, 'N', 0.00, 'E');   
                    }
                    fclose(fpData);
                }
                //send data to google spreadsheet
                if(myGPS.fix){
                    gsm_send_data(filteredLong, filteredLongRef, hours, minutes, myGPS.seconds, latitude,lat, longitude,lon);
                }else{
                    gsm_send_data(filteredLong, filteredLongRef,hours, minutes, myGPS.seconds, 0, 0, 0, 0);
                }
                //send data once a second
                gsm_tick();
                printf("V1: %f\tV2: %f\tRatio: %f(Mine)\n\r",filteredLong,filteredLongRef,filteredLong/filteredLongRef);
            
            }
            currentIndex++;
            if (currentIndex>=2000){
                currentIndex = 0;
            }
            
        }
        
    }
          
}
void setFiltered(float ref){
    filteredLong = ref;
}
void setFilteredRef(float ref){
   filteredLongRef = ref;
}