#include "pdb.h"
#include "dma.h"


DigitalOut toggle_pdb(PTB23);


/*  The PDB is setup to run continuous (when enabled) so it will
 *  periodically trigger the ADCs to sample and trigger DMA2 to 
 *  save the quadrature angle.  The PDB can be started and stopped. */
void pdb_init() {
    
    // initialize the Programmable Delay Block
    
    // turn on the clock to the PDB
    SIM->SCGC6 |= SIM_SCGC6_PDB_MASK;
    
    // set ADC trigger to PDB0
    SIM_SOPT7 = SIM_SOPT7_ADC0TRGSEL(0); 
    
    // input frequency is 6 Mhz?
    // Configure the Peripheral Delay Block (PDB):
    //#define SLOW
    #ifdef SLOW
    PDB0_IDLY = 0;   // need to trigger interrupt every counter reset which happens when modulus reached
    PDB0_MOD = 0xffff;//0x257; // period of timer set to 10us
    PDB0_CH0DLY0 = 0;
    PDB0_CH0DLY1 = 0;
    PDB0_CH1DLY0 = 0;
    PDB0_CH1DLY1 = 0;
    PDB0_CH0C1 = PDB_C1_EN(2) | PDB_C1_TOS(2); // channel 0 pretrigger 0 and 1 enabled and delayed
    PDB0_CH1C1 = PDB_C1_EN(1) | PDB_C1_TOS(1); // channel 1 pretrigger 0 and 1 enabled and delayed
    
    // Setup Staus and Control Register
    PDB0_SC = 0; // clear register
    PDB0_SC = PDB_SC_DMAEN_MASK    // Enable DMA
             | PDB_SC_PRESCALER(5) // Slow down the period of the PDB for testing
             | PDB_SC_TRGSEL(0xf)  // Trigger source is Software Trigger to be invoked in this file
             | PDB_SC_PDBEN_MASK   // PDB enabled
             | PDB_SC_PDBIE_MASK   // PDB Interrupt Enable
             | PDB_SC_MULT(1)      // Multiplication factor
             | PDB_SC_CONT_MASK    // Contintuous, rather than one-shot, mode
             | PDB_SC_LDOK_MASK;   // Need to ok the loading or it will not load certain regsiters!
    #else
    PDB0_IDLY = 0;   // need to trigger interrupt every counter reset which happens when modulus reached
    PDB0_MOD = 0x257; // period of timer set to 10us
    PDB0_DACINT0 |= (0x257);
    PDB0_CH0DLY0 = 0;
    PDB0_CH0DLY1 = 0;
    PDB0_CH1DLY0 = 0;
    PDB0_CH1DLY1 = 0;
    PDB0_CH0C1 = PDB_C1_EN(2) | PDB_C1_TOS(2); // channel 0 pretrigger 0 and 1 enabled and delayed
    PDB0_CH1C1 = PDB_C1_EN(1) | PDB_C1_TOS(1); // channel 1 pretrigger 0 and 1 enabled and delayed
    
    // Setup Staus and Control Register
    PDB0_SC = 0; // clear register
    PDB0_SC = PDB_SC_DMAEN_MASK    // Enable DMA
             | PDB_SC_PRESCALER(0) // Slow down the period of the PDB for testing
             | PDB_SC_TRGSEL(0xf)  // Trigger source is Software Trigger to be invoked in this file
             | PDB_SC_PDBEN_MASK   // PDB enabled
             | PDB_SC_PDBIE_MASK   // PDB Interrupt Enable
             | PDB_SC_MULT(0)      // Multiplication factor
             | PDB_SC_CONT_MASK    // Contintuous, rather than one-shot, mode
             | PDB_SC_LDOK_MASK;   // Need to ok the loading or it will not load certain regsiters!
    //PDB0_DACINT0 |= (0x257); // we won't subdivide the clock... 
    PDB0_DACINTC0 |= 0x01; // enable the DAC interval trigger  
    #endif
    //PDB0_DACINT0 |= (0x257);
}

void pdb_start() {
    dma_reset();
    PDB0_SC |= PDB_SC_PDBEN_MASK;  // PDB enabled
    PDB0_SC |= PDB_SC_SWTRIG_MASK; // enable software trigger (start the PDB)
}

void pdb_stop() {
    PDB0_SC &= ~PDB_SC_PDBEN_MASK;  // PDB disabled
}















/* * * * * * * * * * * * * * For Debugging Purposes * * * * * * * * * * * * * * * * * * * * */

// Enables the interrupt for PDB0, which toggles PTB23.
// Scope PTB23 to verify the frequency.
void pdb_enable_interrupt() {
    PDB0_SC &= ~PDB_SC_DMAEN_MASK; // disable DMA, this stops DMA2 from functioning
    NVIC_SetVector(PDB0_IRQn, (uint32_t)&PDB0_IRQHandler);
    NVIC_EnableIRQ(PDB0_IRQn);
}
void pdb_disable_interrupt() {
    NVIC_DisableIRQ(PDB0_IRQn); // disable interrupt
    PDB0_SC |= PDB_SC_DMAEN_MASK; // enable DMA (this lets DMA2 function)
}
void PDB0_IRQHandler() {
    toggle_pdb = !toggle_pdb;
    PDB0_SC &= ~PDB_SC_PDBIF_MASK; // clear interrupt flag
}

void pdb_print_registers() {
    Serial debug2(USBTX,USBRX);
    debug2.printf("PDB0_SC:       %08x\r\n",PDB0_SC);
    debug2.printf("PDB0_MOD:      %08x\r\n",PDB0_MOD);
    debug2.printf("PDB0_CNT:      %08x\r\n",PDB0_CNT);
    debug2.printf("PDB0_IDLY:     %08x\r\n",PDB0_IDLY);
    debug2.printf("PDB0_CH0C1:    %08x\r\n",PDB0_CH0C1);
    debug2.printf("PDB0_CH0S:     %08x\r\n",PDB0_CH0S);
    debug2.printf("PDB0_CH0DLY0:  %08x\r\n",PDB0_CH0DLY0);
    debug2.printf("PDB0_CH0DLY1:  %08x\r\n",PDB0_CH0DLY1);
    debug2.printf("PDB0_CH1C1:    %08x\r\n",PDB0_CH1C1);
    debug2.printf("PDB0_CH1S:     %08x\r\n",PDB0_CH1S);
    debug2.printf("PDB0_CH1DLY0:  %08x\r\n",PDB0_CH1DLY0);
    debug2.printf("PDB0_CH1DLY1:  %08x\r\n",PDB0_CH1DLY1);
    debug2.printf("PDB0_DACINTC0: %08x\r\n",PDB0_DACINTC0);
    debug2.printf("PDB0_DACINT0:  %08x\r\n",PDB0_DACINT0);
    debug2.printf("PDB0_DACINTC1: %08x\r\n",PDB0_DACINTC1);
    debug2.printf("PDB0_DACINT1:  %08x\r\n",PDB0_DACINT1);
    debug2.printf("PDB0_POEN:     %08x\r\n",PDB0_POEN);
    debug2.printf("PDB0_PO0DLY:   %08x\r\n",PDB0_PO0DLY);
    debug2.printf("PDB0_PO1DLY:   %08x\r\n",PDB0_PO1DLY);
    debug2.printf("PDB0_PO2DLY:   %08x\r\n\n",PDB0_PO2DLY);
}
