/**Ciaran Kane-18689005-- Target Localisation---- Awkknowledgements Dr Edmond Nurellari Joystick Library. Craig Evans N5110 Library. Mbed HCSR04 Liibrary .
enji Arai Piezo library.

/**----Libraries*/
#include "mbed.h"
#include "Joystick.h"
#include "N5110.h"  
#include "ultrasonic.h"  
#include "piezo_bz.h" 

/**Setting interrupts for buttons*/
//There is only 4 butons due to my HCSR04 sensor being wired into two of the buttons channels
volatile int g_bumperL_flag = 0;
volatile int g_bumperR_flag = 0;
volatile int g_BACK_flag = 0;
volatile int g_START_flag = 0; 
int Target;

/**Voids for N5110 Menu Display*/
void initialiseMbed();
void menu();
void targetLocate();
void initUltrasonic();
void dist(int distance);
void techSupport();
void TargetDistance();


/**I/O definition*/
InterruptIn bumperL_btn(PTB18);
InterruptIn bumperR_btn(PTB3);
InterruptIn BACK_btn(PTB19);
InterruptIn START_btn(PTC5);
N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11);
Serial pc(USBTX, USBRX);                                                              
BusOut redleds(PTA1,PTA2,PTC2);
BusOut greenleds(PTC3,PTC4,PTD3);
PwmOut piezo(PTC10);                                                                                     
DigitalOut trigPin(PTD0);
DigitalIn echoPin(PTC12);
Joystick joystick(PTB10,PTB11,PTC16);
ultrasonic Sensor(PTD0, PTC12, .5, 1, &dist);


/** Design and thought process goes into more detail in the associated report written for this project.
But i will give a brief breakdown of what this simple code entails below:

*Calling for initialisation of mbedded controller on startup whilst all LEDS's on
when inialisation is complete turn off red LED's

*all for menu where you have an option to initialise the sensor or 
locate targets whilst red LED's stay on until one is selected using the left and right bumper
then green LEDS on

*If target locate is selected call for targetLocate void to show that a target is being located whilst green LEDS on

*If sensor intialisation is selected then sound piezo buzzer for a period of 10 seconds until sensor is initialised

*If target is found call for Located void with string text and turn on redLEDS and sound buzzer for 5 seconds to indicate target

*After target is located call for results void to display distance from sensor 
*/
//Main Program
int main()
{
    lcd.init();
    // printf ("LCD intialise");
    lcd.setContrast(0.4);
    // printf ("LCD Contrast set");
    // printf ("LCD Brightness Set");
    initialiseMbed();
    // printf ("MBED K64f Initialise");
    Sensor.startUpdates();
    // printf ("Ultrasonic Updates started");
    }

void initialiseMbed() {
    //printf ( Initialise MBED)
    greenleds= 1;
    redleds=0;
    //printf(green LED on)
    //printf(red led off)
    lcd.clear();
    lcd.printString("MBED",0,0);
    lcd.printString("Controller",0,1);
    lcd.printString("Initialising",0,2);
    lcd.printString("Ciaran Kane",0,5);
    lcd.refresh();
    wait(1); 
    lcd.printString("Initialising.",0,2);
    lcd.refresh();
    wait(1);
    lcd.printString("Initialising..",0,2);
    lcd.refresh();
    wait(5.0);
    lcd.clear();
    //printf (Intialised. Call for menu void)
    lcd.printString("Initialised",0,0);
    lcd.printString("Press Start",0,1);
    lcd.printString("For",0,2);
    lcd.printString("Main Menu",0,3);
    lcd.printString("",0,4);
    lcd.printString("Ciaran Kane",0,5);
    lcd.refresh();
    greenleds=0;
    //printf (green led off)
    redleds=1;
    //printf (red led on)
    wait(5.0);
    
    while(1)
    {
        wait(0.5);
        if (g_START_flag==1) {
            //printf (start flag)
            menu();
            }
            }
            }

           
void menu()
{
    lcd.clear();
    lcd.printString("Main Menu",0,0);
    lcd.printString("Localise - Start",0,2);
    lcd.printString("Sensor Initialise - LB",0,4);
    lcd.printString("Technical Support - RB ",0,5);
        while(1)
    {
        wait(0.5);
        if (g_bumperL_flag==1) {
            //printf (Left bumper flag)
            initUltrasonic();
            }
        else if(g_START_flag==1) { 
        //printf (Start flag)
          targetLocate();
            }
            else if(g_bumperR_flag==1) { 
            //printf (right bumper flag)
          techSupport();
            }
            }
           }
        
           
void initUltrasonic()
{
      
    greenleds= 1;
    //printf ( green led on)
    redleds=0;
    //printf(red led off)
    lcd.clear();
    lcd.printString("Ultrasonic",0,0);
    lcd.printString("Sesnor",0,1);
    lcd.printString("Initialising",0,2);
    lcd.printString("Ciaran Kane",0,5);
    lcd.refresh();
    wait(1); 
    lcd.printString("Initialising.",0,2);
    lcd.refresh();
    wait(1);
    lcd.printString("Initialising..",0,2);
    lcd.refresh();
    wait(5.0);
    lcd.clear();
    //printf(Sensor initialised)
    lcd.printString("Initialised",0,0);
    lcd.printString("Press Start",0,1);
    lcd.printString("For",0,2);
    lcd.printString("Main Menu",0,3);
    lcd.printString("",0,4);
    lcd.printString("Ciaran Kane",0,5);
    lcd.refresh();
    greenleds=0;
    //printf( green led off)
    redleds=1;
    //printf( red led on)
    wait(5.0);
    
    while(1)
    {
        wait(0.5);
        if (g_START_flag==1) {
            //printf( start flag)
            menu();
            }
            }
            }
void dist(int distance)
{
    // printf("sense = %d\n", sense);
     //printf("Distance changed to %dmm\r\n", distance);
    
            lcd.clear();
     
            char targetD[14];
            int length = sprintf(targetD,"%dmm", distance);
            if (length <= 14)
    
            lcd.printString("Localising Target",0,0);
            lcd.printString(targetD,24,3);
            lcd.refresh();
     
    }

void targetLocate()
{  
//printf( Target locating)
    lcd.printString("Searching",0,1);
    lcd.printString("For",0,2);
    lcd.printString("Target",0,3);
    TargetDistance();
    //printf( Target distance)
    lcd.clear();
    lcd.printString("Target",0,0); 
    lcd.printString("Found!",0,1);
    }

void TargetDistance()
{
        //sense;
     
        Target= Sensor.getCurrentDistance();
        
        //printf("distance at sense 1 = %d\r\n", Distance1);

        }
void techSupport()
    {  
    //printf(Tech support screen)
    lcd.printString("Ciaran Kane",0,1);
    lcd.printString("Main engineer",0,2);
    lcd.printString("Ciaran.kane@se.com",0,3);
    lcd.clear();
    lcd.printString("Contact for queries",0,0); 
    lcd.printString("+44 758604400",0,1);
    }
    