#ifndef MAIN_H
#define MAIN_H

/***************************************************************************//**
*
* @author Liam Cox
* @date January 2022
*
* @brief This is the header section for my main code, it includes all the inputs,
*        outputs and member functions that will be used in the main source code
*        file
*
*******************************************************************************/
 
#include "mbed.h"
#include "N5110.h"
#include "Joystick.h"
#include "ultrasonic.h"
#include "beep.h"

/***************************************************************************//**
* 
* below I have defined the inputs and outputs on the PCB, this includes all the
* push buttons that have been defined as interrupts, the piezo buzzer defined as
* a pwm output, the LEDs that have been defined in a Bus output for ease of use, 
* the LCD output pins VCC,SCE,RST,D/C, MOSI,SCLK,LED and the joystick 
* y-coordinate x-coordinate and button.
*
*******************************************************************************/

InterruptIn L(PTB18);
InterruptIn R(PTB3);
InterruptIn Start(PTC5);
InterruptIn Back(PTB19);

Beep buzzer(PTC10);

BusOut LEDS(PTA1,PTA2,PTC2,PTC3,PTC4,PTD3);

N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11);

Joystick joystick(PTB10,PTB11,PTC16);

/***************************************************************************//**
*
* below is a list of integars that have been defined, three objects have been 
* defined that will be used for the comparison to the sensed values later on in 
* the code. also there is an array of states for the LEDs in the FSM, states have 
* been defined in binary for ease of use, 0 is LED on, 1 is LED off so only one
* LED is on in any state. the distance and flag integars have also been defined 
* here but given no value, this is because these will be set later in the code.
*
*******************************************************************************/

int glass[] = {180,180,180,180,180,180}; 

int firestick_box[] = {180,500,500,180,500,500};

int Disaronno_bottle[] = {170,180,180,170,180,180};

int fsm[6] = {0b111110, 0b111101, 0b111011, 0b110111, 0b101111, 0b011111};

int Distance1, Distance2, Distance3, Distance4, Distance5, Distance6;

int Start_flag, Back_flag;

/***************************************************************************//**
*
* below the member functions that are to be used in the main source code file 
* have also been defined and the ultrasonice sensor trigger and echo pin have 
* been defined, it updates every .5 seconds and a timeout after 1 second and call
* the function dist when the distance changes.
*
*******************************************************************************/

void init_display();

void main_menu();

void sense_object();

void Start_isr();

void Back_isr();

void calibrate_object();

void dist(int distance);

void object_sense1();

void object_sense2();

void object_sense3();

void object_sense4();

void object_sense5();

void object_sense6();

void object_detection();

ultrasonic Ultrasonic(PTD0, PTC12, .5, 1, &dist);

//int sense;


#endif
