#include "mbed.h"
#include "ultrasonic.h"
#include "N5110.h"
#include "Joystick.h"
#include "beep.h"
#include "main.h"

/***************************************************************************//**
*
* the main code below sets all the interrupts to pull down and also for the start
* and back buttons it is sent to the specific start and back functions which sets
* the flags which are then used in other functions.
*
* the Ultrasonic.startUpdates() is where the ultrasonic sensor is told to start 
* measuring the distances.
* the joystick and lcd are then initialised and the main menu function is then
* called.
*
*******************************************************************************/

int main()
{

    R.mode(PullDown);
    Start.mode(PullDown);
    Start.rise(Start_isr);
    Back.mode(PullDown);
    Back.rise(Back_isr);
    // printf("set buttons");
    
    Ultrasonic.startUpdates();
    // printf ("Ultrasonic Updates started");
    
    joystick.init();
    // printf("initialise joystick")
    init_display();
    
    main_menu();
    
}

/***************************************************************************//**
*
* added function which initalise the display and sets the contrast, this is
* called from the int main and so the LCD boots up on startup.
*
*******************************************************************************/

void init_display(){
    
    // printf("initialise display");    
    lcd.init();
    lcd.setContrast(0.4);
    lcd.clear(); 
        
    }

/***************************************************************************//**
*
* this function is the main menu for the program, it is called at the start and 
* depending on what string is selected, clicking the start button will send the
* user to the specified function.
*
*******************************************************************************/      
    
void main_menu(){
    
    // printf("main menu");
    
    lcd.clear();
    Start_flag = 0; // make sure this is set to 0 to begin with so that it doesnt operate erroneously
    int select = 0; // always want the main menu to start on the same value on reset/ returning from a different screen
    LEDS = 63; // 63 on the bus output sets all LEDs to off

    while (1) {
        
    Direction d = joystick.get_direction();  
    // printf("Direction = %i\n",d);
    
        switch(select) {
            case 0:
                switch(d) {
                    case N:
                        select = 1;
                    // printf("UP");
                        break;
                    case S:
                        select = 1;
                    // printf("Down");
                        break;
}
                break;
            case 1:
                switch(d) {
                    case N:
                        select = 0;
                    // printf("UP");
                        break;
                    case S:
                        select = 0;
                    // printf("Down");
                        break;
}
                break;
 
        }
                wait(0.1);
        if (select == 0) {
            // printf("main menu - sense object");
            lcd.clear();
            lcd.printString("Detect",27,0);
            lcd.printString("Sense Object",7,2);
            lcd.printString("Calibration",7,3);
            lcd.drawCircle(3,19,2,FILL_TRANSPARENT);
            lcd.refresh();
            wait(0.15);
            if (Start_flag == 1) {
                Start_flag = 0;
                sense_object();
            }
        } else if (select == 1) {
            // printf("main menu - calibration");
            lcd.clear();
            lcd.printString("Detect",27,0);
            lcd.printString("Sense Object", 7,2);
            lcd.printString("Calibration",7,3);
            lcd.drawCircle(3,27,2,FILL_TRANSPARENT);
            lcd.refresh();
            wait(0.15);
            if (Start_flag == 1) {
                Start_flag = 0;
                calibrate_object();
            }
        }
    }
}

/***************************************************************************//**
*
* this function is for sensing the object, a switch statement is utilised here 
* just as it was in the main menu but here it is used for indicating the six 
* seperate readings that are to be taken.
* the start button is used to take the measuement and the R button is used to
* rotate the object
*
*******************************************************************************/ 

void sense_object(){
    
    // printf("sense object");  
        
    // set inital state 
    int state = 0;
    
    while(1)
    {
    LEDS = fsm[state];  // this sets the LED bus output current state of the FSM
     //printf("state = %d\r\n",state);
    
    // check which state we are in and see which the next state should be
    switch(state) {
        case 0:{
        lcd.clear();
        lcd.printString(" object at 0'",0,0);
        lcd.printString("   R + 60'",0,2);
        lcd.printString("Start to take",0,4);
        lcd.printString("   Reading ",0,5);
        lcd.refresh();
            if (R == 1){
                state = 1;}
            else state = 0;
            
             if (Start_flag == 1) {
                Start_flag = 0;
                object_sense1();
            }

                break;}
                
        case 1:{
        lcd.clear();
        lcd.printString(" object at 60'",0,0);
        lcd.printString("   R + 60'",0,2);
        lcd.printString("Start to take",0,4);
        lcd.printString("   Reading ",0,5);
        lcd.refresh();
            if (R == 1){
                state = 2;}
            else state = 1;
            
            if (Start_flag == 1) {
                Start_flag = 0;
                object_sense2();
            }
            
            break;}
        case 2:{
        lcd.clear();
        lcd.printString(" object at 120'",0,0);
        lcd.printString("   R + 60'",0,2);
        lcd.printString("Start to take",0,4);
        lcd.printString("   Reading ",0,5);
        lcd.refresh();
            if (R == 1){
                state = 3;}
            else state = 2;
                
            if (Start_flag == 1) {
                Start_flag = 0;
                object_sense3();
            }
            
            break;}
            
        case 3:{
        lcd.clear();
        lcd.printString(" object at 180'",0,0);
        lcd.printString("   R + 60'",0,2);
        lcd.printString("Start to take",0,4);
        lcd.printString("   Reading ",0,5);
        lcd.refresh();
            if (R == 1){
                state = 4;}
            else state = 3;
                
            if (Start_flag == 1) {
                Start_flag = 0;
                object_sense4();
            }
            
            break;}
            
        case 4:{
        lcd.clear();
        lcd.printString(" object at 240'",0,0);
        lcd.printString("   R + 60'",0,2);
        lcd.printString("Start to take",0,4);
        lcd.printString("   Reading ",0,5);
        lcd.refresh();
            if (R == 1){
                state = 5;}
            else state = 4;
                
            if (Start_flag == 1) {
                Start_flag = 0;
                object_sense5();
            }
            
            break;}
            
         case 5:{
        lcd.clear();
        lcd.printString(" object at 300'",0,0);
        lcd.printString("   R + 60'",0,2);
        lcd.printString("Start to take",0,4);
        lcd.printString("   Reading ",0,5);
        lcd.refresh();
            if (R == 1){
                object_detection();}
            else state = 5;

            if (Start_flag == 1) {
                Start_flag = 0;
                object_sense6();
            }
            
            break;}     
              
            default:{
                error("Invalid state");  //invalid state - call error routine
                // or could jump to starting state i.e. state = 0
                break;}
        }
        if (Back_flag == 1) {
            Back_flag = 0;
            main_menu();}
            
        ThisThread::sleep_for(200);
        }
        }

/***************************************************************************//**
*
* this function is for calibrating the distance in which the object centre point
* should be away from the sensor, it checks the current distance and then though
* the function "void dist" displays the current distance on the screen.
* this function also tells the user the distance away from the target centre 
* point this should be, this is so that the board is the right distance away and
* will be able to detect the object better.
*
* in order to print the distance onto the LCD the current distance is printed to
* a buffer which is a max length of 14 (the amount of characters that can fit
* width ways on the screen) this can then be printed on the screen using print
* string.
*
*******************************************************************************/
     
void calibrate_object(){
     
     //sense = 0;
     
     while(1)
    {
        Ultrasonic.checkDistance();    
        
        if (Back_flag == 1) {
            Back_flag = 0;
            main_menu();}
            
        wait (1);
        }
        }

void dist(int distance)
{
     //printf("sense = %d\n", sense);
    // printf("Distance changed to %dmm\r\n", distance);
    
            lcd.clear();
     
            char buffer[14];
            int length = sprintf(buffer,"%dmm", distance);
            if (length <= 14)
    
            lcd.printString("set object to",0,0);
            lcd.printString("    200mm",0,1);
            lcd.printString(buffer,24,3);
            lcd.refresh();
     
    }

/***************************************************************************//**
*
* these functions are called when the start button is pressed oin the sense object
* function, the purpose of these is to store the measured values for comparison
* and to make a buzzer sound to indicate to the user that the value has been
* measured
*
*******************************************************************************/

void object_sense1(){
     
        //sense = 1;
     
        Distance1 = Ultrasonic.getCurrentDistance();
        
        buzzer.beep(1000,2);
        wait(0.5);
        buzzer.beep(0,0);
        
        //printf("distance at sense 1 = %d\r\n", Distance1);

        }

void object_sense2(){
     
        //sense = 2;
     
        Distance2 = Ultrasonic.getCurrentDistance();
        
        buzzer.beep(1000,2);
        wait(0.5);
        buzzer.beep(0,0);

        //printf("distance at sense 2 = %d\r\n", Distance2);

        }
        
void object_sense3(){
     
        //sense = 3;
     
        Distance3 = Ultrasonic.getCurrentDistance();
        
        buzzer.beep(1000,2);
        wait(0.5);
        buzzer.beep(0,0);

        //printf("distance at sense 3 = %d\r\n", Distance3);
  
        }
        
void object_sense4(){
     
        //sense = 4;
     
        Distance4 = Ultrasonic.getCurrentDistance();
        
        buzzer.beep(1000,2);
        wait(0.5);
        buzzer.beep(0,0);

        //printf("distance at sense 4 = %d\r\n", Distance4);
     
        }
        
void object_sense5(){
     
        //sense = 5;
     
        Distance5 = Ultrasonic.getCurrentDistance();
        
        buzzer.beep(1000,2);
        wait(0.5);
        buzzer.beep(0,0);
        
        //printf("distance at sense 5 = %d\r\n", Distance5);
     
        }
        
void object_sense6(){
     
        //sense = 6;
     
        Distance6 = Ultrasonic.getCurrentDistance();
        
        buzzer.beep(1000,2);
        wait(0.5);
        buzzer.beep(0,0);
        
        //printf("distance at sense 6 = %d\r\n", Distance6);
 
        }

/***************************************************************************//**
*
* the object detection function is where the comparison between the measured
* values and the defined object arrays occurs, if the measured values match the
* arrays then the program will see it as an object found and will display this on
* the screen, otherwise it will ask the user to try again. a +/- 5mm deadband has
* been added to allow for minor erros in the measured values.
*
*******************************************************************************/

void object_detection(){
            
            lcd.clear();
    
            //printf("Distance 1 = %d\n", Distance1);
            //printf("glass[0] = %d\n", glass[0]);
            //printf("glass[6] = %d\n", glass[6]);
            if (abs(Distance1 - glass[0]) <= 5 and abs(Distance2 - glass[1]) <= 5 and abs(Distance3 - glass[2]) <= 5 and abs(Distance4 - glass[3]) <= 5 and abs(Distance5 - glass[4]) <= 5 and abs(Distance6 - glass[5]) <= 5){       
            //printf("glass\n");
            lcd.printString(" Object Found!",0,1);
            lcd.printString("  Pint Glass",0,3);
            lcd.refresh();}
            
            else if (abs(Distance1 - firestick_box[0]) <= 5 and abs(Distance2 - firestick_box[1]) <= 5 and abs(Distance3 - firestick_box[2]) <= 5 and abs(Distance4 - firestick_box[3]) <= 5 and abs(Distance5 - firestick_box[4]) <= 5 and abs(Distance6 - firestick_box[5]) <= 5){       
            //printf("Firestick Box\n");
            lcd.printString(" Object Found!",0,1);
            lcd.printString(" Firestick Box",0,3);
            lcd.refresh();}
            
            else if (abs(Distance1 - Disaronno_bottle[0]) <= 5 and abs(Distance2 - Disaronno_bottle[1]) <= 5 and abs(Distance3 - Disaronno_bottle[2]) <= 5 and abs(Distance4 - Disaronno_bottle[3]) <= 5 and abs(Distance5 - Disaronno_bottle[4]) <= 5 and abs(Distance6 - Disaronno_bottle[5]) <= 5){       
            //printf("Disaronno Bottle\n");
            lcd.printString(" Object Found!",0,1);
            lcd.printString("  Disaronno!",0,3);
            lcd.refresh();}
                     
            else{
            //printf("nothing\n");
            lcd.printString("  No Object!",0,1);
            lcd.printString("  Please Try",0,3);
            lcd.printString("Again",24,4);
            lcd.refresh();}
            }
    
/***************************************************************************//**
*
* these functions are for setting the flags for the start and back butons which
* are used in the other functions.
*
*******************************************************************************/
      
void Start_isr()
    {
    // printf("start button pressed"); 
    Start_flag = 1;
    }

void Back_isr()
    {
    // printf("back button pressed"); 
    Back_flag = 1;
    }
    