/**
IOT Coursework Project
Lewis Cameron

Water Temperature Legionella Detector With Custom Setpoint

Acknowledgements to Dr. Edmond Nurellari, University of Lincoln, for example codes and libraries
Acknowledgements to Craig A. Evans, University of Leeds, for libraries

Date 23/08/2022

*/
// importing the libraries to be used within the code
#include "mbed.h"
#include "TMP102.h"
#include "N5110.h"
#include "Joystick.h"
#include "Bitmap.h"

//Defining PCB Buttons as Interrupts
InterruptIn button_back(PTB19);
InterruptIn button_start(PTC5);
InterruptIn button_a(PTB9);
InterruptIn button_b(PTD0);
InterruptIn button_x(PTC17);
InterruptIn button_y(PTC12);
InterruptIn button_left(PTB18);
InterruptIn button_right(PTB3);
InterruptIn sw2(SW2);
InterruptIn sw3(SW3);

//Defining the PCB Led's as PWM Outputs 
PwmOut led_red1(PTA1);
PwmOut led_red2(PTA2);
PwmOut led_red3(PTC2);
PwmOut led_green1(PTC3);
PwmOut led_green2(PTC4);
PwmOut led_green3(PTD3);
DigitalOut boardled_red(LED_RED);
DigitalOut boardled_green(LED_GREEN);
DigitalOut boardled_blue(LED_BLUE);

// Defining the Joystick, LCD & TMP102 on their respective pins
Joystick Joystick(PTB10,PTB11,PTB16);
N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11);
TMP102 tmp(I2C_SDA,I2C_SCL);

//Defined the piezo as a PWM Output although it has not been used in the code
PwmOut piezo(PTC10);

//Creating the serial connection to the PC to enable the use of coolterm
Serial pc(USBTX,USBRX);

// Setting up the variables that will be used throughout the code in functions
volatile int button_a_flag = 0;    //PCB A Button
volatile int button_b_flag = 0;    //PCB B Button
volatile int button_x_flag = 0;    //PCB X Button
volatile int button_y_flag = 0;    //PCB Y Button
volatile int button_left_flag = 0;    //PCB Left Button
volatile int button_right_flag = 0;    //PCB Right Button
volatile int button_back_flag = 0;    //PCB Back Button
volatile int button_start_flag = 0;    //PCB Start Button
volatile int CwsHiSP = 20;    //CWS Water High Limit Temperature Setpoint
volatile int HwsKaSP = 70;    //HWS Water Temp which kills all legionella
volatile int HwsLoLimSP = 50;    //HWS water low limit temperature setpoint
volatile int CustomLoSP = 10;    //Custom low limit temperature setpoint which can be changed using the joystick 
volatile int CustomHiSP = 20;    //Custom high limit temperature setpoint which can be changed using left & right

// voids
// functions that will be used in the code
void init_serial();  // sets up serial baud rate
void init_K64F();    // sets up K64F
void init_pcb();     // sets up the pcb

// button voids
void button_a_isr();
void button_b_isr();
void button_x_isr();
void button_y_isr();
void button_left_isr();
void button_right_isr();
void button_back_isr();
void button_start_isr();

// void functions that will be called upon throughout the code
void startup();    //startup function
void codeloop();   //main loop function
void get_temp();   //temperature display function
void CustHi_SP();    //function for changine the custom high limit SP
void CustLo_SP();    //function for changine the custom low limit SP
void ShowSP();    //function to show the custom SP's on screen when they after they are changed

//State structure
struct State {
    //Output Setpoint
    int output;
    //Time delay while in state
    float time;
    //Next states array and length
    int nextState[9];
}; 


//Main Function

int main() {
    
    // interrupts setup
    button_a.rise(&button_a_isr);
    button_b.rise(&button_b_isr);
    button_x.rise(&button_x_isr);
    button_y.rise(&button_y_isr);
    button_left.rise(&button_left_isr);
    button_right.rise(&button_right_isr);
    button_back.rise(&button_back_isr);
    button_start.rise(&button_start_isr);
    
    
    
    init_serial();
    init_K64F();
    init_pcb();
    tmp.init();
    lcd.init();
    Joystick.init();
    //pc.printf("hardware initialised");
    
    lcd.setContrast(1);
    lcd.setBrightness(0.5);
    
    startup();
    
    codeloop();   
}

// initialise serial connection
void init_serial()
{
    pc.baud(9600);
}

void init_K64F()
{
    boardled_red = 1;
    boardled_green = 1;
    boardled_blue = 1;
    
    sw2.mode(PullNone);
    sw3.mode(PullNone);
}

void init_pcb()
{
    
    led_red1 = 1;
    led_red2 = 1;
    led_red3 = 1;
    led_green1 = 1;
    led_green2 = 1;
    led_green3 = 1;
    // disables PCB LED's active low LED's so off when = 1
    
    // sets up the PCB Buttons
    button_a.mode(PullDown);
    button_b.mode(PullDown);
    button_x.mode(PullDown);
    button_y.mode(PullDown);
    button_left.mode(PullDown);
    button_right.mode(PullDown);
    button_start.mode(PullDown);
    button_back.mode(PullDown);
}

void startup() // startup page 
{
    lcd.printString("Lewis Cameron",0,0);
    lcd.printString("18689002",0,1);
    lcd.printString("Legionella",0,2);
    lcd.printString("Sensor",0,3);
    lcd.printString("w/ Custom SP",0,4);
    //pc.printf("startup");
    lcd.refresh();
    wait(5);
}

void codeloop() // main loop
{
    int page;
    
    while(1){
        lcd.clear();
        
        switch(page){
        
        case 1: // CWS Page
        {
        
        init_pcb();
        
        float temp = tmp.get_temperature();
        
        
        lcd.clear();
        lcd.printString("CWS",30,0);
        lcd.printString("Temp =",0,1);
        get_temp(); // function to show the temperature on screen
        lcd.printString("Back = Home",0,5);
        //pc.printf("CWS");
        
        if (temp >= CwsHiSP){ // High temperature Alarm Warning appears on screen
            lcd.printString("CWS Temp High",0,2);
            lcd.printString("Legionella",0,3);
            lcd.printString("Warning",0,4);
            led_red1 = 0;
            //pc.printf("CWS High Temp");
        }
        
        else if (temp < CwsHiSP){  // Temperature at safe levels so message appears on screen
            lcd.printString("Temp OK",0,2);
            lcd.printString("No Danger",0,3);
            lcd.printString("Of Legionella",0,4);
            led_red1 = 1;
            //pc.printf("CWS Temp OK");
        }
        
        if (button_back_flag) {
            button_back_flag = 0;
            page = 0;
        }
        lcd.refresh();
    }
        break;
    
        case 2:
        {
    
        init_pcb();
        float temp = tmp.get_temperature();
    
        lcd.clear();
        lcd.printString("HWS",30,0);
        lcd.printString("Temp =",0,1);
        get_temp();
        lcd.printString("Back = Home",0,5);
    
    if (HwsLoLimSP < temp & temp < HwsKaSP){ // Temperature between 50-70 degrees which will start killing legionella
        lcd.printString("Temp Raised",0,2);
        lcd.printString("Killing",0,3);
        lcd.printString("Legionella",0,4);
        led_green1 = 0;
        //pc.printf("Temp killing legionella");
        }
    
    else if (temp >= HwsKaSP){ // Temperature above 70 degrees killing all legionella
        lcd.printString("Temp Raised",0,2);
        lcd.printString("No Danger",0,3);
        lcd.printString("Of Legionella",0,4);
        led_green1 = 0;
        led_green2 = 0;
        //pc.printf("Temp killed all legionella");
        }
    
    else if (temp < HwsLoLimSP){ // Temperature below 50 degrees allowing for legionella to live
        lcd.printString("Temp Low",0,2);
        lcd.printString("Legionella",0,3);
        lcd.printString("Warning",0,4);
        led_red1 = 0;
        //pc.printf("Temp too low legionella warning");
    }
        
    if (button_back_flag) {
        button_back_flag = 0;
        page = 0;
    }
    
    lcd.refresh();
    
}

    
    
    break;
    
    case 3:
    {
    
    init_pcb();
    float temp = tmp.get_temperature();
    
    lcd.clear();
        
    lcd.printString("Custom SP",15,0);
    lcd.printString("Temp =",0,1);
    get_temp();
    CustHi_SP(); // function to change high limit setpoint
    CustLo_SP(); // function to change low limit setpoint
    ShowSP(); // function to show both setpoints and change them on screen
    lcd.printString("Back = Home",0,5);
    
    if (CustomLoSP < temp & temp < CustomHiSP){
        lcd.printString("Temp In Range",0,4);
        led_green1 = 0;
        //pc.printf("Temp in custom range");
        }
    
    else if (temp > CustomHiSP){
        lcd.printString("High Temp",0,4);
        led_red1 = 0;
        //pc.printf("Custom temp high limit");
        }
        
        else if (temp < CustomLoSP){
        lcd.printString("Low Temp",0,4);
        led_red2 = 0;
        //pc.printf("Custom temp low limit");
        }
    
    if (button_back_flag) {
        button_back_flag = 0;
        page = 0;
    }
    lcd.refresh();
    
    }
    
    break;
    
    case 4:
    {
        init_pcb();
        lcd.clear();
        lcd.printString("Info",26,0);
        lcd.printString("Legionella",0,1);
        lcd.printString("Detector",0,2);
        lcd.printString("Lewis Cameron",0,3);
        lcd.printString("18689002",0,4);
        lcd.printString("Back = Home",0,5);
        lcd.refresh();
        //pc.printf("Info page");
        
        if (button_back_flag) {
        button_back_flag = 0;
        page = 0;
    }
    
    }      
             
     
       
        break;    
        {
        default:
        init_pcb();
        lcd.clear();
        
        lcd.printString("Main Menu",15,0);
        lcd.printString("A = Cold Water",0,1);
        lcd.printString("B = Hot Water",0,2);
        lcd.printString("X = Custom SP",0,3);
        lcd.printString("Y = Info",0,4);
        lcd.refresh();
        
        if (button_a_flag) {
            button_a_flag = 0;
            page = 1;
            //pc.printf("A Pressed");
        }
        
        if (button_b_flag) {
            button_b_flag = 0;
            page = 2;
            //pc.printf("B Pressed");
        }
        
        if (button_x_flag) {
            button_x_flag = 0;
            page = 3;
            //pc.printf("X Pressed");
        }
        
        if (button_y_flag) {
            button_y_flag = 0;
            page = 4;
            //pc.printf("Y Pressed");
        }
        
    }
}   

}
}    
    

        
void button_a_isr()
{
    button_a_flag = 1;
}        
 
void button_b_isr()
{
    button_b_flag = 1;
}
 
void button_x_isr()
{
    button_x_flag = 1;
}
 
void button_y_isr()
{
    button_y_flag = 1;
}

void button_left_isr()
{
    button_left_flag = 1;
}

void button_right_isr()
{
    button_right_flag = 1;
}
 
void button_back_isr()
{
    button_back_flag = 1;
}    

    
void button_start_isr()
{
    button_start_flag = 1;
}  

void get_temp()
{
    char buffer[14];
    float temp = tmp.get_temperature();
    int length = sprintf(buffer,"%.2f C",temp); 
    //pc.printf("temp = %f K\n",temp);
    if (length <=14)
    lcd.printString(buffer,38,1);
    
}

void CustHi_SP()
{
    Direction d = Joystick.get_direction();  //gets the direction the joystick is pushed
    
    
    if (d == W) { // decreases the setpoint when it is pushed left
        //pc.printf("Joystick Left");
        CustomHiSP = CustomHiSP - 1;
        wait(0.5);
    }
    
    if (d == E) { //increases the setpoint when it is pushed right
        //pc.printf("Joystick Right");
        CustomHiSP = CustomHiSP + 1;
        wait(0.5);
        
    }
}

void CustLo_SP() //function to change low limit SP
{
        if (button_left_flag) { //decreases the setpoint when the left bumper is pressed
            button_left_flag = 0;
            //pc.printf("Left pressed");
            CustomLoSP = CustomLoSP - 1;
            wait(0.5);
        }
        
        if (button_right_flag) { // increases the setpoint when the right bumper is pressed
            button_right_flag = 0;
            //pc.printf("Right pressed");
            CustomLoSP = CustomLoSP + 1;
            wait(0.5);
        }
        
}

void ShowSP()
{
    char buffer[14];
        int length = sprintf(buffer,"LoLimSP=%.2iC",CustomLoSP);
        
        if (length <= 14); {
            lcd.printString(buffer,0,3); // prints the low SP value on screen
        }
        
        length = sprintf(buffer,"HiLimSP=%.2iC",CustomHiSP);
        
        if (length <= 14); {
            lcd.printString(buffer,0,2); // prints the high SP value on screen
        }
}
    

void TMP102::error() // function to show that there is an error with the temp sensor on screen and switch on a red LED
{
    
    startup();                                                      
    lcd.clear();
    lcd.printString("TMP102",0,0);
    lcd.printString("Sensor Error",0,1);
    
    while(1) {                                                     
        //printf("Temp sensor error \n");
        led_red2 = 0;     
    }
}

        

    
 

