/* * 
* Prints a string of characters to the screen buffer, string is cut off after the 83rd  pixel.
* @param x - the column number (0 to 83)
* @param y - the row number (0-5) - the display is split into 6 banks - each bank can be considered a row
* @author - David Leaming - 25574043
* @ Date - December 2021
*
* Acknowledgements 
* Craig A. Evans, University of Leeds, TMP102 Library ,Feb 2016
* Dr Edmond Nurellari, University of Lincoln, Joystick & N5110 Libraries
*
*/ 

// it is good practice to put a comment block on the top, with the name and details of the library
// you can also include version numbers to keep track of changes/additions

/* TMP102

Simple library to get the temperature data from a TMP102 sensor over I2C.

v 1.0 - initial release

(c) Craig A. Evans, University of Leeds, Jan 2016

*/

// this is called a header guard and prevents a library from being included more than once
// if it is not already defined, it is defined. If it it already defined, it won't be defined again
// the header guard is closed at the end of the file
#ifndef TMP102_H
#define TMP102_H

// the next thing in a library is usually any required defines
// addresses for ADD0 connected to GND
#define TMP102_ADD      0x48
#define TMP102_R_ADD    0x91
#define TMP102_W_ADD    0x90

// register addresses
#define TEMP_REG    0x00
#define CONFIG_REG  0x01
#define THIGH_REG   0x02
#define TLOW_REG    0x03

// we need to include the mbed header (this will also have a header guard to prevent it being included more than once)
#include "mbed.h"

// a library is actually just a C++ class, we will create an instance of this class (an object) in our main code
class TMP102
{
    // we define the methods that are 'public' i.e. able to be used by the user
public:
    
    // this is a 'constructor' and is used to create the object
    TMP102(PinName sda, PinName scl);
    
    // we will also create an initialisation method
    void init();
    
    // and a method to get the temperature - note the return type
    float get_temperature();
    
    // we also have 'private' methods that can be used in the library itself, but not called directly by the user
private:

    // called in event of error - flashes LED and hangs 
    void error();
    // reads temperature from the sensor
    void read_temperature();
    

    // we also do the same for any variables
public:
    // don't generally allow direct access to variables, instead use 'accessor' and 'mutator' methods
    
private:

    // class data member names often have a trailing underscore to make them easily identifiable
    I2C* i2c_;
    DigitalOut* led_;
    float temperature_;

};

// end of the header guard
#endif