/*
* Author - Jack McGarley - 18689007
* Date - August 2022
* Acknowledgements
* Craig A. Evans, University of Leeds, TMP102 Library, Feb 2016
* Dr Edmond Nurellari, University of Lincoln, Joystick & N5110 Libraries
*/

#include "mbed.h" // include the library header, ensure the library has been imported into the project
#include "Joystick.h"
#include "TMP102.h"
#include "N5110.h"

TMP102 tmp102(I2C_SDA,I2C_SCL); // Create TMP102 object

N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11); //Designating N5110 Display

Joystick joystick(PTB10,PTB11,PTC16); //Designating Joystick

Serial pc(USBTX,USBRX); // UART connection for PC

DigitalOut grn_led1(PTA1); // Designating LEDs from left to right
DigitalOut grn_led2(PTA2);
DigitalOut grn_led3(PTC2);
DigitalOut red_led1(PTC3);
DigitalOut red_led2(PTC4);
DigitalOut red_led3(PTD3);
DigitalIn button_A(PTB9); // Designating Buttons
//DigitalIn B(PTD0);
DigitalIn button_X(PTC17);
DigitalIn button_Y(PTC12);
DigitalIn button_L(PTB18);
DigitalIn button_R(PTB3);
InterruptIn button_back(PTB19);
InterruptIn button_start(PTC5);
InterruptIn sw2(SW2); // K64F on-board switches
InterruptIn sw3(SW3);
InterruptIn B(PTD0);
InterruptIn R(PTB3);                           // Right Bumper Button
InterruptIn L(PTB18);                          // Left Bumper Button
InterruptIn A(PTB9);                           // A Button
InterruptIn Y(PTC12);                          // Y Button 
DigitalOut r_led(LED_RED); // K64F on-board LEDs
DigitalOut g_led(LED_GREEN);
DigitalOut b_led(LED_BLUE);



float Morning, Afternoon, Evening, Night ;



/** Declare voids before using in the code*/

void button_start_isr(); // Button Start interrupt service routine
void button_back_isr();

void B_isr(); // Interrupt Voidsvoid R_isr();                                 
void L_isr();
void A_isr();
void Y_isr();
void init_buttons(); // Initialise buttons


void error(); // error function hangs flashing an LED


void init_serial(); // Setting up the serial port


void init_K64F(); // Setting up the on-board LEDs and switches


void init_leds(); // Setting up the LEDs


void welcome(); // Setting up welcome screen


void startup(); // Setting up startup


void collection(); //temp collection


void view_data(); //view saved data



void display_tmp(); // Tempertature display



void morning(); //morning temp reading



void afternoon(); //afternoon temp reading



void evening(); //evening temp reading



void night(); //night temp reading



volatile int button_start_flag;  // Global Variables
volatile int button_back_flag;  // Global Variables
volatile int g_R_flag = 0;                   
volatile int g_L_flag = 0;                   
volatile int g_A_flag = 0;                   
volatile int g_Y_flag = 0;  
volatile int g_B_flag = 0;




/**Main Function*/
int main()
{
button_start.mode(PullDown);
button_start.rise(button_start_isr);
button_back.mode(PullDown);
button_back.rise(button_back_isr);
B.fall(&B_isr);                         // Flipping the Interrupt Function
B.mode(PullDown);                       // When the PCB Button is Pulled Down
/**R.fall(&R_isr);                            
R.mode(PullDown);                             
L.fall(&L_isr);
L.mode(PullDown);
A.fall(&A_isr);A.mode(PullDown);   
Y.fall(&Y_isr);
Y.mode(PullDown);**/



init_K64F(); // Initialising the board, serial port, LED'S and joystick
init_serial();
init_leds();
joystick.init();



tmp102.init(); // call the sensor init method using dot syntax



lcd.init(); // initialise display



lcd.setContrast(0.5); // Sets contrast to 0.5
welcome(); // Initialising Welcome Screen
startup(); // Initialising Startup



while (1) {
// these are settings that I have adjusted
lcd.normalMode(); // normal colour mode
lcd.setBrightness(0.75); // put LED backlight on 75%



float T = tmp102.get_temperature(); // read temperature and print over serial port
pc.printf("T = %.1f K\n",T);



if (T > 37.2f) {
red_led1.write(0); // LED 1 will flash when you're in High Temp
pc.printf("High Temperature \n"); // Printing to the LCD
}



else if (T < 36.1f) {
red_led2.write(0); // LED 2 will flash when you're in Low Temp
printf("Low Temperature \n"); // Printing to the LCD
}
else if (T > 38) {
red_led3.write(0); // LED 3 will flash when you're beyond high temperature
printf("Call Your GP \n"); // Printing to the LCD
}
}
}



void init_serial() {
pc.baud(9600); // set to highest baud - ensure terminal software matches
}



void init_K64F()
{
r_led = 1; // on-board LEDs are active-low, so set pin high to turn them off.
g_led = 1;
b_led = 1;



// since the on-board switches have external pull-ups, we should disable the internal pull-down
// resistors that are enabled by default using InterruptIn
sw2.mode(PullNone);
sw3.mode(PullNone);



}
void init_leds()
{
red_led1.write(1); // LEDs are common anode (active-low) so writing a 1 will turn them off
red_led2.write(1);
red_led3.write(1);
grn_led1.write(0);// LED on to show the board is on
grn_led2.write(1);
grn_led3.write(1);
}
void lcd_sett()//LCD Set
{
}
void startup() // Void function setup
{
button_start_flag = 0;
button_back_flag = 0;
int select = 1;
/**Menu starting here, using the joystick for navigating the menu.
*/
while (1) {
char d = joystick.get_direction(); // Allowing the joystick to navigate the menu



switch(select) { // Main switch
case 1: //Internal case 1 switch
switch(d) {
case N:
select = 4;
wait(0.3);
// printf("UP");
break; // Break from internal switch
case S:
select = 2;
wait(0.3);
// printf("Down");
break; // Break from internal switch
}
break; // Break from main switch



case 2: //Internal case 2 switch
switch(d) {
case N:
select = 1;
wait(0.3);
// printf("UP");
break; // Break from internal switch
case S:
select = 3;
wait(0.3);
// printf("Down");
break; // Break from internal switch
}
break; // Break from main switch



case 3: //Internal case 3 switch
switch(d) {
case N:
select = 2;
wait(0.3);
// printf("UP");
break; // Break from internal switch
case S:
select = 4;
wait(0.3);
// printf("Down");
break; // Break from internal switch
}
break; // Break from main switch



case 4: //Internal case 4 switch
switch(d) {
case N:
select = 3;
wait(0.3);
// printf("UP");
break; // Break from internal switch
case S:
select = 1;
wait(0.3);
// printf("Down");
break; // Break from internal switch
}
break; // Break from main switch
}
wait(0.3);
/** Menu selection screen printed to LCD*/

if (select == 1){
lcd.clear(); // Clear display
lcd.printString(" >Collection ", 0, 0); // Menu Selection, printing to LCD
lcd.printString(" View Data ", 0, 1);
lcd.printString(" Live Data ", 0, 2);
lcd.printString(" About ", 0, 3);
lcd.refresh(); // Refresh display
wait(0.3);

if (button_start_flag==1){
    printf("start button");
    button_start_flag=0;
    collection();
}
}  



else if (select == 2) {
lcd.printString(" Collection ", 0, 0);// Menu Selection, Printing to LCD
lcd.printString(" >View Data ", 0, 1);
lcd.printString(" Live Data ", 0, 2);
lcd.printString(" About ", 0, 3);
lcd.refresh(); // Refresh display
wait(0.3);
if (button_start_flag==1){
    button_start_flag=0;
    view_data();
}
}    



else if (select == 3) {
lcd.printString(" Collection ", 0, 0);// Menu Selection, Printing to LCD
lcd.printString(" View Data ", 0, 1);// Menu Selection, Printing to LCD
lcd.printString(" >Live Data ", 0, 2);
lcd.printString(" About ", 0, 3);
lcd.refresh(); // Refresh display
wait(0.3);
display_tmp();}



else if (select == 4){
lcd.printString(" Collection ", 0, 0);// Menu Selection, Printing to LCD
lcd.printString(" View Data ", 0, 1);
lcd.printString(" Live Data ", 0, 2);
lcd.printString(" >About ", 0, 3);
lcd.refresh(); // Refresh display
wait(0.3);}
}
}


void welcome() // Start Welcome screens
{                          
lcd.clear();
lcd.printString(" Jack McGarley ", 0, 0); // Welcome Screen 1, Printing to LCD   
lcd.printString(" 18689007 ", 0, 1);
lcd.printString(" Schneider ", 0, 2);
lcd.printString(" Lincoln Uni ", 0, 3);
lcd.printString(" February 2022 ", 0, 4);
lcd.refresh(); // Refresh display
wait(3);


lcd.clear();
lcd.printString(" Temperature ", 0, 0);// Welcome Screen 2, Printing to LCD
lcd.printString(" Based ", 0, 1);
lcd.printString(" Smart Device ", 0, 2);
lcd.printString(" Health ", 0, 3);
lcd.printString(" Monitoring ", 0, 4);
lcd.refresh(); // Refresh display
wait(3);
}

void B_isr()                            // Right Bumper Interrupt Service
{g_B_flag = 1;                           // set flag in ISR
}
void R_isr()                            // Right Bumper Interrupt Service    
{    g_R_flag = 1;                       // set flag in ISR
}
void L_isr()                            // Left Bumper Interrupt Service    
{    g_L_flag = 1;                       // set flag in ISR
}
void A_isr()                            // A Button Interrupt Service    
{    g_A_flag = 1;                       // set flag in ISR
}
void Y_isr()                            // Y Button Interrupt Service    
{    g_Y_flag = 1;                       // set flag in ISR
}



void display_tmp() // Displays Temperature on LCD
{   
char buffer[14]; //each character is 6 pixels wide, screen is 84 pixels (84/6 = 14)
if (g_B_flag)   { // Press button B to display Live data
g_B_flag = 0;
B.rise(&B_isr);
float T = tmp102.get_temperature(); // Get temperature and display
int length = sprintf(buffer,"%.1f C",T); // Displays to .1 decimal place        
if (length <= 14) {
lcd.clear(); // Clear display
lcd.printString("Temperature",0,1);
lcd.printString(buffer,0,2);
lcd.refresh();} // Refresh display 
wait(3);
}
}



void collection(){
    
    int state = 0;
    
    while(1)
    {
        switch(state){
            case 0:
            {
lcd.clear(); // Clear display
lcd.printString(" >Morning", 0, 0); // Menu Selection, printing to LCD
lcd.printString(" Afternoon ", 0, 1);
lcd.printString(" Evening ", 0, 2);
lcd.printString(" Night ", 0, 3);
lcd.refresh(); // Refresh display
wait(0.3);}



if (button_start_flag==1){
    button_start_flag=0;
    morning();
}
else if (button_back_flag==1){
    button_back_flag=0;
    startup();
}
}
}
}

void view_data()
{
    
    lcd.clear();
    char buffer[14];
    int length = sprintf(buffer,"%.1f C", Morning);
    if (length <= 14)
    lcd.printString("Morning Temp",0,0);
    lcd.printString(buffer,24,3);
    lcd.refresh();
    wait(1);
    
    if (button_back_flag==1){
    button_back_flag=0;
    startup();
}
}   
void morning(){
    
    Morning = tmp102.get_temperature();
    printf("morning temp = %i\n",Morning);
    }
    
void button_start_isr()
{
button_start_flag = 1;
}

void button_back_isr()
{
button_back_flag = 1;
}