
#include "mbed.h"
#include "SDBlock.h"
#include <wolfssl/wolfcrypt/ecc.h>

DigitalOut led1(LED1);
DigitalOut led4(LED4);

uint8_t hash[32];
uint8_t buffer[512];
uint8_t signature[5];
Sha256 h; 
ecc_key key;
RNG rng;

byte sig[512]; // will hold generated signature


int main() 
{   
    SDBlock original(p5, p6, p7, p22);
    const int x = original.disk_initialize();
    printf("************\r\n");
    printf("%d\r\n", x);
    SDBlock duplicate(p11, p12, p13, p21);   
    const int z = duplicate.disk_initialize();
    printf("%d\r\n", z);
    const int y = original.disk_status();
    printf("original status: %d\r\n", y);
    const int t = duplicate.disk_status();
    printf("duplicate status: %d\r\n", t);
    //s is sector 
    const uint32_t s = original.disk_sectors();
    printf("sector size %d\r\n", s);
    printf("buffer %d\r\n", buffer);
    
    wc_InitSha256(&h);
    
    
    //start time
    //time_t time_start = time(NULL);
    for (int i = 0; i <= 99; ++i)
    {
        const int r = original.disk_read(buffer, i, 1);
        if (r !=0)
        {
            printf("%d\r\n", r);
        }   
        printf("disk read ");
       /* const int rd2 = duplicate.disk_write(buffer, i, 1);
        if (rd2 != 0)
        {
           printf("%d\n", rd2);
        }*/
        //update hash
        wc_Sha256Update(&h, buffer, 512);
        printf("digest updated, block %d  \r\n",i);
        
      /*  if(i % 1000 == 0)
        {
            status update
            double percentage = (i/s) * 100;
            printf("percent copied: %d\n", percentage);
            time elapsed
            time_t time_current = time(NULL);
            int time_working = time_start - time_current;
            double speed = (i * 512) / time_working;
            
            printf("speed (bytes/s): %d\n", speed);
        } */
    }//end of for 
    wc_Sha256Final(&h,hash);
    //sign the hash
    int ret;
    uint32_t sigSz; 
    wc_InitRng(&rng);
    wc_ecc_init(&key);

       
    //print the hash
    printf("hash: ");
    for(int i = 0; i < 32; ++i)
        printf("%02x", hash[i]);
    printf("\r\n");
    
    //print signature
    printf("hash: ");
    //byte digest[] = hash;
    //int wc_ecc_sign_hash(const byte* hash, uint32_t len(hash), byte* sig, word32 *outlen, RNG* rng, 
//ecc_key* key);
    uint32_t hashsize = 8; 
    wc_InitRng(&rng); // initialize rng
    wc_ecc_init(&key); // initialize key
    wc_ecc_make_key(&rng, 32, &key); // make public/private key pair
    sigSz = sizeof(sig);
    ret = wc_ecc_sign_hash(hash, hashsize, sig, &sigSz,&rng, &key);
    
    printf("ret %i  \r\n",ret);
    
    if ( ret != 0 ) 
    {
    // error generating message signature
        printf("Error generating signature/r/n");
    }
    printf("finished\r\n");
    
    for(int i = 0; i < 512; ++i)
        printf("%02x", sig[i]);
    printf("\r\n");
 
    //when finished do this light pattern   
    while(true)
    {
        led1=0;
        led4=1;
        wait(.5);
        led1=1;
        led4=0;
        wait(.5);
    } 
}//end main
