/* #############################################################################
**    Archivo        : main.c
**    Proyecto       : STM32F103C8_Servos
**    Procesador     : STM32F103C8T6
**    Plataforma     : Blue Pill
**    Herramienta    : Mbed Compiler
**    Compilador     : Mbed Online C Compiler
**    Version        : 5.14
**    Fecha/Hora     : 20-12-2020, 12:20, # CodeGen: 0
**    Descripción    :
**         Este proyecto realiza el control de dos servomotores tipo Futaba.
**         This module contains user's application code.
**   Componentes     : ADC, GPIO, Timer, etc .
**   Configuraciones : Includes, Stacks y Drivers externos
**   Autores         :
**         ATEAM Development Group:
**          - Antulio Morgado Valle
**
**   Versión        : Beta
**   Revisión       : A
**   Release        : 0
**   Bugs & Fixes   :
**   Date           : 20/10/2019
**                    Added support for Led_RGB
**                    22/09/2018 
**                    Added LCD Menu, Beta version (with bugs)
**
** ###########################################################################*/
/*
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:  Includes
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
*/
#include "stm32f103c8t6.h"
#include "mbed.h"
#include "AnalogIn.h"
//#include "Led_RGB.h"
#include "Serial.h"
//#include "stdio.h"

/*
:...............................................................................
:  Definiciones
:...............................................................................
*/
#define  on             0               // Estado para boton presionado
#define off             1               // Estado para boton sin presionar
#define hold            2               // Estado para boton mantenido
#define release         3               // Estado para boton liberado
#define FALSE           0               // Estado FALSO
#define TRUE            1               // Estado VERDADERO
#define Ticker_Rate     1000            // Periodo de interrupción (us)
#define Baud_Rate       115200          // Velocidad de Transmisión (Bauds)
                                        // Velocidades Permitidas:
                                        // 300, 600, 1200, 2400, 4800, 9600,
                                        // 14400, 19600, 28800, 38400, 57600
                                        // 115200, 230400
/*
+-------------------------------------------------------------------------------
|  Configuración de Puertos 
+-------------------------------------------------------------------------------
*/
//confSysClock();     // Configure system clock (72MHz HSE clock, 48MHz USB clock)
Ticker      TimerInt;               // Inicializa la Interrupción por Timer
DigitalOut  led_monitor(LED1);      // Inicializa el LED Monitor (Interno)
Serial      terminal(PA_2, PA_3);   // Inicializa la Comunicación Serial a la PC
PwmOut      servo_1(PB_0);          // Inicializa el PWM para el Servo 1
PwmOut      servo_2(PB_1);          // Inicializa el PWM para el Servo 2
AnalogIn    pot_1 (PA_0);           // Inicializa Canal Analógico para Potenciometro 1
AnalogIn    pot_2 (PA_1);           // Inicializa Canal Analógico para Potenciometro 2
/*
+-------------------------------------------------------------------------------
|  Variables Globales de Usuario 
+-------------------------------------------------------------------------------
*/
uint16_t Rate=Ticker_Rate/2;        // Velocidad de barrido (500us = 0.5ms)
uint16_t X_Pos;                     // Posición para X 
uint16_t Y_Pos;                     // Posición para Y 
float    Canal_8;           /* Variable para el valor del Canal del ADC_8 */
float    Canal_9;           /* Variable para el valor del Canal del ADC_9 */
float    Duty1 = 0.05;             /* Variable para el Duty Cycle del Servo_1_1 */
float    Duty2 = 0.05;             /* Variable para el Duty Cycle del Servo_1_2 */
float    Duty3;             /* Variable para el Duty Cycle del PWM_1 */
float    Duty4;             /* Variable para el Duty Cycle del PWM_2 */
uint16_t counter=250;               // Cuenta inicial de 250us
bool     flag1;                     // Semáforo 1
/* END variables */

/*
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
|  Definición de Funciones Prototipo y Rutinas de los Vectores de Interrupción
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*/
        // Las Definiciones de Funciones Prototipo 
        // y Apuntadores a Vectores de Interrupciones van aquí !
void TimerInt_OnInterrupt(void);  
void Servo_Move(void);
/* END prototypes */

/* END definitions */  
/*
#===============================================================================
|
|               P R O G R A M A     P R I N C I P A L
|
#=============================================================================== 
*/
int main()          
{                           // Inicialización de variables, puertos e interrupciones
confSysClock();             // Inicialización del Sistema, Configure system clock (72MHz HSE clock, 48MHz USB clock)
TimerInt.attach_us(&TimerInt_OnInterrupt, Ticker_Rate);   // Le asigna el periodo de interrupción de 1ms (Ticker_Rate=1000)

terminal.baud(Baud_Rate);   // Se configura la velocidad de transmisión e inicia la comunicación serial.    
terminal.printf(" System is Wake Up!.\n\r");    // e inicia la  comunicación serial
terminal.printf ("\t\e[1;37;41mInstituto Politecnico Nacional\e[0m\n\r");
terminal.printf ("\e[1;37;42mESCUELA SUPERIOR DE INGENIERIA MECANICA Y ELECTRICA\e[0m\n\r\v");
terminal.printf ("\t\e[1;34;40mManejo \e[1;37;40mde \e[1;32;40mlos \e[1;33;40mServo \e[1;31;40mMotores\e[0m\n\r\v\v\e[0m");

    while (true)                // El Lazo del Programa principal está aquí !!!
    {
        if (flag1)  
        {
            Servo_Move();   // Llama a la rutina para mover los servo motores.
            terminal.printf("\t\e[1;33;41mPosicion X: %3d\x0df\t\e[1;37;41mPosicion Y: %3d\x0df\033[0m\r", X_Pos, Y_Pos); 
            flag1 = false; 
        }
    }
}
/* END main */

/*
................................................................................
:  Rutinas de los Vectores de Interrupción
................................................................................
*/
                // Las Rutinas de Atención a Interrupciones van aquí !
void TimerInt_OnInterrupt()          // Rutina de Atención al Ticker
{
    counter--;                      // Aquí va la Rutina de Servicio !
    if (!counter)
    {
        led_monitor = !led_monitor; // Parapadeo del LED por Interrupción (LED Toggled)
        flag1 = true;               // Permite actualizar los servos
        counter = Rate;             // Restablece el contador, Le asigna el periodo de 0.5ms (Rate=500)
    } 
}
/* END Events */   
/*
________________________________________________________________________________
|
|  Funciones Prototipo
|_______________________________________________________________________________
*/
                // Las Funciones Prototipo van aquí !
void Servo_Move()             // Routine for Servo move 
{
        // Read Pot value and calculate position. 
        // So to turn the Servo move to right, left or stay
    Duty1 = pot_1.read() * 0.1;
    Duty2 = pot_2.read() * 0.1;    
    servo_1 = Duty1;          // moves Servo 1 to new position
    servo_2 = Duty2;          // moves Servo 2 to new position
    X_Pos = Duty1 * 1850;       // calculates X position on degrees
    Y_Pos = Duty2 * 1850;       // calculates Y position on degrees
}
/* END functions */    
                
/* END program */

/*+-----------------------------------------------------------------------------       
*+ La documentación va aquí!:
*+-----------------------------------------------------------------------------       
*+  Conexión al Potenciometro:
*+ 
*+  Como recomendación hay que poner un filtro pasa bajas para evitar que el 
*+  ruido al convertidor analógico/digital.
*+  
*+      3.3V
*+       O                
*+       |
*+       |
*+       |          Conexión de los Potenciometros
*+       |          
*+       /
*+       \  10K 
*+       /          100
*+       \  <----/\/\/\/\--------------  PIN (Analog In)
*+       \                  |
*+       /                  |
*+       \                -----   0.1uF
*+       |                -----
*+       |                  |
*+       |                  |
*+       |                  |
*+    ___|___            ___|___
*+     _____              _____
*+      ___                ___
*+       _                  _
*+
*+      GND                GND
*+
*+----------------------------------------------------------------------------*
*+  Conexión al Servomotor:
*+ 
*+  Como recomendación hay que instalar un driver para acoplar los niveles de 
*+  de voltaje y excitar a los servo motores.
*+  
*+      Utilizando el CD4041
*+
*+              5V
*+               o
*+               | 14
*+               |
*+  3.3V         |         5V
*+             |\|   1     _______
*+             | \-------  Servo_1
*+          3  |  \
*+ PA_6   -----|   >
*+             |  /  2
*+             | /o------  Servo_1
*+             |/
*+
*+
*+             |\    11    _______
*+             | \-------  Servo_2
*+          13 |  \
*+ PA_7   -----|   >
*+             |  /  12
*+             | /o------  Servo_2
*+             |/|
*+               |
*+               |
*+               | 7
*+            ___|___
*+             _____
*+              ___
*+               _
*+
*+              GND                
*+
*+  
*+      Utilizando el SN74HC04,  SN74HC14 o CD4069
*+         
*+  
*+              5V
*+               o
*+               | 14
*+               |
*+  3.3V         |                            5V
*+             |\|            |\    
*+             | \            | \
*+          1  |  \   2    3  |  \  4
*+ PA_6   -----|   >o---------|   >o--------  Servo 1 (Signal In)
*+             |  /           |  /  
*+             | /            | /
*+             |/             |/
*+
*+
*+             |\             |\    
*+             | \            | \
*+          13 |  \  12    11 |  \  10
*+ PA_7   -----|   >o---------|   >o--------  Servo 2 (Signal In)
*+             |  /           |  /  
*+             | /            | /
*+             |/|            |/
*+               |
*+               |
*+               | 7
*+            ___|___
*+             _____
*+              ___
*+               _
*+
*+              GND    
*+
*+
*+----------------------------------------------------------------------------*
*+
*+      CARACTERISTCAS DEL SERVO MOTOR FUTABA
*+
**  El servomotor espera ver un pulso cada 20 milisegundos (ms) y la longitud 
*+  del pulso determinará qué tan lejos gira el motor. Por ejemplo, un pulso de 
*+  1.5 ms hará que el motor gire a la posición de 90°. Más corto que 1.5ms lo 
*+  mueve en sentido contrario a las agujas del reloj hacia la posición de 0°, 
*+  y más de 1.5ms girará el servo en sentido horario hacia la posición de 180°.
*+
*+        Pin Out Conector Futaba
*+
*+   Negative  ---------------  Black     
*+   Positive  ---------------  Red
*+   Signal In ---------------  White, Yellow or any other color
*+
*+   
*+
*+----------------------------------------------------------------------------*
*+      ALGORITMO
*+
*+ El control del Servo Motor se hace mediante un PWM modificado, es decir
*+ Periodo:                     20 ms
*+ Desplazamiento Mínimo:       1 ms    (0°)    5% Modulación
*+ Desplazamiento al Centro:    1.5 ms  (90°)   13.3% Modulación
*+ Desplazamiento Máximo        2 ms    (180°)  10.0% Modulación
*+  
*+ Desplazamiento = ADC_Value / 20 + 0.05  (0.05 + 0.1)
*+
*+----------------------------------------------------------------------------*
*+
*+   Powered by
*+
*+          T H E     A N T U L I U ' S   T E A M   R&D  Unltd 
*+
*+  Research, Development, Systems, Equipment, Support & Spare Parts.
*+  (C) Copyright 1989-2019, All Rights Reserved            
*+
*+  Welcome to The Beaners Proyect Community!                   
*+----------------------------------------------------------------------------*/

/* END documentation */ 

/* END Mbed */ 