/*Programme principal*/
//Cridass_v1 main

#include "functions.h"  //a "main.h" 

#ifdef DEBUG
Serial pc(USBTX, USBRX);
#endif

//---HCSR04---
Timer sensorTimer ;
DigitalOut trig0(D4) ;
DigitalOut trig1(D5) ;
//DigitalOut trig2(D6) ;
//DigitalOut trig3(D7) ;

DigitalIn  echo0(A5) ;
DigitalIn  echo1(A4) ;
//DigitalIn  echo2(A3) ;
//DigitalIn  echo3(A2) ;

HCSR04 sensor0(&trig0, &echo0, &sensorTimer);//avant
HCSR04 sensor1(&trig1, &echo1, &sensorTimer);//arriere
//HCSR04 sensor2(&trig2, &echo2, &sensorTimer);//gauche
//HCSR04 sensor3(&trig3, &echo3, &sensorTimer);//droite

//---MOTEURS---
AX12 Moteur1(D10, D2, 6, 250000);   //gauche
AX12 Moteur2(D10, D2, 3, 250000);   //droite
AX12 moteur(D10,D2,1,250000);     //changer lees valeurs               //moteur door

//---MOVE---
Timer chrono;           // a chrono

//---PARASOL---
//L293D parasol (D11,PC_3,PC_2);
PwmOut parasolPwm(PC_8);


//---GENERAL---
DigitalOut led(LED1);
//----GENERAL TIME----
Timeout theTime ;       //90 long long seconds

//----MODES----
//-----START-----
bool MIRRORED(false) ;
DigitalIn button(PC_13);        //the blue button 
DigitalIn start_trip(PC_12);             //START !!! when 0
//-----LEFT OR RIGHT
DigitalIn mirrorSwitch(PC_10);      //choix de la position

Timeout servantOfThugs;
DigitalOut thugOne(PC_8) ;           //D4,D5,D10,D2,D0,D1,D11
DigitalOut thugOfThugs(D6) ;        //D7,D
DigitalOut theThugnessIsOver9000(D9);

//-----------------------------------////
//              THE MAIN             ///
//-----------------------------------//
int main() {

    thugOne=0;
    thugOfThugs=0;
    theThugnessIsOver9000=0;

    led = 0 ;
    arret();                    //initialisation avant depart
    sensor0.setRange(10.0);     //          |
    sensor1.setRange(10.0);     //          |
    //sensor2.setRange(10.0);     //          |
    //sensor3.setRange(10.0);     //          |
    wait_ms(10);
    
    if(mirrorSwitch)            //   si cote droite du terrain
        MIRRORED = true ;       
    else                        //cote gauche
        MIRRORED = false ;
    if(MIRRORED)led = 1 ; else led = 0 ;
    #ifdef DEBUG
        pc.printf("waiting\n\r");
    #endif
        
    #ifdef BUTTONSTART  //choix start sur buttion (le bleu sur la nucleo) ou ficelle
        while(!button);  //start ?
        while(button);
    #else
        while(start_trip);//{pc.printf("test\n\r");wait_ms(250);}    //START !!! on 0 (retirer la ficelle)
        //led = 1 ;
        //pc.printf("led ON\n\r");
    #endif
    
    theTime.attach(&__TheParasol__, 90.0);        // Start The Timeout of 90 s
    
    #ifdef DEBUG
        pc.printf("start\n\n\r");
    #endif    

    led = 1 ;
    
    wait_ms(10);
    init();
    wait(1.0);
    wait_ms(10);   //+- d    //10.9  //pousse le sable
    avancer();
    wait(6.8);
    arret();
    wait_ms(10);
    
    if(MIRRORED){
        reculer();
        wait(5.9);
        arret();
        wait(1);
    }else{    //-+ g   //9.0   //retourne a la serviette
        reculer();
        wait(5.6);
        arret();
        wait(1);
    }
    wait_ms(10);

    if(MIRRORED) {                                          //vers les portes
            
            tournerDroite();
            wait(6.75*12/59);
            arret();
            wait(1); } //--       //mode droite : pivoter un peu moins
    else {
        tournerGauche();
         wait(6.75*12/59);
         arret();
        wait(1);}
          //--       // mode gauche
    wait_ms(10);


    avancer(); 
    wait(6.3);  //+-          //pousse la porte 1
    wait_ms(10);
    arret();
    wait(1);

    moveDetect(6.0*15/59, 0, DROITE, 0.0);   //++      //vers porte 2
    wait_ms(10);
    arret();
    wait(1);
    
    avancer();  
    wait(3.0);
    arret(); //+-          //pousse porte 2
    wait_ms(10);
    if (!MIRRORED){
        moveDetect(6.0*15/59, 0, GAUCHE, 0.0);
        wait(1);
        arret();
        wait(1);
        avancer();
        wait(2);
    }
    arret();
    wait(1);
    
    if(MIRRORED){
        moveDetect(6.75*10*36/59, 0, DROITE, 0.0);
        arret();
    wait(1);
        
        arret();
    wait(1);
    }else{
        moveDetect(6.75*10*15/59*1.15, 0, DROITE, 0.0);
        arret();
    wait(1);
        
        arret();
    wait(1);
    }
    
    arret();
    
    return 0 ;      // ------- FIN DU MAIN -------
}                   
