#include "mbed.h"
#include "sensor.h"
 
HCSR04::HCSR04(DigitalOut *trig, DigitalIn *echo, Timer *timer): _trig(trig), _echo(echo), _timer(timer), _dist(0.0){
    _range = 10.0 ;
}
 
float HCSR04::getDist()const{
    return _dist ;
}
 
float HCSR04::measDist(){
    _timer->reset();
    _timer->start();
    *_trig = 1 ;
    wait_us(10);
    *_trig = 0 ;
    while(*_echo == 0);
    _timer->reset();
    while(*_echo == 1 && _timer->read_ms()<25.0);
    _timer->stop();
    _dist = _timer->read_us()/58.0;
    return _dist;
}

void HCSR04::setRange(float range){
    _range = range;
}

bool HCSR04::inRange(){
    return measDist()<_range ;
}