#include "define.h"
#include "sensor.h"
#include "ax12.h"
#include "directions.h"
#include "l293d.h"
/*Programme principal*/

Serial pc(USBTX, USBRX);

AX12 Moteur1(D10, D2, 6, 250000);   //gauche
AX12 Moteur2(D10, D2, 3, 250000);   //droite
AX12 moteur(D10,D2,1,250000);     //changer lees valeurs               //moteur door

L293D parasol (D11,PC_3,PC_2);

Timer sensorTimer ;
DigitalOut trig0(D4) ;
DigitalOut trig1(D5) ;
//DigitalOut trig2(D6) ;
//DigitalOut trig3(D7) ;

DigitalIn  echo0(A5) ;
DigitalIn  echo1(A4) ;
//DigitalIn  echo2(A3) ;
//DigitalIn  echo3(A2) ;

HCSR04 sensor0(&trig0, &echo0, &sensorTimer);//avant
HCSR04 sensor1(&trig1, &echo1, &sensorTimer);//arriere
//HCSR04 sensor2(&trig2, &echo2, &sensorTimer);//gauche
//HCSR04 sensor3(&trig3, &echo3, &sensorTimer);//droite

Timeout theTime ;       //90 long long seconds
Timer chrono;           // a chrono

DigitalOut led(LED1);           //an embedded led
DigitalIn button(PC_13);        //the blue button 
DigitalIn mirrorSwitch(PC_10);      //choix de la position
DigitalIn start_trip(PC_12);             //START !!! when 0

void move(Direction dir);
void moveDetect(float duratio, char sensors, Direction dir, float tilObst);    //enum Direction{AVANT, ARRIERE, GAUCHE, DROITE}; in define.h
bool testSensors(char sensors);
void __TheParasol__();      //<--- Serious matter

bool MIRRORED(false) ;

int main() {
    led = 0 ;
    arret();                    //initialisation avant depart
    sensor0.setRange(10.0);     //          |
    sensor1.setRange(10.0);     //          |
    //sensor2.setRange(10.0);     //          |
    //sensor3.setRange(10.0);     //          |
    wait_ms(10);
    
    if(mirrorSwitch)            //   si cote droite du terrain
        MIRRORED = true ;       
    else                        //cote gauche
        MIRRORED = false ;
    if(MIRRORED)led = 1 ; else led = 0 ;
    #ifdef DEBUG
        pc.printf("waiting\n\r");
    #endif
        
    #ifdef BUTTONSTART  //choix start sur buttion (le bleu sur la nucleo) ou ficelle
        while(button);  //start ?
        while(!button);
    #else
        while(start_trip);//{pc.printf("test\n\r");wait_ms(250);}    //START !!! on 0 (retirer la ficelle)
        //led = 1 ;
        //pc.printf("led ON\n\r");
    #endif
    
    theTime.attach(&__TheParasol__, 90.0);        // Start The Timeout of 90 s
    
    #ifdef DEBUG
        pc.printf("start\n\n\r");
    #endif    

    led = 1 ;
    
    wait_ms(10);
    init();
    
        #ifdef DEBUG
            
        #endif
        wait_ms(10);
    moveDetect(10.9, AVANT, AVANT, 7.7);   //+- d
    wait_ms(10);
        #ifdef DEBUG
          
        #endif
    moveDetect(9.0, ARRIERE, ARRIERE, 7.0);    //-+ g
    wait_ms(10);
        #ifdef DEBUG
           
        #endif
    moveDetect(6.75*15/59, 0, GAUCHE, 100.0);  //--
    wait_ms(10);
        #ifdef DEBUG
          
        #endif 
    moveDetect(7.8, AVANT, AVANT, 6.0);   //+-
    wait_ms(10);
        #ifdef DEBUG
          
        #endif
    moveDetect(6.75*15/59, 0, DROITE, 100.0);   //++
    wait_ms(10);
        #ifdef DEBUG
         
        #endif
    moveDetect(1.8, AVANT, AVANT, 1.3);   //+-
    wait_ms(10);
        #ifdef DEBUG
           
        #endif
    arret();
    
    return 0 ;      // ------- FIN DU MAIN -------
}                   

void move(Direction dir){
    if(MIRRORED)
        if(dir == GAUCHE)
            dir = DROITE ;
        else if(dir == DROITE)
            dir = GAUCHE ;
    switch(dir){
        case AVANT :
            avancer();
            break;
        case ARRIERE :
            reculer();
            break;
        case GAUCHE :
            tournerGauche();
            break;
        case DROITE :
            tournerDroite();
            break;
    }
}

void moveDetect(float duratio, char sensors, Direction dir, float tilObst){ //enum Direction{AVANT, ARRIERE, GAUCHE, DROITE}; in define.h
    chrono.reset();
    wait_ms(10);
    chrono.start();
    move(dir);
    while(chrono.read()<duratio){
        if(chrono.read()<tilObst && testSensors(sensors)){
            chrono.stop();
            arret();
            while(testSensors(sensors)){
                led = !led ;
                wait_ms(100);
            }
            move(dir);
            chrono.start();
        }
    }
    arret();
}

bool testSensors(char sensors){
    bool avant = sensor0.inRange() && sensors & AVANT;
    wait_ms(10);
    bool arriere = sensor1.inRange() && sensors & ARRIERE;
    //wait_ms(10);
    //bool gauche = sensor2.inRange() && sensors & GAUCHE;
    //wait_ms(10);
    //bool droite = sensor3.inRange() && sensors & DROITE;
    /*if(MIRRORED){
        bool tmp = gauche ;
        gauche = droite ;
        droite = tmp ;
    }*/
    return avant || arriere ;//|| gauche || droite ;
}

void __TheParasol__(){
    led = 1 ;       // on arrete tout 
    arret();        //
    //lever le parasol...
    
}
