#ifndef l293d
#define l293d

#include "mbed.h"

class L293D
{
private :
// les noms sont directement lié au noms du l293d
    PwmOut enable;
    DigitalOut in1;
    DigitalOut in2;
    
//variable du pilote
    // la diretion est fonction du signe
    //la vitesse est fonction de la val_abs
    int etat;
    
    

public :
    /*lors de la création: 
    **      enable = Pwm
    **      in10   = DigitalOut
    **      in20   = DigitalOut
    */
    L293D ( PinName enable0, PinName in10, PinName in20 );
    
    /* definie directement la vitesse du systeme
    **doit etre suivi d'un :    act();
    **
    **renvoi    1 si réussit
    **          0 si l'entré etait hors champ
    */
    int set_etat( int new_etat );
    
    /* axelere ou ralentie
    */
    int vplus(); //vitesse +1
    int vmoins(); //vitesse -1
    
    
    static const int ETATMAX;
    
    /* actualise les pin en fonction de l'etat
    */
    void act(); //actualise les pins
};


#endif
