#include "mbed.h"
#include "l293d.h"

const int L293D::ETATMAX = 10;


L293D::L293D( PinName enable0, PinName in10, PinName in20 ): enable(enable0) , in1(in10) , in2(in20)
{
    enable.period_ms(50);
    //(this->enable).period_ms(50);
    (enable).write(0);
    (in1)=0;
    (in2)=0;
    (etat)=0;
}

int L293D::set_etat( int new_etat )
{
    if ((new_etat <= ETATMAX)&&(new_etat >= ETATMAX))
    {etat = new_etat;
    return 1;}
    else
    {return 0;}
}

int L293D::vplus()
{
    if (etat < L293D::ETATMAX){
        etat += 1;
        act();
        return 0;
        }
    else { return 1; }
}

int L293D::vmoins()
{
    if (etat > (-L293D::ETATMAX)){
        etat -= 1;
        act();
        return 0;
        }
    else { return 1; }
}

void L293D::act()
{
    
    
    if (etat == 0)
    {
        in1=0;
        in2=0;
        enable.write(0);
    }
    else if ( etat > 0)
    {
        in1=1;
        in2=0;
        enable.write(etat/float(L293D::ETATMAX));
    }
    else if (etat < 0)
    {
        in1=0;
        in2=1;
        enable.write(etat/float(-L293D::ETATMAX));
    }
}