/*
 *   StockBot  
 */
 
#undef printf
#include "Crealab.h"

Serial pc_uart(USBTX, USBRX); // USBTX = PA2
Serial bt_uart(PA_9, PA_10);  // PA9 = Tx, PA10 = Rx
uint32_t go;

// ---------------- PIN DEFINITIONS ---------------------

// --- Define the Four PINs & Time of movement used for Motor drive
Motor motorRD(PA_4, PA_3, PA_1, PA_0);
Motor motorRG(PA_8, PA_11, PB_5, PB_4);
Creabot mybot(&motorRG, &motorRD, 8.15f,8.35f); // insert the motors and indicate wheel diameter and distance between wheels

bool receivedCOMMAND;
char commandRECEIVED;
int state;
char commandLine[256];
int commandPosition;
int action;

void help() // Display list of Commands
{
    DEBUG("List of commands:\n\r");
    DEBUG(" h --> Help, display list of commands\n\r");
}

void callback() {
    switch(state){
     case 0:
       break;
     case 1:
       break;
     case 2:
       break;
     case 3:
       break;
     default:
     }
    state=state+1;
}

/* Stop all processes */
void stop_all()
{
    mybot.stopMove();
}

void executeCommand(char c) {
        bool flaghelp = false;
        switch (c) {
            case 'h':
                help();
                action=0;
                flaghelp=true;
                CASE('a', "Avance", action=2; )
                CASE('r', "Recule", action=3; )
                CASE('d', "Droite AV", action=4; )
                CASE('g', "Gauche AV", action=5; )
                CASE('p', "Pivote D", action=6; )
                CASE('q', "Pivote G", action=7; )
                CASE('s', "Stop",   action=1; )
                CASE('n', "Debrayer", action=9; )
                CASE('k', "Pince haute", action=10; )
                CASE('j', "Pince basse", action=11; )
                CASE('b', "Ventilo On", action=12; )
                CASE('l', "Ventilo Off", action=13; )
                CASE('c', "LEDs ON", action=14; )
                CASE('x', "LEDs OFF", action=15; )
                CASE('y', "Pince haute/basse", action=16; )
                CASE('D', "Droite AR", action=17; )
                CASE('G', "Gauche AR", action=18; )
                CASE('t', "Ventilo ON/OFF", action=19; )
                          
            default :
                DEBUG("invalid command; use: 'h' for help()\n\r");
                action=0;
        }}
        
void analyseCommand(char *command) {
    switch(command[0]) {
        case 'a':
            commandRECEIVED = 'a';
            break;
        case 'r':
            commandRECEIVED = 'r';
             break;
        case 'd':
            commandRECEIVED = 'd';
             break;
        case 'g':
            commandRECEIVED = 'g';
             break;
        case 'D':
            commandRECEIVED = 'D';
             break;
        case 'G':
            commandRECEIVED = 'G';
             break;
        case 's':
            commandRECEIVED = 's';
             break;
        case 'p':
            commandRECEIVED = 'p';
             break;
        case 'q':
            commandRECEIVED = 'q';
             break;
        case 'n':
            commandRECEIVED = 'n';
             break;
        case 'k':
            commandRECEIVED = 'k';
             break;
        case 'j':
            commandRECEIVED = 'j';
             break;
        case 'b':
            commandRECEIVED = 'b';
             break;
        case 'l':
            commandRECEIVED = 'l';
             break;
        case 'c':
            commandRECEIVED = 'c';
             break;
        case 'x':
            commandRECEIVED = 'x';
             break;
        case 'y':
            commandRECEIVED = 'y';
             break;
        case 't':
            commandRECEIVED = 't';
             break;

       default:
            commandRECEIVED = 'h';
    } }
    
void checkCommand(int result, char *command) {
    if(result==1) {
      analyseCommand(command);        
//    DEBUG("ANALYZED COMMAND %c %d state=%d\n\r",commandRECEIVED, parameterRECEIVED,state);
      receivedCOMMAND = true;
    } }

void split(char *line, int length) {
    char command[256];
    int parameter=0;
    int result = 1;
    int i=0;
    int j=0;
    while(i<length && line[i]==' ') {
        i++;}
    while(i<length && line[i]!=' ') {
         command[j]=line[i];
         i++;
         j++;}
    command[j]=0;
    i++;
    j=0;
     while(i<length && line[i]!=' ' && line[i]>='0' && line[i]<='9') {
       i++;
       j++;}
    if(j>0) {
        result++;
           i--;
        int k=1;
        while(j>0) {
           parameter += (line[i]-'0')*k;
            j--;
           i--;
           k=k*10;}
     }
  checkCommand(result, command);
}

void storeC(char c) {
    if(c==10 || c==13|| commandPosition >= 255) {
       split(commandLine, commandPosition);   
       commandPosition=0;}
    else {
      commandLine[commandPosition++]=c;
      commandLine[commandPosition]=0;}   
}

void getBT() {
    char c = bt_uart.getc();
    storeC(c);
}

void getPC() {
    char c = pc_uart.getc();
    storeC(c);
}

/* Main Routine */
int main()
{
     wait(1);
 //    bt_uart.printf("AT+NAMESTOCKBOT2"); // Changement nom module BT
 //    wait(2); 
   
    commandPosition=0;
    bt_uart.attach(getBT);
    pc_uart.attach(getPC);
    action=0;
    mybot.setSpeed(7.0); // max 8 cm.s, average 5 cm.s
    state=0;
    receivedCOMMAND = false;
    DEBUG("STOCKBOT\n\r");
    while(1) {
       if(receivedCOMMAND) {
            receivedCOMMAND = false;
            executeCommand(commandRECEIVED);
         if (action>=1) {
            if (action==1) {
                pc_uart.printf("Stop \r\n\n");
                mybot.stopMove();}
            if (action==2) {
                pc_uart.printf("Avance \r\n\n");
                mybot.move(FORWARD, 500);}
            if (action==3) {
                pc_uart.printf("Recule \r\n\n");
                mybot.move(BACKWARD, 500);}
            if (action==4) {
                pc_uart.printf("Droite \r\n\n");
                mybot.move(RIGHT, 360,0); }
            if (action==5) {
                pc_uart.printf("Gauche \r\n\n");
                mybot.move(LEFT, 360,0);}
            if (action==17) {
                pc_uart.printf("droite AR \r\n\n"); }
            if (action==18) {
                pc_uart.printf("gauche AR \r\n\n");}
            if (action==6) {
                pc_uart.printf("Pivote d \r\n\n");
                mybot.move(ROTATE, 360); }
            if (action==7) {
                pc_uart.printf("pivote g\r\n\n");
                mybot.move(ROTATE, -360); }
            if (action==9) {
                pc_uart.printf("debrayer \r\n\n");}
            if (action==10) {
                pc_uart.printf("pince haute \r\n\n");}
            if (action==11) {
                pc_uart.printf("pince basse \r\n\n");}
           if (action==12) {
                pc_uart.printf("Ventilo On \r\n\n");}
            if (action==13) {
                pc_uart.printf("Ventilo Off \r\n\n");}
            if (action==14) {
                pc_uart.printf("LEDs ON \r\n\n");}
            if (action==15) {
                pc_uart.printf("LEDs OFF \r\n\n");}
            if (action==16) {
                pc_uart.printf("pince haute/basse \r\n\n");}
            if (action==19) {
                pc_uart.printf("Ventilo ON/OFF \r\n\n");}
        action=0;
        } }
        wait(0.1);   
    } }