#include <Crealab.h>
#include <CreaBot.h>
#include <XNucleo6180XA1.h>

Serial pc_uart(PA_2, PA_15,115200); // PC Term
Serial bt_uart(PA_9, PA_10);        // BlueTooth

// --- Define the Four PINs & Time of movement used for Motor drive -----
Motor motorLeft  (D2, D3, D4, D5); // Declare first the 2 motors (to avoid to have an object with 8 pins to create)
Motor motorRight (D6, D7, D8, D9);
Creabot mybot(&motorLeft, &motorRight, 10.0f,13.0f); // insert the motors and indicate wheel diameter and distance between wheels

// ----------- PIN Definitions 6180 -------------
#define VL6180X_I2C_SDA   D14 
#define VL6180X_I2C_SCL   D15 
static XNucleo6180XA1 *board = NULL;


int main() {


    /* Init 6180 X-Nucleo  */
    int status;
    uint32_t dist;
    DevI2C *device_i2c = new DevI2C(VL6180X_I2C_SDA, VL6180X_I2C_SCL);
    board = XNucleo6180XA1::instance(device_i2c, A5, A4, D13, D4);
    status = board->init_board();
    if (status) {
        DEBUG("Failed to init board!\n\r");
    } 
/*   --------  */

    wait(2);        // Some delay


    mybot.setSpeed(12.5); // 12.5cm/s
    mybot.move(FORWARD,10); // Go forward of 10cm
    mybot.waitEndMove(); // Wait end of Move
    mybot.move(ROTATE,90); // Start rotation of 90° around the center between wheels (two wheels running in same direction at same speed)
    mybot.move(BACKWARD,40); // Stop immediately the rotation and go backward of 40cm
    mybot.waitEndMove(); // Wait end of Backward
    mybot.moveAndWait(LEFT,60); // Move Left of 60° in circle, center being the left wheel (off). Wait end of move
    mybot.waitEndMove();  // Not needed, as already waited... 
    mybot.moveAndWait(RIGHT,45, 33); // Move Right of 45°, center being at 33cm of the right wheel. Right wheel moving slower and on a shorter distance than left one. 
    mybot.moveAndWait(ROTATE,90);
    mybot.move(ROTATE,-90); // Opposite direction.
    mybot.waitEndMove(60); // with watchdog => if after 60s the move is not ended, continue the execution
    mybot.stopMove(); // Stop the movement before end...
    
    // Same with a fifo of command, opposite to the move, receiving a new command will not stop the current execution, but the bot will store it.
    mybot.fifo(FORWARD,10); // Already starting...
    mybot.fifo(BACKWARD,10); // will wait end of previous command to go
    mybot.fifo(ROTATE,120.0);
    mybot.fifo(LEFT, 30, 120);
    mybot.fifo(RIGHT, 25);
    mybot.waitEndMove(100000); // wait until fifo end... can flush anytime with stopMove...
    mybot.stopMove(); // before end... Flush the fifo and remove all instructions…

    while(1) {
    };
}

