#include "LED_WS2812.h"



LED_WS2812::LED_WS2812(PinName _PinOut, int _nbLeds) {
     nbLeds = _nbLeds;
    double period_ns;
     Timer tuneTimings;
     int sum = 0;
     int nopRun;
     
     for(int kavg = 0; kavg<20;kavg++) {
         tuneTimings.reset();
         tuneTimings.start();
         for(int nopCount=0; nopCount < 10000; nopCount ++) {
             __nop();
         }
         tuneTimings.stop();
         nopRun = tuneTimings.read_us();
         sum=nopRun+sum;
     }
     period_ns = sum/200; /* *1000 for nanoseconds /20 average /10000 count */
     
     int zero_high = ZERO_HIGH/period_ns;
     int zero_low  = ZERO_LOW/period_ns;
     int one_high  = ONE_HIGH/period_ns;
     int one_low   = ONE_LOW/period_ns;
     
     ws = new WS2812(_PinOut, nbLeds,  zero_high, zero_low, one_high, one_low);
     ws->useII(WS2812::PER_PIXEL);
    
    pxArray = new PixelArray(nbLeds);
    pxInsert = new PixelArray(nbLeds);
    ResetColor();
    rotationState = false;
    rotationPosition = nbLeds-1;
    blinkState = false;
    blinkONOFF = false;
    intensity = 0xff;
};
  
LED_WS2812::~LED_WS2812() {
    delete(ws);
    delete(pxArray);
}



void LED_WS2812::SetColor(LED_COLORS _color, int position) {
      SetColor((unsigned int) _color, position);
};

void LED_WS2812::SetColor(unsigned int _color, int position) {
      if(position < nbLeds && position >=0 ) {
          pxArray->Set(position, _color);
          pxArray->SetI(position,intensity);
      
      }
      __writeBuf(0);
      nbInsert = 0;
      if(rotationState) StopRotation();
       rotationPosition = nbLeds;
};

void LED_WS2812::SetColor(LED_COLORS _color) {
      SetColor((unsigned int) _color);
};

void LED_WS2812::SetColor(unsigned int _color) {
      for(int i=0;i<nbLeds;i++) {
          pxArray->Set(i, _color);
          pxArray->SetI(i,intensity);
     }
       __writeBuf(0);
     nbInsert = 0;
     if(rotationState) StopRotation();
      rotationPosition = nbLeds;
};


void LED_WS2812::ResetColor() {
     SetColor(BLACK);
                  
 }

void LED_WS2812::__writeBuf(int z) {
     ws->write_offsets(pxArray->getBuf(),z,z,z);
     wait(0.01);
 }
 
void LED_WS2812::__insert2buf() {
     for(int i=0;i<nbLeds;i++) {
          pxArray->Set(i, pxInsert->Get(i%nbInsert));
      }
      __writeBuf(0);
      rotationPosition = nbLeds;    
}

void LED_WS2812::__insertColor(unsigned int _color, int _intensity) {
      pxInsert->Set(nbInsert%nbLeds,_color);
      pxInsert->SetI(nbInsert%nbLeds,_intensity);
      nbInsert++;
      
};
 
void LED_WS2812::InsertColor(unsigned int _color) {
      InsertColor(_color,intensity*100/0xFF);
};


void LED_WS2812::InsertColor(unsigned int _color, float brightness) {
       int pixelIntensity = brightness*0xFF/100;
       __insertColor(_color, pixelIntensity);
       __insert2buf();
};


void LED_WS2812::InsertColorNtimes(int N, unsigned int _color, float brightness) {
       for(int i=0;i<N;i++) {
             InsertColor(_color, brightness);
       }
};
    
void LED_WS2812::InsertColorNtimes(int N, unsigned int _color) {
       InsertColorNtimes(N, _color, intensity*100/0xFF);
};
      
    
void LED_WS2812::InsertColor(LED_COLORS _color) {
      InsertColor((unsigned int)_color);
};
   
 
void LED_WS2812::InsertColor(LED_COLORS _color, float brightness) {
     InsertColor((unsigned int)_color, brightness);
};


void LED_WS2812::InsertColorNtimes(int N, LED_COLORS _color, float brightness) {
      InsertColorNtimes(N, (unsigned int)_color, brightness);
};
    
void LED_WS2812::InsertColorNtimes(int N, LED_COLORS _color) {
       InsertColorNtimes(N, _color, intensity*100/0xFF);
};
      
   
void LED_WS2812::SetIntensity(float perCent) {
    intensity = perCent*0xFF/100;
    ws->setII(intensity);
    for(int i=0;i<nbLeds;i++) {
            pxArray->SetI(i,intensity);
    }
}
 
void LED_WS2812::StartRotation(float interval) {
    if(rotationState==false) {
       rotationState = true;
       LEDSystemTick.attach_us(callback(this, &LED_WS2812::Rotate), interval*1000000);
    }
}


void LED_WS2812::StopRotation() {
    if(rotationState==true) {
        rotationState = false;
        rotationPosition = 0;
        LEDSystemTick.detach();
    }
}

void LED_WS2812::Rotate() {
    rotationPosition--;
    if (rotationPosition == -1)
        rotationPosition = nbLeds-1;
    if(!blinkState)  __writeBuf(rotationPosition);
}


void LED_WS2812::StartBlink(float interval) {
    StopBlink();
    if(blinkState==false) {
       blinkState = true;
       LEDBlinkSystemTick.attach_us(callback(this, &LED_WS2812::Blink), interval*1000000);
    }
}


void LED_WS2812::StopBlink() {
    if(blinkState==true) {
        blinkState = false;
        LEDBlinkSystemTick.detach();
    }
}

void LED_WS2812::Blink() {
    blinkONOFF = !blinkONOFF;
    if (blinkONOFF)
        __writeBuf(rotationPosition);
    else {
            ws->useII(WS2812::GLOBAL);
            ws->setII(0);
           __writeBuf(rotationPosition);
            ws->useII(WS2812::PER_PIXEL);
            ws->setII(intensity);
            
    }
        
}