#include "mbed.h"
#include "TextLCD.h"
#include "math.h"
PwmOut led1(LED1);
PwmOut led2(LED2);
PwmOut led3(LED3);
PwmOut led4(LED4);

PwmOut moter1(p21);
PwmOut moter2(p22);
DigitalIn sw1(p23);

TextLCD lcd(p24, p26, p27, p28, p29, p30);      // rs, e, d0-d3

void Change_Shine(bool BRIGHT){

    int i;

    int t_BecameShine;    
    int t_MaxShine;
    int t_MinShine;
    int t_NotShine;
    
    float rate;
    float rate_l;
    float Out1;
    float Out2;
    
    i = 0;
    
    Out1 = 0.0;
    Out2 = 0.0;
    t_BecameShine = 2000;
    t_MaxShine = 150;
    t_MinShine = 400;
    t_NotShine = 1200;
    rate = 0.7;
    rate_l = 0.4;


    if(BRIGHT){
        lcd.cls(); //clear
        lcd.locate(0,0); 
        lcd.printf("Shining now");
        for(i=0;i <= t_BecameShine ;i++){
            
            if(i <= t_MaxShine){
                Out1 = (float)i / t_MaxShine;
                Out2 = (float)i / t_MaxShine;
            }
            else if(i <= t_MinShine) {
                Out1 = (float) 1 - (1 - rate_l)*(i - t_MaxShine)/(t_MinShine - t_MaxShine);
            }
            else{
                Out1 = (float) 1 *(rate - rate_l)*(i - t_MinShine)/(t_BecameShine - t_MinShine) +rate_l;
            }
            
            lcd.locate(0,1); 
            lcd.printf("%f" ,Out1);
            
            moter1 = Out1;
            moter2 = Out1;
            wait(0.001);
        }
        moter1 = rate;
        moter2 = rate;
    }
    else{
        lcd.cls(); //clear
        lcd.locate(0,0); 
        lcd.printf("Not shining now");
        moter1 = rate;
        moter2 = rate;
        for(i=0;i<=t_NotShine;i++){
            Out1 = float(rate*(t_NotShine - i)/t_NotShine);
            Out2 = float(rate*(t_NotShine - i)/t_NotShine);
            lcd.locate(0,1); 
            lcd.printf("%f" ,Out1);
            moter1 = Out1;
            moter2 = Out2;
            wait(0.001);
        }
        moter1 = 0;
        moter2 = 0;
    }
}

int main() {
    
    int s = 0;        
    bool BRIGHT = false;
    
    sw1.mode( PullUp );
    
    moter1 = 0.0;
    moter2 = 0.0;
    moter1.period(0.001);
    moter2.period(0.001);

    //初期設定を光らないモードに設定
    lcd.cls(); //clear
    lcd.locate(0,0); 
    lcd.printf("Not shining now");

    while(1){
        //トリガのみのカウント
        //チャタリング防止のためタイマ有り
        //一度OFFになったことを検知するステータスフラグ、点灯消灯フラグを用い
        //１回だけ点灯消灯の関数を呼び出す。
        if(sw1 == 0 and s == 0) {
            s = 1;
            led1 = 1;
            BRIGHT = !BRIGHT;
            Change_Shine(BRIGHT);
            wait(0.001);
        }
        else if(sw1 == 1) {
            s = 0;
            led1 = 0;
        }
        wait(0.1);        
    }   
    
}
