#include "mbed.h"

#define wheelc 0.1759292
#define pi 3.141592654
//Status LED
DigitalOut led(LED1);

//Motor PWM (speed)
PwmOut PWMA(PA_8);
PwmOut PWMB(PB_4);

//Motor Direction
DigitalOut DIRA(PA_9);
DigitalOut DIRB(PB_10);

//Hall-Effect Sensor Inputs
InterruptIn HEA1(PB_2);
DigitalIn HEA2(PB_1);
InterruptIn HEB1(PB_15);
DigitalIn HEB2(PB_14);

//On board switch
DigitalIn SW1(USER_BUTTON);

//Use the serial object so we can use higher speeds
Serial terminal(USBTX, USBRX);

//Timer used for measuring speeds
Timer timer;

//Enumerated types
enum DIRECTION   {FORWARD=0, REVERSE};
enum PULSE           {NOPULSE=0, PULSE};
enum SWITCHSTATE {PRESSED=0, RELEASED};

//Debug GPIO
DigitalOut probe(D10);

//Duty cycles
float dutyA = 1.0f; //100%
float dutyB = 1.0f; //100%

//distance measurement
float distanceA ;
float distanceB ;
float speedA ;
float speedB ;
float wheel_spacing = 0.128;

int forward(float distance, float duty)
{
    int i;
        // Set motor direction forward
        DIRA = FORWARD;
        DIRB = FORWARD;
        // Set motor speed to input speed
    PWMA.write(duty);          //Set duty cycle (%)
    PWMB.write(duty);          //Set duty cycle (%)
        //reset distance
        distanceA = 0;
        distanceB = 0;
        timer.reset();
        timer.start();
        //wait for run to complete
        while (((distanceA+distanceB)/2) < distance)
        {
            i++;
        }
        return 1;
}

int turn(int degrees,float duty, float distance_outside_wheel_turn_point)
{
        //Set initial motor direction
    DIRA = FORWARD;
    DIRB = FORWARD;
    
        float C1 = (pi * 2 * distance_outside_wheel_turn_point)*(degrees/360);
        float C2 = (pi * 2 * (distance_outside_wheel_turn_point-wheel_spacing))*(degrees/360);
    //Set motor speed
    PWMA.write(duty);          //Set duty cycle (%)
    PWMB.write(duty*(C2/C1));          //Set duty cycle (%)
        //reset distance
        distanceA = 0;
        distanceB = 0;
        timer.reset();
        timer.start();
        //wait for turn to complete
        while (distanceA < C1)
        {
        }
                    return 1;
}

void set_distanceA()
{
        distanceA += (wheelc/6);
    terminal.printf("A =%f\n\r",distanceA);
}
    
void set_distanceB()
{
        distanceB += (wheelc/6);
    terminal.printf("B =%f\n\r",distanceB);

}


int main()
{
    //Configure the terminal to high speed
    terminal.baud(115200);

        HEA1.rise(set_distanceA);
        HEB1.rise(set_distanceB);
    //Set initial motor speed to stop
    PWMA.write(0.0f);           //0% duty cycle
    PWMB.write(0.0f);           //0% duty cycle
        PWMA.period_ms(10);
    PWMB.period_ms(10);
    while(1) {
            //wait for switch press
        while (SW1 == PRESSED) {
            wait(0.01);
            while(SW1 == RELEASED) {

                                //navigate course
                //for (int i = 0; i<2; i++) {
                    forward(10,50);
                            /*              terminal.printf("turn\n\r");
                    turn(90,50,0.20);
                                            terminal.printf("forward\n\r");
                    forward(1,50);
                                            terminal.printf("turn\n\r");
                    turn(90,50,0.20);*/
                                //}
                                PWMA.write(0.0f);           //0% duty cycle
                                PWMB.write(0.0f); 
                                wait(10);
                                //victory spin
               // turn(360,50,0.13);
            }
        }
    }
    }
