#include "mbed.h"

#define wheelc 0.1759292
//Status LED
DigitalOut led(LED1);

//Motor PWM (speed)
PwmOut PWMA(PA_8);
PwmOut PWMB(PB_4);

//Motor Direction
DigitalOut DIRA(PA_9);
DigitalOut DIRB(PB_10);

//Hall-Effect Sensor Inputs
DigitalIn HEA1(PB_2);
DigitalIn HEA2(PB_1);
DigitalIn HEB1(PB_15);
DigitalIn HEB2(PB_14);

//On board switch
DigitalIn SW1(USER_BUTTON);

//Use the serial object so we can use higher speeds
Serial terminal(USBTX, USBRX);

//Timer used for measuring speeds
Timer timer;

//Enumerated types
enum DIRECTION   {FORWARD=0, REVERSE};
enum PULSE           {NOPULSE=0, PULSE};
enum SWITCHSTATE {PRESSED=0, RELEASED};

//Debug GPIO
DigitalOut probe(D10);

//Duty cycles
float dutyA = 1.0f; //100%
float dutyB = 1.0f; //100%

int forward(float distance, int speed)
{
    //Set motor period to 100Hz
    dutyA = 5;
    dutyB = 5;
    PWMA.period_ms(speed);
    PWMB.period_ms(speed);

    //Set initial motor speed to stop
    PWMA.write(dutyA);          //Set duty cycle (%)
    PWMB.write(dutyB);          //Set duty cycle (%)


}

int turn(int degrees, bool direction)
{
    //Set motor period to 100Hz
    dutyA = 10;
    dutyB = 10;
    PWMA.period_ms(200);
    PWMB.period_ms(0);

    //Set initial motor speed to stop
    PWMA.write(dutyA);          //Set duty cycle (%)
    PWMB.write(dutyB);          //Set duty cycle (%)
    wait(0.676);
    dutyA = 0;
    dutyB = 0;
    PWMA.write(dutyA);          //Set duty cycle (%)
    PWMB.write(dutyB);          //Set duty cycle (%)
}
int main()
{
    //Configure the terminal to high speed
    terminal.baud(115200);

    //Set initial motor direction
    DIRA = FORWARD;
    DIRB = FORWARD;

    //Set initial motor speed to stop
    PWMA.write(0.0f);           //0% duty cycle
    PWMB.write(0.0f);           //0% duty cycle
    while(1) {
        while (SW1 == PRESSED) {
            wait(0.01);
            while(SW1 == RELEASED) {

                for (int i = 0; i<2; i++) {
                    forward(1,1);
                    wait(1.5);
                    turn(90,1);
                    forward(1,1);
                    wait(0.75);
                    turn(90,1);

                }
                sleep();
            }
        }
    }
    //Set initial motor speed to stop
    PWMA.write(0);          //Set duty cycle (%)
    PWMB.write(0);          //Set duty cycle (%)



}
