#include "mbed.h"
Ticker counter;
int count;
float adc, volts, inches;
bool one;
int iterations;
int timeout;
PortOut Rows(PortC,0xFF);
PortOut Cols(PortD,0b111111111);

const char message[113]= {
    0b001111100,
    0b000010100,
    0b000010100,
    0b000000000,
    0b001000100,
    0b001111100,
    0b001000100,
    0b000000000,
    0b001111100,
    0b000011000,
    0b000110000,
    0b001111100,
    0b000000000,
    0b001000100,
    0b001111100,
    0b001000100,
    0b000000000,
    0b001011000,
    0b001010100,
    0b000110100,
    0b000000000,
    0b001111100,
    0b000010000,
    0b001111100,
    0b000000000, //25, 0 starts at 25
    0b011111101, //0 26
    0b010000001,
    0b010000001,
    0b011111101,
    0b000000000,//1
    0b010000100,
    0b011111101,
    0b010000000,
    0b011110001,//2
    0b010010001,
    0b010010001,
    0b010011101,
    0b010010001,//3
    0b010010001,
    0b010010001,
    0b011111101,
    0b000011101,//4
    0b000010000,
    0b000010000,
    0b011111101,
    0b010011101,//5
    0b010010001,
    0b010010001,
    0b011110001,
    0b011111101,//6
    0b010010001,
    0b010010001,
    0b011110000,
    0b000000001,//7
    0b000000001,
    0b000000001,
    0b011111101,
    0b011111101,//8
    0b010010001,
    0b010010001,
    0b011111101,
    0b010011101,//9
    0b010010001,
    0b010010001,
    0b011111101,
    0b000000000,//s0 starts 66
    0b001111100,
    0b001000100,
    0b001111100,
    0b000000000,//s1
    0b001001000,
    0b001111100,
    0b001000000,
    0b000000000,//s2
    0b001110100,
    0b001010100,
    0b001011100,
    0b000000000,//s3
    0b001010100,
    0b001010100,
    0b001111100,
    0b000000000,//s4
    0b000011100,
    0b000010000,
    0b001111100,
    0b000000000,//s5
    0b001011100,
    0b001010100,
    0b001110100,
    0b000000000,//s6
    0b001111100,
    0b001010100,
    0b001110100,
    0b000000000,//s7
    0b000000100,
    0b000000100,
    0b001111100,
    0b000000000,//s8
    0b001111100,
    0b001010100,
    0b001111100,
    0b000000000,//s9
    0b001011100,
    0b001010100,
    0b001111100,
    0b001100100,//Zz  starts 106
    0b001110100,
    0b001011100,
    0b001001100,
    0b000000000,
    0b001100100,
    0b001010100,
    0b001011100,
};
AnalogIn ain(A0);

DigitalOut buzzer(PTE5);


float t = 0.001;

void printfinish(int fin)
{
    int rw,i,is;
    //write eyes
    is = fin;
    int j=is+8;
    for(i=is; i<j; i++) {
        rw=0;
        rw=1<<(i-is);
        Cols=rw;
// this inverts the row code so that only the desired row is low
        Rows=~message[i];
        wait(t);
        Rows = 0;
        Cols=0;
    }
}

void printunit(int ks)
{
    int rws,k;
    //write eyes
    int unitsortens;
    
    int l=ks+4;
    for(k=ks; k<l; k++) {
        rws=0;
        if (ks<63) {
        unitsortens=  k-ks;
    } else {
        unitsortens=k-ks+4;
    }
        rws=1<<unitsortens;
        Cols=rws;
// this inverts the row code so that only the desired row is low
        Rows=~message[k];
        wait(t);
        Rows = 0;
        Cols =0;
    }
}

void printingtens(int tens)
{

    switch (tens) {
        case 0:
            printunit(25);
            break;
        case 1:
            printunit(29);
            break;
        case 2:
            printunit(33);
            break;
        case 3:
            printunit(37);
            break;
        case 4:
            printunit(41);
            break;
        case 5:
            printunit(45);
            break;
        case 6:
            printunit(49);
            break;
        case 7:
            printunit(53);
            break;
        case 8:
            printunit(57);
            break;
        case 9:
            printunit(61);
            break;
    }
}
void printingunits(int units)
{
    switch (units) {

        case 0:
            printunit(65);
            break;
        case 1:
            printunit(69);
            break;
        case 2:
            printunit(73);
            break;
        case 3:
            printunit(77);
            break;
        case 4:
            printunit(81);
            break;
        case 5:
            printunit(85);
            break;
        case 6:
            printunit(89);
            break;
        case 7:
            printunit(93);
            break;
        case 8:
            printunit(97);
            break;
        case 9:
            printunit(101);
            break;
    }
}
void finish()
{
    int delay=2100;
    while (delay<7200) {
        int cases = delay/300;
        switch (cases) {
                //case 0:
//                x1=0;
//                x2=0;
//                x3=0;
//                x4=0;
//                x5=0;
//                x6=0;
//                x7=0;
//                x8=1;
//                y1=1;
//                y2=0;
//                y3=0;
//                y4=0;
//                y5=0;
//                y6=0;
//                y7=1;
//                y8=1;
//                wait(t);
//                delay=delay+1;
//                break;
//
//            case 1:
//                x1=0;
//                x2=0;
//                x3=0;
//                x4=0;
//                x5=0;
//                x6=0;
//                x7=1;
//                x8=0;
//                y1=1;
//                y2=0;
//                y3=0;
//                y4=0;
//                y5=0;
//                y6=0;
//                y7=1;
//                y8=1;
//                wait(t);
//                delay=delay+1;
//                x7=0;
//                x8=1;
//                y3=1;
//                y5=1;
//                y6=1;
//                wait(t);
//                delay= delay+1;
//                break;
//
//            case 2:
//                x1=0;
//                x2=0;
//                x3=0;
//                x4=0;
//                x5=0;
//                x6=1;
//                x7=0;
//                x8=0;
//                y1=1;
//                y2=0;
//                y3=0;
//                y4=0;
//                y5=0;
//                y6=0;
//                y7=1;
//                y8=1;
//                wait(t);
//                delay= delay+1;
//                x6=0;
//                x7=1;
//                y3=1;
//                y5=1;
//                y6=1;
//                wait(t);
//                delay= delay+1;
//                x7=0;
//                x8=1;
//                wait(t);
//                delay= delay+1;
//                break;
//            case 3:
//                x1=0;
//                x2=0;
//                x3=0;
//                x4=0;
//                x5=1;
//                x6=0;
//                x7=0;
//                x8=0;
//                y1=1;
//                y2=0;
//                y3=0;
//                y4=0;
//                y5=0;
//                y6=0;
//                y7=1;
//                y8=1;
//                wait(t);
//                delay= delay+1;
//                x5=0;
//                x6=1;
//                y3=1;
//                y5=1;
//                y6=1;
//                wait(t);
//                delay= delay+1;
//                x6=0;
//                x7=1;
//                wait(t);
//                delay= delay+1;
//                x7=0;
//                wait(t);
//                delay= delay+1;
//                break;
//            case 4:
//                x1=0;
//                x2=0;
//                x3=0;
//                x4=1;
//                x5=0;
//                x6=0;
//                x7=0;
//                x8=0;
//                y1=1;
//                y2=0;
//                y3=0;
//                y4=0;
//                y5=0;
//                y6=0;
//                y7=1;
//                y8=1;
//                wait(t);
//                delay= delay+1;
//                x4=0;
//                x5=1;
//                y3=1;
//                y5=1;
//                y6=1;
//                wait(t);
//                delay= delay+1;
//                x5=0;
//                x6=1;
//                wait(t);
//                delay= delay+1;
//                x6=0;
//                wait(t);
//                delay= delay+1;
//                x8=1;
//                y4=1;
//                y6=0;
//                wait(t);
//                delay= delay+1;
//                break;
//            case 5:
//                x1=0;
//                x2=0;
//                x3=1;
//                x4=0;
//                x5=0;
//                x6=0;
//                x7=0;
//                x8=0;
//                y1=1;
//                y2=0;
//                y3=0;
//                y4=0;
//                y5=0;
//                y6=0;
//                y7=1;
//                y8=1;
//                wait(t);
//                delay= delay+1;
//                x3=0;
//                x4=1;
//                y3=1;
//                y5=1;
//                y6=1;
//                wait(t);
//                delay= delay+1;
//                x4=0;
//                x5=1;
//                wait(t);
//                delay= delay+1;
//                x5=0;
//                wait(t);
//                delay= delay+1;
//                x7=1;
//                y4=1;
//                y6=0;
//                wait(t);
//                delay= delay+1;
//                x7=0;
//                x8=1;
//                y3=0;
//                y4=0;
//                y5=0;
//                wait(t);
//                delay= delay+1;
//                break;
//            case 6:
//                x1=0;
//                x2=1;
//                x3=0;
//                x4=0;
//                x5=0;
//                x6=0;
//                x7=0;
//                x8=0;
//                y1=1;
//                y2=0;
//                y3=0;
//                y4=0;
//                y5=0;
//                y6=0;
//                y7=1;
//                y8=1;
//                wait(t);
//                delay= delay+1;
//                x2=0;
//                x3=1;
//                y3=1;
//                y5=1;
//                y6=1;
//                wait(t);
//                delay= delay+1;
//                x3=0;
//                x4=1;
//                wait(t);
//                delay= delay+1;
//                x4=0;
//                wait(t);
//                delay= delay+1;
//                x6=1;
//                y4=1;
//                y6=0;
//                wait(t);
//                delay= delay+1;
//                x6=0;
//                x7=1;
//                y3=0;
//                y4=0;
//                y5=0;
//                wait(t);
//                delay= delay+1;
//                x7=0;
//                x8=1;
//                y3=1;
//                y4=1;
//                y5=1;
//                wait(t);
//                delay= delay+1;
//                break;
            case 7:
                printfinish(0);
                delay=delay+8;
                break;
            case 8:
                printfinish(1);
                delay=delay+8;
                break;
            case 9:
                printfinish(2);
                delay=delay+8;
                break;
            case 10:
                printfinish(3);
                delay=delay+8;
                break;
            case 11:
                printfinish(4);
                delay=delay+8;
                break;
            case 12:
                printfinish(5);
                delay=delay+8;
                break;
            case 13:
                printfinish(6);
                delay=delay+8;
                break;
            case 14:
                printfinish(7);
                delay=delay+8;
                break;
            case 15:
                printfinish(8);
                delay=delay+8;
                break;
            case 16:
                printfinish(9);
                delay=delay+8;
                break;
            case 17:
                printfinish(10);
                delay=delay+8;
                break;
            case 18:
                printfinish(11);
                delay=delay+8;
                break;
            case 19:
                printfinish(12);
                delay=delay+8;
                break;
            case 20:
                printfinish(13);
                delay=delay+8;
                break;
            case 21:
                printfinish(14);
                delay=delay+8;
                break;
            case 22:
                printfinish(15);
                delay=delay+8;
                break;
            case 23:
                printfinish(16);
                delay=delay+8;
                break;
                //case 24:
//                x1=1;
//                x2=0;
//                x3=0;
//                x4=0;
//                x5=0;
//                x6=0;
//                x7=0;
//                x8=0;
//                y1=1;
//                y2=1;
//                y3=0;
//                y4=0;
//                y5=1;
//                y6=0;
//                y7=1;
//                y8=1;
//                wait(t);
//                delay= delay+1;
//                x1=0;
//                x2=1;
//                y2=0;
//                y3=1;
//                wait(t);
//                delay = delay+1;
//                x2=0;
//                x3=1;
//                y6=1;
//                y5=0;
//                wait(t);
//                delay = delay+1;
//                x3=0;
//                wait(t);
//                delay = delay+1;
//                x5=1;
//                y3=0;
//                y6=0;
//                wait(t);
//                delay = delay+1;
//                x5=0;
//                x6=1;
//                y2=1;
//                y3=1;
//                y5=1;
//                y6=1;
//                wait(t);
//                delay = delay+1;
//                x6=0;
//                x7=1;
//                y2=0;
//                y3=0;
//                y5=0;
//                y6=0;
//                wait(t);
//                delay = delay+1;
//                x7=0;
//                break;
//            case 25:
//                x1=1;
//                x2=0;
//                x3=0;
//                x4=0;
//                x5=0;
//                x6=0;
//                x7=0;
//                x8=0;
//                y1=1;
//                y2=0;
//                y3=1;
//                y4=0;
//                y5=1;
//                y6=0;
//                y7=1;
//                y8=1;
//                wait(t);
//                delay= delay+1;
//                x1=0;
//                x2=1;
//                y6=1;
//                y5=0;
//                wait(t);
//                delay = delay+1;
//                x2=0;
//                wait(t);
//                delay = delay+1;
//                x4=1;
//                y3=0;
//                y6=0;
//                wait(t);
//                delay = delay+1;
//                x4=0;
//                x5=1;
//                y2=1;
//                y3=1;
//                y5=1;
//                y6=1;
//                wait(t);
//                delay = delay+1;
//                x5=0;
//                x6=1;
//                y2=0;
//                y3=0;
//                y5=0;
//                y6=0;
//                wait(t);
//                delay = delay+1;
//                x7=0;
//                x6=0;
//                break;
//            case 26:
//                x1=1;
//                x2=0;
//                x3=0;
//                x4=0;
//                x5=0;
//                x6=0;
//                x7=0;
//                x8=0;
//                y1=1;
//                y2=0;
//                y3=1;
//                y4=0;
//                y5=0;
//                y6=1;
//                y7=1;
//                y8=1;
//                wait(t);
//                delay= delay+1;
//                x1=0;
//                wait(t);
//                delay = delay+1;
//                x3=1;
//                y3=0;
//                y6=0;
//                wait(t);
//                delay = delay+1;
//                x3=0;
//                x4=1;
//                y2=1;
//                y3=1;
//                y5=1;
//                y6=1;
//                wait(t);
//                delay = delay+1;
//                x4=0;
//                x5=1;
//                y2=0;
//                y3=0;
//                y5=0;
//                y6=0;
//                wait(t);
//                delay = delay+1;
//                x7=0;
//                x6=0;
//                x5=0;
//                break;
//            case 27:
//                x1=0;
//                x2=0;
//                x3=0;
//                x4=0;
//                x5=0;
//                x6=0;
//                x7=0;
//                x8=0;
//                y1=1;
//                y2=0;
//                y3=1;
//                y4=0;
//                y5=0;
//                y6=1;
//                y7=1;
//                y8=1;
//                wait(t);
//                delay= delay+1;
//                x2=1;
//                y3=0;
//                y6=0;
//                wait(t);
//                delay = delay+1;
//                x2=0;
//                x3=1;
//                y2=1;
//                y3=1;
//                y5=1;
//                y6=1;
//                wait(t);
//                delay = delay+1;
//                x3=0;
//                x4=1;
//                y2=0;
//                y3=0;
//                y5=0;
//                y6=0;
//                wait(t);
//                delay = delay+1;
//                x7=0;
//                x6=0;
//                x5=0;
//                x4=0;
//                break;
//            case 28:
//                x1=1;
//                x2=0;
//                x3=0;
//                x4=0;
//                x5=0;
//                x6=0;
//                x7=0;
//                x8=0;
//                y1=1;
//                y2=0;
//                y3=0;
//                y4=0;
//                y5=0;
//                y6=0;
//                y7=1;
//                y8=1;
//                wait(t);
//                delay= delay+1;
//                x1=0;
//                x2=1;
//                y2=1;
//                y3=1;
//                y5=1;
//                y6=1;
//                wait(t);
//                delay = delay+1;
//                x2=0;
//                x3=1;
//                y2=0;
//                y3=0;
//                y5=0;
//                y6=0;
//                wait(t);
//                delay = delay+1;
//                x7=0;
//                x6=0;
//                x5=0;
//                x4=0;
//                x3=0;
//                break;
//            case 29:
//                x1=1;
//                x2=0;
//                x3=0;
//                x4=0;
//                x5=0;
//                x6=0;
//                x7=0;
//                x8=0;
//                y1=1;
//                y2=1;
//                y3=1;
//                y4=0;
//                y5=1;
//                y6=1;
//                y7=1;
//                y8=1;
//                wait(t);
//                delay= delay+1;
//                x1=0;
//                x2=1;
//                y2=0;
//                y3=0;
//                y5=0;
//                y6=0;
//                wait(t);
//                delay = delay+1;
//                x7=0;
//                x6=0;
//                x5=0;
//                x4=0;
//                x3=0;
//                x2=0;
//                break;
//            case 30:
//                x1=1;
//                x2=0;
//                x3=0;
//                x4=0;
//                x5=0;
//                x6=0;
//                x7=0;
//                x8=0;
//                y1=1;
//                y2=0;
//                y3=0;
//                y4=0;
//                y5=0;
//                y6=0;
//                y7=1;
//                y8=1;
//                wait(t);
//                delay= delay+1;
//                x7=0;
//                x6=0;
//                x5=0;
//                x4=0;
//                x3=0;
//                x2=0;
//                x1=0;
//                break;

        }
    }
}
void counting()
{
    if (count ==00) {
        count = 99;
    }
    if (one == true) {
        adc = ain.read();           // read analog as a float
        volts = adc * 3.3;          // convert to volts
//        inches = (volts / 0.0064) ;    // 3.3V supply: ~6.4mV per inch
//        out = (int) inches;
//        printf("one is true %f\r\n", volts);
        if(volts < 0.055) {
            buzzer = 1;
            wait(0.01);
            buzzer = 0;
            one = false;
            timeout = 0;
        } else {
            buzzer = 0;
            timeout = timeout+1;   // ~20Hz update rate ; note we aren't
        }
    }
    if (one == false) {
        adc = ain.read();
        volts = adc*3.3;
//        printf("one is false %f\r\n", volts);
        if (volts > 0.1) {

            count = count -1;
            one = true;
            timeout = 0;
        } else {
            buzzer = 0;
            timeout = timeout+1;   // ~20Hz update rate ; note we aren't
        }
    }
}
void timeouts()
{
    printfinish(105);
}

int main()
{

    count = 10;
    one = true;
    iterations = 1;

    while (1) {
        while (iterations < 6) {

            int tens = count/10;
            int units = count % 10;
            if (timeout >200) {
                timeouts();
            } else {
                printingtens(tens);
                printingunits(units);
            }
            iterations= iterations+1;
        }
        if (count ==0) {
            finish();
        }
        counting();
        iterations = 1;
    }

}



