#include "mbed.h"
#include "MMA8451Q.h"

#define DEBUG
#define INFOMESSAGES
#define WARNMESSAGES
#define ERRMESSAGES

#define FUNCNAME "MAIN"



#if   defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
PinName const SDA = PTE25;
PinName const SCL = PTE24;
#elif defined (TARGET_KL05Z)
PinName const SDA = PTB4;
PinName const SCL = PTB3;
#elif defined (TARGET_K20D50M)
PinName const SDA = PTB1;
PinName const SCL = PTB0;
#else
#error TARGET NOT DEFINED
#endif

#define MMA8451_I2C_ADDRESS (0x1d<<1)


#ifdef NoDEBUG
#define DBG(x, ...) pc.printf("    ["FUNCNAME" : DBG] "x" <line %d>\r\n", ##__VA_ARGS__,__LINE__);
#else
#define DBG(x, ...)
#endif

#ifdef ERRMESSAGES
#define ERR(x, ...) pc.printf(" ["FUNCNAME" : ERR] "x"\r\n", ##__VA_ARGS__);
#else
#define ERR(x, ...)
#endif

#ifdef WARNMESSAGES
#define WARN(x, ...) printf("["FUNCNAME" : WARN] "x"\r\n", ##__VA_ARGS__);
#else
#define WARN(x, ...)
#endif

#ifdef INFOMESSAGES
#define INFO(x, ...) pc.printf("["FUNCNAME" : INFO] "x"\r\n",##__VA_ARGS__);
#else
#define INFO(x, ...)
#endif

#define BUFF_SIZE 1024
// PIN DEFS NOW FOR OLD FIRMWARE VERSION OF THE KL25Z
Serial  pc(USBTX, USBRX);
//RawSerial  dev(D1, D0);
Serial  dev(PTE22,PTE23); //tx,rx
DigitalOut led1(LED1);
DigitalOut led4(LED3); // CHANGE TO LED 3
DigitalOut reset(PTB0,1);



PwmOut led(LED_GREEN);
//    TSISensor tsi;
volatile int state=0;
volatile int ready=0;
int glue=0;
char ipAddress[20];
char macAddress[32];
char *buffer;
unsigned int bufferPnt=0;
int zcount;
int xcount;
char resp;

float a;
float b;
char * OKResponse(char *test, const char *pattern)
{
    char *p= strstr(test,pattern);
    if (p==NULL) {
        //   DBG("Test=<%s> Patter=<%s> NULL [p=%s]",test,pattern,p);
        return NULL;
    } else {
        //  DBG("YAY Test=<%s> Patter=<%s>  [p=%s]",test,pattern,p);
    }
    return p;
}

void dev_recv()
{
    char c;



    led1 = !led1;
    if(bufferPnt==0) {
        memset(buffer,0,BUFF_SIZE);
    }
    while(dev.readable()) {
        c = (char)dev.getc();
#ifdef DEBUG
        pc.putc(c);
#endif
        buffer[bufferPnt]=c;
        bufferPnt++;
        if (bufferPnt>1000) {
            ready=1;
        }
        // if ((c==0x0a)||(c==0x0d)){
        //     ready=1;
        //     }else
        if (c==0x0a) {
            if (bufferPnt>1) {
                if (buffer[bufferPnt -2]==0x0d) {
                    ready=1;
                    break;
                }
            }
        }
        if (!dev.readable()) {
            wait_us(10);
        }
    }
}
void sendinfo()
{
    pc.printf(".......zc=%02u\r\n",zcount);

    // resp=OKResponse(buffer,"OK");
//   if (resp!=NULL) {
    INFO("Ready 10");
    dev.printf("AT+CIPSEND=4,4\r\n");
    wait(0.1);


    wait(0.1);
//  while (OKResponse(buffer,">")!=NULL){
//   printf(".\r\n");
//  wait(1);
//  };

    INFO("SENDING");

    wait(0.2);
    dev.printf("%02u\r\n",zcount);
}

void pc_recv()
{
    char c;
    led4 = !led4;
    while(pc.readable()) {
        c=(char)pc.getc();
        dev.putc(c);
        pc.putc(c);
        if(c==13) {
            dev.putc(10);
            pc.putc(10);
        }

    }
}


int main()
{
    MMA8451Q acc(SDA, SCL, MMA8451_I2C_ADDRESS);

    buffer=(char *)calloc(BUFF_SIZE,1);
    reset=0;
    b=1.0;
    a=1.0;
    zcount=0;               // initial conditions of values
    xcount=0;
    float x;
    float z;
    pc.baud(115200);
    dev.baud(115200);
    pc.attach(&pc_recv, Serial::RxIrq);
    dev.attach(&dev_recv, Serial::RxIrq);
    pc.printf("Start up\n\r");
    wait(3.0);
    reset=1;
    char * resp=NULL;
    pc.printf("Here \n\r");
    while(1) {
        if (ready) {
            ready=0;
            bufferPnt=0;
            INFO("[%d],##%s##",state,buffer);
            switch (state) {
                case 0: {                                           //sets up microcontroller as client
                    resp=OKResponse(buffer,"WIFI GOT IP");
                    if (resp!=NULL) {
                        wait(1);
                        dev.printf("AT\r\n");
                        state++;
                    }
                    break;
                }
                case 1:
                case 2: {
                    resp=OKResponse(buffer,"OK");
                    if (resp!=NULL) {
                        dev.printf("AT\r\n");
                        state++;
                    }
                    break;
                }
                case 3: {
                    resp=OKResponse(buffer,"OK");
                    if (resp!=NULL) {
                        dev.printf("AT+RST\r\n");
                        state++;
                    }

                    break;
                }
                case 4: {
                    resp=OKResponse(buffer,"WIFI GOT IP");
                    if (resp!=NULL) {
                        dev.printf("AT+CWMODE=1\r\n");
                        state++;
                    }

                    break;
                }
                case 5: {
                    resp=OKResponse(buffer,"OK");
                    if (resp!=NULL) {

                        dev.printf("AT+CWJAP=\"BTHub3-WXWX\",\"fdd6f7c682\"\r\n");
                        state++;
                    }

                    break;
                }
                case 6: {
                    resp=OKResponse(buffer,"OK");
                    if (resp!=NULL) {
                        wait(1);
                        dev.printf("AT+CIFSR\r\n");
                        state++;
                    }

                    break;
                }
                case 7: {
                    resp=OKResponse(buffer,"+CIFSR:STAIP,");
                    if (resp!=NULL) {
                        char *strt = strtok(buffer,"\"");
                        strcpy(ipAddress,strtok(NULL,"\""));
                        strtok(NULL,"\"");
                        strcpy(macAddress,strtok(NULL,"\""));
                        INFO("mac Address = %s", macAddress);
                        INFO("IP Address = %s", ipAddress);
                        dev.printf("AT+CIPMUX=1\r\n");
                        state++;
                    }

                    break;
                }
                case 8: {
                    resp=OKResponse(buffer,"OK");
                    if (resp!=NULL) {

                        INFO("Ready 8");
                        dev.printf("AT+CIPSTART=4,\"TCP\",\"192.168.1.91\",8080\r\n");
                        state++;
                        wait(0.1);

                    }

                    break;
                }
                case 9: {

                    resp=OKResponse(buffer,"OK");
                    if (resp!=NULL) {

                        INFO("Ready 9");
                        state++;
                        zcount=0;
                        a=1.0;

                    }

                }
                case 10: {

                    resp=OKResponse(buffer,"OK");
                    if (resp!=NULL) {
                        INFO("Ready 10");
                        dev.printf("AT+CIPSEND=4,9\r\n");
                        wait(0.1);

                    }
                    wait(0.1);
                    //  while (OKResponse(buffer,">")!=NULL){
                    //   printf(".\r\n");
                    //  wait(1);
                    //  };

                    INFO("SENDING");

                    wait(0.2);
                    dev.printf("PEDOMETER\r\n");
                    state++;      //send greeting to server
                    break;
                    case 11: {
                        while (true) {

                            z = (acc.getAccX());  //changes it from measureing Z driection for press ups to X for running
                            x = (acc.getAccZ());

                            if (a==1.0) {
                               
                                if (z<0.0) {
                                    a=0.0;
                                    
                                    zcount++;

                                    sendinfo();



                                }


                                if (z>0) {
                                    a=1.0;      //prevents multiple signals for singal dip below zero
                                }
                            }
                            if (a==0) {
                                if (z<0) {
                                    a=0.0;
                                }
                                if (z>0) {
                                    a=1.0;
                                }
                            }
                            if (b==1) {
                                if (x<0) {
                                    b=0.0;
                                    xcount=xcount+1;
                                    //printf("Xcount: %u \n\r",xcount);

                                }
                                if (x>0) {
                                    b=1.0;
                                }
                            }

                            if (b==0) {
                                if (x<0) {
                                    b=0.0;
                                }
                                if (x>0) {
                                    b=1.0;
                                }
                            }

                        }
                        break;
                    }
                }
                //__WFI(); // DELETED AS IT KILLS THE KL25 RESPONSIVITY
            }

        }
    }
}
