#include "mbed.h"
/*******************************************************************************

  EXAMPLE DESCRIPTION

  Sets digital in on PA_0 with internal pull up. State of digital in is 
  periodically read in main program loop. When button is pressed, onboard LED
  is toggled.
  
*******************************************************************************/
DigitalIn button(PA_0, PullUp); // deffition of interrupt

DigitalOut LED(LED1); // definition of digital out pin

int main()
{
    bool set= false; // LED already toggled

    while(1) {
        if(button==0 && !set){
            LED=!LED;
            set=true;   
        }else if(button==1 && set){
            set=false;    
        }
        
        wait_ms(1);
    }

}
