/**********************************************************************************
* @file    main.cpp
* @author  Petr Dousa
* @version V0.1
* @date    09-March-2015
* @brief   Read PC_15, PC_14 and PC_13 and if they're on high level, LED is blinking,
***********************************************************************************/

/**************************************************************************************************************************************************/
/*                                                                    Table how to find 0xE000                                                    */
/**************************************************************************************************************************************************/
/* Num.        |   15  |   14  |   13  |   12  ||   11  |   10  |   9   |   8   ||   7   |   6   |   5   |   4   ||   3   |   2   |   1   |   0   */
/* Num. of pin | PC_15 | PC_14 | PC_13 | PC_12 || PC_11 | PC_10 | PC_9  | PC_8  || PC_7  | PC_6  | PC_5  | PC_4  || PC_3  | PC_2  | PC_1  | PC_0  */
/* Num. in BIN |   1   |   1   |   1   |   0   ||   0   |   0   |   0   |   0   ||   0   |   0   |   0   |   0   ||   0   |   0   |   0   |   0   */
/* Num. in HEX |               E               ||               0               ||               0               ||               0               */
/**************************************************************************************************************************************************/

/* Includes ----------------------------------------------------------------------*/
#include "mbed.h"

/* Defines -----------------------------------------------------------------------*/

/* Function prototypes -----------------------------------------------------------*/

/* Variables ---------------------------------------------------------------------*/

//mbed - initialization of peripherals
PortIn myIOs(PortC, 0xE000); // initialize port PC_15 + PC_14 + PC_13
DigitalOut myled(LED1);      // initialize LED
 
 /* Functions----------------------------------------------------------------------*/
 
 
/***********************************************************************************
* Function Name  : main.
* Description    : Main routine.
* Input          : None.
* Output         : None.
* Return         : None.
***********************************************************************************/
int main() {
  myIOs.mode(PullNone); // PullDown PullUp PullNone OpenDrain
  while(1) {
    if (myIOs.read() != 0xE000 && myIOs != 0xE000) { // Any of the 3 IOs is low, change led state
      myled = !myled; // Toggle LED state
      wait(0.2);
    }
  }
}
 