/* Bluetooth low energy demo application
 * Copyright (c) 2015 Adam Berlinger
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "mbed.h"
#include "DemoAppService.h"


extern bool user_button_pressed;
bool connected = false;
bool UpdatedEnabled = false;

DemoAppService *demoService;
PwmOut led(LED1);

void demoCallback(uint8_t event){
    /* Nastaveni stridy PWM signalu */
    if(event & DemoAppService::EVENT_SLIDER1_CHANGED){
        int x = 1 << (demoService->getSlider1Value() / 10);
        led.write((float)(x / (float)(1 << 10)));
    }
    /* Nastaveni periody PWM signalu */
    if(event & DemoAppService::EVENT_SLIDER2_CHANGED){
        led.period(1.0f / (demoService->getSlider2Value() + 1));
    }
}

int main(void)
{
  demoService = startDemoBLE("Demo App");
  demoService->setCallback(demoCallback);

  led = 0.0f;

  while (true) 
  {
    demoService->waitForEvent();
  }
}
