/**********************************************************************************
* @file    main.cpp
* @author  Vaclav Moravcik
* @version V1.0
* @date    3-May-2015
* @brief   Simple controling of LED from PC via UART.
***********************************************************************************/

/* Includes ----------------------------------------------------------------------*/
#include "mbed.h"

/* Defines -----------------------------------------------------------------------*/

/* Function prototypes -----------------------------------------------------------*/

/* Variables ---------------------------------------------------------------------*/

//mbed - initialization of peripherals
Serial pc(SERIAL_TX, SERIAL_RX); 
DigitalOut myled(LED1);

/* Functions----------------------------------------------------------------------*/

/*******************************************************************************
* Function Name  : main.
* Description    : Main routine.
* Input          : None.
* Output         : None.
* Return         : None.
*******************************************************************************/
int main() {
    char ch;
    while (1) {
        if(pc.readable()){  //Determine if there is a character available to read
            ch = pc.getc(); //Read char from terminal
            pc.printf("%c\n", ch);
            if(ch == 'a'){  //If 'a' is pressed then turn LED on 
                myled = 1;    
            }
            if(ch == 'd'){  //If 'd' is pressed then turn LED off
                myled = 0;    
            }
        }
    }
    
}
 