/**********************************************************************************
* @file    main.cpp
* @author  Petr Dousa
* @version V1.00
* @date    22-March-2015
* @brief   Every single second push to serial message and read from serial
*          Serial speed is set to 115200.
***********************************************************************************/

/* Includes ----------------------------------------------------------------------*/
#include "mbed.h"

/* Defines -----------------------------------------------------------------------*/
#define buffer_size 256             // incoming buffer size
#define buffer_fill buffer_size+1   // number, when buffer is ready

/* Function prototypes -----------------------------------------------------------*/
void serialRx();
int serialGetBuffer(char * & data);

/* Variables ---------------------------------------------------------------------*/
// additional variables for incoming data
char serial_buffer[buffer_size];    // buffer to save incoming data
char serial_buffer2[buffer_size];   // second buffer to save incoming data
int serial_buffer_where=0;          // index array for buffer
int serial_buffer2_where=0;         // index array for second buffer
bool serial_end_line = false;       // searching for end line

//mbed - initialization of peripherals
Serial pc(SERIAL_TX, SERIAL_RX);
DigitalOut myled(LED1);

/* Functions----------------------------------------------------------------------*/

/*******************************************************************************
* Function Name  : serialRx.
* Description    : Incoming interruption fom serial. Fill two buffers with
*                  incoming data and prepare it to serialGetBuffer.
* Input          : None.
* Output         : None.
* Return         : None.
*******************************************************************************/
void serialRx()
{
    while(pc.readable()) {                                                  // read all data from serial
        char character=pc.getc();                                           // get a char form serial
        if(((int)character==10 || (int)character==13) && serial_end_line) { // search for end line /r or /n
            serial_end_line=true;                                           // end was find in the previous charascter, skip
            continue;
        } else {
            serial_end_line=false;                                          // clear serial_end_line flag
        }
        if(serial_buffer_where!=buffer_fill && !(serial_buffer2_where != 0 && serial_buffer2_where!=buffer_fill)) {
            serial_buffer[serial_buffer_where++]=character;
            if(serial_buffer_where==buffer_size) {                          // check if incoming data are smaller than buffer size
                serial_buffer[buffer_size-1]='\0';                          // posibility to lost data, if the incoming data are too big
                serial_buffer_where=buffer_fill;                            // set index array to indicate buffer fill
                continue;
            }
            if(character==13 || character==10) {                            // if end of line (\r \n) is indicated, prepare the buffer to serialGetBuffer
                serial_buffer[serial_buffer_where-1]='\0';                  // set end of buffer with 0
                serial_buffer_where=buffer_fill;                            // set index array to indicate buffer fill
                serial_end_line=true;                                       // end of line was find, set serial_end_line flag
            }
        } else if(serial_buffer2_where!=buffer_fill) {                      // same for second buffer
            serial_buffer2[serial_buffer2_where++]=character;
            if(serial_buffer2_where==buffer_size) {
                serial_buffer2[buffer_size-1]='\0';
                serial_buffer2_where=buffer_fill;
                continue;
            }
            if(character==13 || character==10) {
                serial_buffer2[serial_buffer2_where-1]='\0';
                serial_buffer2_where=buffer_fill;
                serial_end_line=true;
            }
        } /*else {                                                      // the buffers are full and thedata are lost
            while(!pc.writeable());
            pc.printf("Code is too slow!\n");
            //pc.printf("I get: \"%c\", DEC: %d\n",character,(int)character);
        }*/
    }
}

/*******************************************************************************
* Function Name  : serialGetBuffer.
* Description    : Timer overflow handle. Blinks the LED.
* Input          : Char array with size buffer_size.
* Output         : Char array with incoming data.
* Return         : 0 - on no data, 1 - one buffer is fill, 2 -two buffers are fill (posibility to lost data)
*******************************************************************************/
int serialGetBuffer(char * & data)
{
    if(serial_buffer_where==buffer_fill && serial_buffer2_where==buffer_fill) {
        data=serial_buffer;
        //memcpy(data, serial_buffer, strlen(serial_buffer)+1);
        serial_buffer_where=0;
        return 2;
    } else if(serial_buffer2_where==buffer_fill) {
        data=serial_buffer2;
        //memcpy(data, serial_buffer2, strlen(serial_buffer2)+1);
        serial_buffer2_where=0;
        return 1;
    } else if(serial_buffer_where==buffer_fill) {
        data=serial_buffer;
        //memcpy(data, serial_buffer, strlen(serial_buffer)+1);
        serial_buffer_where=0;
        return 1;
    } else {
        return 0;
    }
}

/***********************************************************************************
* Function Name  : main.
* Description    : Main routine.
* Input          : None.
* Output         : None.
* Return         : None.
***********************************************************************************/
int main()
{
    int i = 1;
    int j = 0;
    int k = 0;

    //array for data that are coming to user
    char * prijata_data;

    pc.baud(115200);                        // set serial speed to 115200
    pc.attach(&serialRx,Serial::RxIrq);     // attach serialRx to reception interrupt
    pc.printf("Hello World !\n");

    while(1) {
        wait_ms(10);                        // wait 1 second
        if(serialGetBuffer(prijata_data)) { // get char array from serial
            sscanf (prijata_data,"%d",&j);  // sscanf for searching integer
            pc.printf("From PC:%d.\n" ,j);  // write to serial incoming integer
        }
        
        k++;

        if (k>=100) {
            pc.printf("This program runs since %d seconds.\n", i++);    // write some string to serial

            myled = !myled;   // blink LED
            
            k=0;
        }
    }
}

