/**********************************************************************************
* @file    main.cpp
* @author  Petr Dousa
* @version V1.00
* @date    30-March-2015
* @brief   Blinks every single second LED and on PB_3 generate PWM
*          Serial speed is set to 115200.
***********************************************************************************/

/**********************************************************************************/
/*                    Table of PWM pins on Nucleo F303 (LQFP64)                   */
/**********************************************************************************/
/*  LQFP64 pin   |   Nucleo pin   |   ST Pin   |    PWM number    |    Channel    */
/*      15       |      A1        |    PA_1    |      PWM15       |       1       */
/*      26       |      A3        |    PB_0    |      PWM1        |       2       */
/*       9       |      A4        |    PC_1    |      PWM1        |       2       */
/*       8       |      A5        |    PC_0    |      PWM1        |       1       */
/*      17       |      D0        |    PA_3    |      PWM15       |       2       */
/*      16       |      D1        |    PA_2    |      PWM15       |       1       */
/*      43       |      D2        |    PA_10   |      PWM1        |       3       */
/*      55       |      D3        |    PB_3    |      PWM8        |       1       */
/*      57       |      D4        |    PB_5    |      PWM17       |       1       */
/*      56       |      D5        |    PB_4    |      PWM16       |       1       */
/*      41       |      D7        |    PA_8    |      PWM1        |       1       */
/*      42       |      D8        |    PA_9    |      PWM1        |       2       */
/*      38       |      D9        |    PC_7    |      PWM3        |       2       */
/*      58       |      D10       |    PB_6    |      PWM16       |       1       */
/*      23       |      D11       |    PA_7    |      PWM15       |       2       */
/*      22       |      D12       |    PA_6    |      PWM15       |       1       */
/*      62       |      D14       |    PB_9    |      PWM17       |       1       */
/*      61       |      D15       |    PB_8    |      PWM16       |       1       */
/*      46       |                |    PA_13   |      PWM16       |       1       */
/*      49       |                |    PA_14   |      PWM8        |       2       */
/*      59       |                |    PB_7    |      PWM17       |       1       */
/*       2       |                |    PC_13   |      PWM1        |       1       */
/*      10       |                |    PC_2    |      PWM1        |       3       */
/*      11       |                |    PC_3    |      PWM1        |       4       */
/*      40       |                |    PC_9    |      PWM3        |       4       */
/*      39       |                |    PC_8    |      PWM3        |       3       */
/*      37       |                |    PC_6    |      PWM3        |       1       */
/*      45       |                |    PA_12   |      PWM16       |       1       */
/*      44       |                |    PA_11   |      PWM1        |       4       */
/*      27       |                |    PB_1    |      PWM1        |       3       */
/*      36       |                |    PB_15   |      PWM17       |       1       */
/*      35       |                |    PB_14   |      PWM16       |       1       */
/**********************************************************************************/

/* Includes ----------------------------------------------------------------------*/
#include "mbed.h"

/* Defines -----------------------------------------------------------------------*/
/* Function prototypes -----------------------------------------------------------*/
/* Variables ---------------------------------------------------------------------*/
//mbed - initialization of peripherals
Serial pc(SERIAL_TX, SERIAL_RX);
DigitalOut  my_led(LED1);       // blink LED
PwmOut      my_pwm(PB_3);       // PWM output
/* Functions----------------------------------------------------------------------*/



/***********************************************************************************
* Function Name  : flushSerialPort.
* Description    : Serial flush rountine.
* Input          : None.
* Output         : None.
* Return         : None.
***********************************************************************************/
void flushSerialPort()
{
    while(pc.readable())
        pc.getc();
    return;
}

/***********************************************************************************
* Function Name  : menu.
* Description    : Print menu to serial.
* Input          : None.
* Output         : None.
* Return         : None.
***********************************************************************************/
void menu()
{
    while(!pc.writeable());         // wait for serial to be free to send
    pc.printf("HELP - MENU\n");     // send text to serial
    while(!pc.writeable());
    pc.printf("Input format: \"xx yy\", where xx is the setting and yy is the value.\n");
    while(!pc.writeable());
    pc.printf("01 yyy - set up duty-cycle from 0 to 100, example:01 80\n");
    while(!pc.writeable());
    pc.printf("02 yyyyy - set up period in ms from 0 to 10000, example:02 10\n");
    while(!pc.writeable());
    pc.printf("end HELP\n");
}

/***********************************************************************************
* Function Name  : main.
* Description    : Main routine.
* Input          : None.
* Output         : None.
* Return         : None.
***********************************************************************************/
int main()
{
    int rcvdData=0;
    int Data1=0;
    int Data2=0;

    pc.baud(115200);
    pc.printf("\nPWM.\n");
    menu(); //print menu
    // Set PWM
    my_pwm.period_ms(10);
    my_pwm.write(0.5);

    while(1) {
        //accepted data from serial
        rcvdData=pc.scanf("%d",&Data1);                     // read number from serial
        if(rcvdData==1 && (Data1>=1 && Data1<=2)) {         // test if number was read and if it's between 1 and 2
            rcvdData=pc.scanf("%d",&Data2);                 // read int number from serial
            if(rcvdData==1 && Data2<=100 && Data2>=0 && Data1==1) {
                rcvdData=2;         // set variable to 2 - parse data
            } else if(rcvdData==1 && Data2>=0 && Data2<=10000 && Data1==2) {
                rcvdData=2;         // set variable to 2 - parse data
            } else {
                flushSerialPort();  // discard all data from serial
                rcvdData=0;         // set variable to print menu
            }
        } else {
            flushSerialPort();      // discard all data from serial
            rcvdData=0;             // set variable to print menu
        }

        if(rcvdData==2) {
            if(Data1==1) {
                my_pwm.write((double)Data2/(double)100);    // set duty-cycle
            } else if(Data1==2) {
                my_pwm.period_ms(Data2);                    // set period in ms
            }
        } else {
            menu();                 // print menu
            pc.printf("\n Bad data.\n");
            flushSerialPort();      // discard all data from serial
        }
    }
}
