/**********************************************************************************
* @file    main.cpp
* @author  Petr Dousa
* @version V1.00
* @date    22-March-2015
* @brief   Reads analog value and send it to serial.
*          Serial speed is set to 115200.
***********************************************************************************/

/**********************************************************************************/
/*                 Table of A/D pins on Nucleo F303 (LQFP64)                      */
/**********************************************************************************/
/*  LQFP64 pin   |   Nucleo pin   |   ST Pin   |   AD Number      |    Channel    */
/*       8       |      A5        |    PC_0    |      ADC12       |       6       */
/*       9       |      A4        |    PC_1    |      ADC12       |       7       */
/*      14       |      A0        |    PA_0    |      ADC1        |       1       */
/*      15       |      A1        |    PA_1    |      ADC1        |       2       */
/*      16       |      D1        |    PA_2    |      ADC1        |       3       */
/*      17       |      D0        |    PA_3    |      ADC1        |       4       */
/*      20       |      A2        |    PA_4    |      ADC2        |       1       */
/*      21       |      D13       |    PA_5    |      ADC2        |       2       */
/*      22       |      D12       |    PA_6    |      ADC2        |       3       */
/*      23       |      D11       |    PA_7    |      ADC2        |       4       */
/*      26       |      A3        |    PB_0    |      ADC3        |       12      */
/**********************************************************************************/

/* Includes ----------------------------------------------------------------------*/
#include "mbed.h"

/* Defines -----------------------------------------------------------------------*/
#define voltage 3300
// raw value to value in millivolts
#define mv1(x)       (x*voltage)
#define mv2(x)       ((x*voltage)/0xFFFF)
#define mv3(x)       (x*voltage)

/* Function prototypes -----------------------------------------------------------*/

/* Variables ---------------------------------------------------------------------*/

//mbed - initialization of peripherals
AnalogIn analog_value(A0);          // initialize analog read from A0
DigitalOut led(LED1);               // initialize LED
Serial pc(SERIAL_TX, SERIAL_RX);    // initialize Serial to connect to PC

/* Functions----------------------------------------------------------------------*/

/***********************************************************************************
* Function Name  : main.
* Description    : Main routine.
* Input          : None.
* Output         : None.
* Return         : None.
***********************************************************************************/
int main()
{

    float meas1;
    int meas2;
    float meas3;
    
    pc.baud(115200);                //set serial speed to 115200
    pc.printf("\nAnalogIn example\n");

    while(1) {
        meas1 = analog_value.read();        // Converts and reads the analog input value (value from 0.0 to 1.0)
        meas1 = mv1(meas1);                 // Changes the value to be in the 0 to 3300 range

        meas2 = analog_value.read_u16();    // Converts and reads the analog input value (value from 0.0 to 0xFFFF)
        meas2 = mv2(meas2);                 // Changes the value to be in the 0 to 3300 range

        meas3 = analog_value;               // Converts and reads the analog input value (value from 0.0 to 1.0)
        meas3 = mv3(meas3);                 // Changes the value to be in the 0 to 3300 range

        pc.printf("measure = %.0f mV, %d mV, %.0f mV\n", meas1,meas2,meas3);
        if (meas1 > 2000 && meas2 > 2000 && meas3 > 2000) { // If the value is greater than 2V then switch the LED on
            led = 1;
        } else {
            led = 0;
        }
        wait(0.2); // 200 ms
    }
}
