/**********************************************************************************
* @file    main.cpp
* @author  Petr Dousa
* @version V1.00
* @date    22-March-2015
* @brief   LEDs blinking with LSM303.
*          With push button pressed, LEDs are opposite.
***********************************************************************************/

/**********************************************************************************/
/*   Table of used pins on STM32F3 Discovery kit                                  */
/**********************************************************************************/
/*  Discovery pin  | ST Nucleo F303RE pin  |      peripheral                      */
/*      PA_0       |         PC_13         |      User button                     */
/*  PE_8 to PE_15  |         PA_5          |      LEDs                             */
/**********************************************************************************/

/* Includes ----------------------------------------------------------------------*/

#include "mbed.h"
#include "LSM303DLHC.h"         //library necessary to comunicate with LSM303DLHC
#include "stm32f3xx_hal_gpio.h" //library necessary to blink LEDs on STM32F3 discovery

/* Defines -----------------------------------------------------------------------*/

// In some mbed libraries these defines are not included
// please uncomment if the example is not working

//#define GPIOE_BASE          (AHB2PERIPH_BASE + 0x1000)
//#define GPIOE               ((GPIO_TypeDef *) GPIOE_BASE)
//#define RCC_AHBENR_GPIOEEN ((uint32_t)0x00200000)
//#define RCC_AHBPeriph_GPIOE RCC_AHBENR_GPIOEEN

/* Function prototypes -----------------------------------------------------------*/

/* Variables ---------------------------------------------------------------------*/
bool oppos = false;

//mbed - initialization of peripherals
InterruptIn my_button(PA_0);

//LSM303DLHC - initialization of peripherals
LSM303DLHC compass(PB_7, PB_6);

/* Functions----------------------------------------------------------------------*/

/*******************************************************************************
* Function Name  : pressed.
* Description    : Blinks whit 8 LEDs if button is pressed and change variables.
* Input          : None.
* Output         : Blinks whit 8 LEDs and set variable.
* Return         : None.
*******************************************************************************/
void pressed()
{
    // Toggle pins PE_15 to PE_8, where LEDs are attached to
    HAL_GPIO_TogglePin(GPIOE,GPIO_PIN_14 | GPIO_PIN_15 | GPIO_PIN_13 | GPIO_PIN_12 | GPIO_PIN_11 | GPIO_PIN_10 | GPIO_PIN_9 | GPIO_PIN_8);
    //inverts oppos
    oppos = !oppos;
}

/***********************************************************************************
* Function Name  : main.
* Description    : Main routine.
* Input          : None.
* Output         : None.
* Return         : None.
***********************************************************************************/
int main()
{
    float ax, ay, az;
    float mx, my, mz;

   //initialize power (clock source) to port E (GPIOE)
    __GPIOE_CLK_ENABLE();
    //  RCC->AHBENR |= RCC_AHBPeriph_GPIOE; // if __GPIOE_CLK_ENABLE(); is not defined

    // initialize pins
    // structure to set GPIO
    GPIO_InitTypeDef        GPIO_InitStruct;
    // Specifies the operating mode for the selected pins.
    // Output Push Pull Mode 
    GPIO_InitStruct.Mode = GPIO_MODE_OUTPUT_PP;
    // Specifies the Pull-up or Pull-Down activation for the selected pins.
    // Pull-up activation
    GPIO_InitStruct.Pull = GPIO_PULLUP;
    // Specifies the speed for the selected pins.
    // High speed
    GPIO_InitStruct.Speed = GPIO_SPEED_HIGH;
    // Specifies the GPIO pins to be configured.
    // Pins 15 to 8
    GPIO_InitStruct.Pin = GPIO_PIN_15 | GPIO_PIN_14 | GPIO_PIN_13 | GPIO_PIN_12 | GPIO_PIN_11 | GPIO_PIN_10 | GPIO_PIN_9 | GPIO_PIN_8;
    
    // Initialize pins PE_15 to PE_8
    HAL_GPIO_Init(GPIOE, &GPIO_InitStruct); 
    
    // button was pressed, call function pressed
    my_button.fall(&pressed);

    while (1) {
        //read value from compass
        compass.read(&ax, &ay, &az, &mx, &my, &mz);
        //calculate angle
        double heading = atan2(my, mx);
        if (heading < 0)
            heading += 2 * 3.14159265359;
        heading=heading * (double)180 / 3.14159265359;
        //set LEDs
        if(heading>=338 || heading<23) { // compare angle
            // on value oppos set (reset) one LED and reset the other (set)
            HAL_GPIO_WritePin(GPIOE,GPIO_PIN_15,oppos?GPIO_PIN_SET:GPIO_PIN_RESET);
            HAL_GPIO_WritePin(GPIOE,GPIO_PIN_14 | GPIO_PIN_13 | GPIO_PIN_12 | GPIO_PIN_11 | GPIO_PIN_10 | GPIO_PIN_9 | GPIO_PIN_8,oppos?GPIO_PIN_RESET:GPIO_PIN_SET);
        }
        if(heading>=23 && heading<68) {
            HAL_GPIO_WritePin(GPIOE,GPIO_PIN_14,oppos?GPIO_PIN_SET:GPIO_PIN_RESET);
            HAL_GPIO_WritePin(GPIOE,GPIO_PIN_15  | GPIO_PIN_13 | GPIO_PIN_12 | GPIO_PIN_11 | GPIO_PIN_10 | GPIO_PIN_9 | GPIO_PIN_8,oppos?GPIO_PIN_RESET:GPIO_PIN_SET);
        }
        if(heading>=68 && heading<113) {
            HAL_GPIO_WritePin(GPIOE,GPIO_PIN_13,oppos?GPIO_PIN_SET:GPIO_PIN_RESET);
            HAL_GPIO_WritePin(GPIOE,GPIO_PIN_15 | GPIO_PIN_14 | GPIO_PIN_12 | GPIO_PIN_11 | GPIO_PIN_10 | GPIO_PIN_9 | GPIO_PIN_8,oppos?GPIO_PIN_RESET:GPIO_PIN_SET);
        }
        if(heading>=113 && heading<158) {
            HAL_GPIO_WritePin(GPIOE,GPIO_PIN_12,oppos?GPIO_PIN_SET:GPIO_PIN_RESET);
            HAL_GPIO_WritePin(GPIOE,GPIO_PIN_15 | GPIO_PIN_14 | GPIO_PIN_13 | GPIO_PIN_11 | GPIO_PIN_10 | GPIO_PIN_9 | GPIO_PIN_8,oppos?GPIO_PIN_RESET:GPIO_PIN_SET);
        }
        if(heading>=158 && heading<203) {
            HAL_GPIO_WritePin(GPIOE,GPIO_PIN_11,oppos?GPIO_PIN_SET:GPIO_PIN_RESET);
            HAL_GPIO_WritePin(GPIOE,GPIO_PIN_15 | GPIO_PIN_14 | GPIO_PIN_13 | GPIO_PIN_12  | GPIO_PIN_10 | GPIO_PIN_9 | GPIO_PIN_8,oppos?GPIO_PIN_RESET:GPIO_PIN_SET);
        }
        if(heading>=203 && heading<248) {
            HAL_GPIO_WritePin(GPIOE,GPIO_PIN_10,oppos?GPIO_PIN_SET:GPIO_PIN_RESET);
            HAL_GPIO_WritePin(GPIOE,GPIO_PIN_15 | GPIO_PIN_14 | GPIO_PIN_13 | GPIO_PIN_12 | GPIO_PIN_11 | GPIO_PIN_9 | GPIO_PIN_8,oppos?GPIO_PIN_RESET:GPIO_PIN_SET);
        }
        if(heading>=248 && heading<293) {
            HAL_GPIO_WritePin(GPIOE,GPIO_PIN_9,oppos?GPIO_PIN_SET:GPIO_PIN_RESET);
            HAL_GPIO_WritePin(GPIOE,GPIO_PIN_15 | GPIO_PIN_14 | GPIO_PIN_13 | GPIO_PIN_12 | GPIO_PIN_11 | GPIO_PIN_10 | GPIO_PIN_8,oppos?GPIO_PIN_RESET:GPIO_PIN_SET);
        }
        if(heading>=293 && heading<338) {
            HAL_GPIO_WritePin(GPIOE,GPIO_PIN_8,oppos?GPIO_PIN_SET:GPIO_PIN_RESET);
            HAL_GPIO_WritePin(GPIOE,GPIO_PIN_15 | GPIO_PIN_14 | GPIO_PIN_13 | GPIO_PIN_12 | GPIO_PIN_11 | GPIO_PIN_10 | GPIO_PIN_9,oppos?GPIO_PIN_RESET:GPIO_PIN_SET);
        }
    }
}

