/**********************************************************************************
* @file    main.cpp
* @author  Name
* @version V0.1
* @date    09-March-2015
* @brief   LEDs blinking with ticker.
*          With push button pressed, LEDs turn on.
***********************************************************************************/

/**********************************************************************************/
/*   Table of used pins on STM32F3 Discovery kit                                  */
/**********************************************************************************/
/*  Discovery pin  | ST Nucleo F303RE pin  |      peripheral                      */
/*      PA_0       |         PC_13         |      User button                     */
/*  PE_8 to PE_15  |         PA_5          |      LEDs                             */
/**********************************************************************************/

/* Includes ----------------------------------------------------------------------*/

#include "mbed.h"
#include "stm32f3xx_hal_gpio.h" //library necessary to blink LEDs on STM32F3 discovery

/* Defines -----------------------------------------------------------------------*/

// In some mbed libraries these defines are not included
// please uncomment if the example is not working

//#define GPIOE_BASE          (AHB2PERIPH_BASE + 0x1000)
//#define GPIOE               ((GPIO_TypeDef *) GPIOE_BASE)
//#define RCC_AHBENR_GPIOEEN ((uint32_t)0x00200000)
//#define RCC_AHBPeriph_GPIOE RCC_AHBENR_GPIOEEN


//mbed - initialization of peripherals
InterruptIn button(PA_0);       // initialize button on STM32F3 discovery
Ticker toggle_ticker;           // initialize ticker


/* Functions----------------------------------------------------------------------*/

/*******************************************************************************
* Function Name  : toggle.
* Description    : Blinks with 8 LEDs if ticker interval reached.
* Input          : None.
* Output         : Blinks with 8 LEDs.
* Return         : None.
*******************************************************************************/

void toggle()
{
    // Toggle pins PE_15 to PE_8 , where LEDs are attached to
    HAL_GPIO_TogglePin(GPIOE,GPIO_PIN_15 | GPIO_PIN_14 | GPIO_PIN_13 | GPIO_PIN_12 | GPIO_PIN_11 | GPIO_PIN_10 | GPIO_PIN_9 | GPIO_PIN_8);
}

/*******************************************************************************
* Function Name  : pressed.
* Description    : Set LEDs on if someone pressed the button.
* Input          : None.
* Output         : None.
* Return         : None.
*******************************************************************************/
void pressed()
{
    // Switch pins PE_15 to PE_8 (LEDs) to high level
    HAL_GPIO_WritePin(GPIOE , GPIO_PIN_15 | GPIO_PIN_14 | GPIO_PIN_13 | GPIO_PIN_12 | GPIO_PIN_11 | GPIO_PIN_10 | GPIO_PIN_9 | GPIO_PIN_8 , GPIO_PIN_SET);
}

/***********************************************************************************
* Function Name  : main.
* Description    : Main routine.
* Input          : None.
* Output         : None.
* Return         : None.
***********************************************************************************/

int main()
{
    //initialize power (clock source) to port E (GPIOE)
    __GPIOE_CLK_ENABLE();
    //  RCC->AHBENR |= RCC_AHBPeriph_GPIOE; // if __GPIOE_CLK_ENABLE(); is not defined

    // initialize pins
    // structure to set GPIO
    GPIO_InitTypeDef        GPIO_InitStruct;
    // Specifies the operating mode for the selected pins.
    // Output Push Pull Mode 
    GPIO_InitStruct.Mode = GPIO_MODE_OUTPUT_PP;
    // Specifies the Pull-up or Pull-Down activation for the selected pins.
    // Pull-up activation
    GPIO_InitStruct.Pull = GPIO_PULLUP;
    // Specifies the speed for the selected pins.
    // High speed
    GPIO_InitStruct.Speed = GPIO_SPEED_HIGH;
    // Specifies the GPIO pins to be configured.
    // Pins 15 to 8
    GPIO_InitStruct.Pin = GPIO_PIN_15 | GPIO_PIN_14 | GPIO_PIN_13 | GPIO_PIN_12 | GPIO_PIN_11 | GPIO_PIN_10 | GPIO_PIN_9 | GPIO_PIN_8;
    
    // Initialize pins PE_15 to PE_8
    HAL_GPIO_Init(GPIOE, &GPIO_InitStruct);

    // Button was pressed, call function pressed()
    button.fall(&pressed);

    // Init the ticker with the address of the function (toggle) to be attached and the interval (1 s)
    toggle_ticker.attach(&toggle, 1);

    // infinite loop
    while (1) {
    }
}
