/**********************************************************************************
* @file    main.cpp
* @author  Marta Krepelkova
* @version V0.1
* @date    11-March-2015
* @brief   LED blinking with button for STM32F0 Discovery kit
***********************************************************************************/
 
/**********************************************************************************/
/*   Table of used pins on STM32F0 Discovery kit with STM32F051R8 MCU (LQFP64)    */
/**********************************************************************************/
/*  LQFP64 pin   | Discovery pin  | ST Nucleo F030R8 pin  |      peripheral       */
/*      14       |     PA_0       |         PC_13         |      User button      */
/*      39       |     PC_8       |         PA_5          |      LED              */
/*      40       |     PC_9       |                       |      LED              */
/**********************************************************************************/
 
/* Includes ----------------------------------------------------------------------*/
#include "mbed.h"

/* Defines -----------------------------------------------------------------------*/

/* Function prototypes -----------------------------------------------------------*/ 

/* Variables ---------------------------------------------------------------------*/ 
bool press = false;             // boolean value, says if was the button pressed

//mbed - initialization of peripherals
InterruptIn button(PA_0);       // initialize button on STM32F0 discovery
DigitalOut blue(PC_8);          // initialize blue LED on STM32F0 discovery
DigitalOut green(PC_9);         // initialize green LED on STM32F0 discovery

/* Functions----------------------------------------------------------------------*/
 
/*******************************************************************************
* Function Name  : pressed.
* Description    : Changes value "press" if someone pressed the button.
* Input          : None.
* Output         : None.
* Return         : None.
*******************************************************************************/ 
void pressed()
{
    if (press == false){        // variable press was false (button wasn't pressed yet)
        press = true;           // press is true (button was pressed)
    }else{                      // variable press was true
        press = false;          // press is false
    }
}
  
/*******************************************************************************
* Function Name  : main.
* Description    : Main routine.
* Input          : None.
* Output         : None.
* Return         : None.
*******************************************************************************/
int main()
{
    blue=1;                     // blue LED is off
    green=0;                    // green LED is on
    button.fall(&pressed);      // button was pressed, call function pressed
    
    while (1) {                 // infinite loop
        green = !green;         // inverts the value of green LED
        if (press == false){    // button wasn't pressed
            blue=!green;        // the value of blue LED is inverse to green LED
            wait(0.4);          // wait 400 ms
        }else{                  // button was pressed
            blue=green;         // the value of blue LED is same like the value of green LED
            wait(0.2);          // wait 200 ms
            green = !green;     // inverts value of green LED
            wait(0.2);          // wait 200 ms
            green = !green;     // inverts value of green LED
            wait(0.2);          // wait 200 ms
        }
    }
}