/****************************************************
*            FAST PROTOTYPING WITH NUCLEO           *
* Example Code 11: Servo pwm                        *
* Author: Mauro D'Angelo                            *
*****************************************************/

#include "mbed.h"

// Instanzia un oggetto di tipo PwmOut sul pin PWM_OUT e gli da il nome mypwm
PwmOut mypwm(PB_3);

// Instanzia un oggetto di tipo DigitalOut sul pin LED1 e gli da il nome myled
DigitalOut myled(LED1);

// Instanzia un oggetto di tipo Serial sui pin Tx e Rx della porta USB e gli da il nome pc (trattandosi della porta USB connessa al PC)
Serial pc(USBTX, USBRX);

// Entry point
int main() {
      
    //Set pwm signal period: The period needed to control the motor in the servo datasheet
    mypwm.period_ms(20);
    
    // In questa funzione l'ampiezza dell'impulso e' passata in secondi e di tipo float
    mypwm.pulsewidth(0);
    wait(0.1);
    mypwm.pulsewidth(0.0005);
    wait(0.1);
    mypwm.pulsewidth(0.001);
    wait(0.1);
    mypwm.pulsewidth(0.0015);
    wait(0.1);
    mypwm.pulsewidth(0.002);
    
    // Print the pwm duty cycle in percentage
    pc.printf("pwm set to %.2f %%\n", mypwm.read() * 100);
    
    // Blink led   
    while(1) {
        // Modifica lo stato del led (toggle)
        myled = !myled;
        wait(0.1);
    }
}

// *** ESPERIMENTI ***
// [1] Modifica il valore passato nel metodo pulsewidth(). Passa valori consentiti e non consentiti secondo il datasheet del motore