/****************************************************
*            FAST PROTOTYPING WITH NUCLEO           *
* Example Code 08: Interrupt usage                  *
* Author: Mauro D'Angelo                            *
*****************************************************/

#include "mbed.h"

// Definisco un interrupt sullo User Button 
InterruptIn mybutton(USER_BUTTON);

// Instanzio un oggetto DigitalOut associato al led embedded sulla board
DigitalOut myled(LED1);

// Variabile ritardo 
float delay = 1.0; // 1 sec


// Funzione servita all'occorrenza dell'interrupt
// Modifica la durata del blink del led 
void pressed()
{
    if (delay == 1.0)
        delay = 0.2; // 200 ms
    else
        delay = 1.0; // 1 sec
}
 
int main()
{
    // Assegna all'interrupt la funzione pressed
    mybutton.fall(&pressed);
    
    // Lampeggio LED
    while (1) {
        myled = !myled;
        wait(delay);
    }
}
 
