/****************************************************
*            FAST PROTOTYPING WITH NUCLEO           *
* Example Code 07: Thread usage                     *
* Author: Mauro D'Angelo                            *
*****************************************************/

#include "mbed.h"
#include "rtos.h"

// Instanzia un oggetto DigitalIn a cui viene associato lo User Button
DigitalIn mybutton(USER_BUTTON);

// Instanzia un oggetto di tipo DigitalOut
DigitalOut myled(LED1);

// Variabile alla quale viene assegnato il tempo tra l'accensione e lo spegnimento 
float delay = 0;

// Implementa la funzione associata al Thread
// Quando viene premuto il pulsante (mybutton == 0) 
// viene impostato il nuovo valore della variabile delay
void button_thread(void const *args) {
    while(true) {
        if (mybutton == 0) { // Button is pressed
            if (delay == 1.0)
                delay = 0.2; // 200 ms
            else
                delay = 1.0; // 1 sec
        }// if button
     }
}

int main() {  
    // Threads start here
    Thread button_th(button_thread);
    
    // Blinking led
    while(true) {
        myled = !myled;
        wait(delay);
    }
}
