/****************************************************
*            FAST PROTOTYPING WITH NUCLEO           *
* Example Code 03: Timer                            *
* Author: Mauro D'Angelo                            *
*****************************************************/
/*------------------------------------
* Hyperterminal configuration
* 9600 bauds, 8-bit data, no parity
*------------------------------------*/

#include "mbed.h"

Timer timer;
Serial pc(USBTX, USBRX);
DigitalOut myled(LED1);


int main() {
  timer.start();
  int i = 1;
  pc.printf("Hello World !\n");
  while(1) { 
      wait(1);
      pc.printf("This program runs since %d seconds.\r\n", timer.read_ms()/1000);
      myled = !myled;
  }
}
 