#include "mbed.h"

// p5: DIN, p7: CLK, p8: LOAD/CS
SPI max72_spi(PA_7, NC, PA_5);
DigitalOut load(PB_6);
DigitalOut buzzer(PC_4);

int maxInUse = 1;    //change this variable to set how many MAX7219's you'll use

// define max7219 registers
#define max7219_reg_noop         0x00
#define max7219_reg_digit0       0x01
#define max7219_reg_digit1       0x02
#define max7219_reg_digit2       0x03
#define max7219_reg_digit3       0x04
#define max7219_reg_digit4       0x05
#define max7219_reg_digit5       0x06
#define max7219_reg_digit6       0x07
#define max7219_reg_digit7       0x08
#define max7219_reg_decodeMode   0x09
#define max7219_reg_intensity    0x0a
#define max7219_reg_scanLimit    0x0b
#define max7219_reg_shutdown     0x0c
#define max7219_reg_displayTest  0x0f

#define LOW 0
#define HIGH 1
#define MHZ 1000000

void maxSingle( int reg, int col) {
//maxSingle is the "easy"  function to use for a
//single max7219
    load = LOW;            // begin
    max72_spi.write(reg);  // specify register
    max72_spi.write(col);  // put data
    load = HIGH;           // make sure data is loaded (on rising edge of LOAD/CS)
}

void maxAll (int reg, int col) {    // initialize  all  MAX7219's in the system
    load = LOW;                    // begin
    for ( int c=1; c<= maxInUse; c++) {
        max72_spi.write(reg);  // specify register
        max72_spi.write(col);  // put data
    }
    load = HIGH;
}

void maxOne(int maxNr, int reg, int col) {
//maxOne is for adressing different MAX7219's,
//while having a couple of them cascaded
    int c = 0;
    load = LOW;

    for ( c = maxInUse; c > maxNr; c--) {
        max72_spi.write(0);  // no-op
        max72_spi.write(0);  // no-op
    }

    max72_spi.write(reg);  // specify register
    max72_spi.write(col);  // put data

    for ( c=maxNr-1; c >= 1; c--) {
        max72_spi.write(0);  // no-op
        max72_spi.write(0);  // no-op
    }
    load = HIGH;
}


void setup () {
    // initiation of the max 7219
    // SPI setup: 8 bits, mode 0
    max72_spi.format(8, 0);
    
    // going by the datasheet, min clk is 100ns so theoretically 10MHz should work...
    // max72_spi.frequency(10*MHZ);
    
    maxAll(max7219_reg_scanLimit, 0x07);
    maxAll(max7219_reg_decodeMode, 0x00);  // using an led matrix (not digits)
    maxAll(max7219_reg_shutdown, 0x01);    // not in shutdown mode
    maxAll(max7219_reg_displayTest, 0x00); // no display test
    for (int e=1; e<=8; e++) {    // empty registers, turn all LEDs off
        maxAll(e,0);
    }
    maxAll(max7219_reg_intensity, 0x0f & 0x0f);    // the first 0x0f is the value you can set
    // range: 0x00 to 0x0f
}

void loop () {


    //if you use just one MAX7219 it should look like this
 /*    maxSingle(1,1);                       //  + - - - - - - -
     maxSingle(2,2);                       //  - + - - - - - -
     maxSingle(3,4);                       //  - - + - - - - -
     maxSingle(4,8);                       //  - - - + - - - -
     maxSingle(5,16);                      //  - - - - + - - -
     maxSingle(6,32);                      //  - - - - - + - -
     maxSingle(7,64);                      //  - - - - - - + -
     maxSingle(8,128);                     //  - - - - - - - +
*/
    //if you use more than one MAX7219, it should look like this

    
    maxAll(1,1);                       //  + - - - - - - -
    maxAll(2,3);                       //  + + - - - - - -
    maxAll(3,7);                       //  + + + - - - - -
    maxAll(4,15);                      //  + + + + - - - -
    maxAll(5,31);                      //  + + + + + - - -
    maxAll(6,63);                      //  + + + + + + - -
    maxAll(7,127);                     //  + + + + + + + -
    maxAll(8,255);                     //  + + + + + + + +
    

    //

    //if you use more then one max7219 the second one should look like this


    /*
    maxOne(2,1,1);                       //  + - - - - - - -
    maxOne(2,2,2);                       //  - + - - - - - -
    maxOne(2,3,4);                       //  - - + - - - - -
    maxOne(2,4,8);                       //  - - - + - - - -
    maxOne(2,5,16);                      //  - - - - + - - -
    maxOne(2,6,32);                      //  - - - - - + - -
    maxOne(2,7,64);                      //  - - - - - - + -
    maxOne(2,8,128);                     //  - - - - - - - +

    */
    
    //

    wait_ms(2000);

}

int main() {
    setup ();

    while(1)
    {
            loop ();
                wait(1);
    buzzer = 1;
    wait(0.5);
    buzzer = 0;
        wait(0.5);
    }
}



/* 06_spi_max7219_led8x8
 *
 * Simple demo to drive a 8x8-as LED matrix by a MAX7219 LED driver IC
 * After initialisation two characters (H and W) are displayed alternatively.
 * The MAX7219 IC is driven by hardware SPI: SPI0 module at PTD1, PTD2, PTD3.
 */
 /*
#include "mbed.h"
 
SPI spi(PA_7, PA_6, PA_5);          // Arduino compatible MOSI, MISO, SCLK
DigitalOut cs(PB_6);                // Chip select
DigitalOut myled(LED1);
 
const unsigned char led1[]= {
    0xFF,0x18,0x18,0x18,0x18,0x18,0x18,0xFF
};  //H
const unsigned char led2[]= {
    0x1F,0x60,0x80,0x40,0x40,0x80,0x60,0x1F
};  //W
 
/// Send two bytes to SPI bus
void SPI_Write2(unsigned char MSB, unsigned char LSB)
{
    cs = 0;                         // Set CS Low
    spi.write(MSB);                 // Send two bytes
    spi.write(LSB);
    cs = 1;                         // Set CS High
}
 
/// MAX7219 initialisation
void Init_MAX7219(void)
{
    SPI_Write2(0x09, 0x00);         // Decoding off
    SPI_Write2(0x0A, 0x08);         // Brightness to intermediate
    SPI_Write2(0x0B, 0x07);         // Scan limit = 7
    SPI_Write2(0x0C, 0x01);         // Normal operation mode
    SPI_Write2(0x0F, 0x0F);         // Enable display test
    wait_ms(500);                   // 500 ms delay
    SPI_Write2(0x01, 0x00);         // Clear row 0.
    SPI_Write2(0x02, 0x00);         // Clear row 1.
    SPI_Write2(0x03, 0x00);         // Clear row 2.
    SPI_Write2(0x04, 0x00);         // Clear row 3.
    SPI_Write2(0x05, 0x00);         // Clear row 4.
    SPI_Write2(0x06, 0x00);         // Clear row 5.
    SPI_Write2(0x07, 0x00);         // Clear row 6.
    SPI_Write2(0x08, 0x00);         // Clear row 7.
    SPI_Write2(0x0F, 0x00);         // Disable display test
    wait_ms(500);                   // 500 ms delay
}
 
int main()
{
    cs = 1;                         // CS initially High
    spi.format(8,0);                // 8-bit format, mode 0,0
    spi.frequency(1000000);         // SCLK = 1 MHz
    Init_MAX7219();                 // Initialize the LED controller
    while (1) {
        for(int i=1; i<9; i++)      // Write first character (8 rows)
            SPI_Write2(i,led1[i-1]);
        wait(1);                    // 1 sec delay
        for(int i=1; i<9; i++)      // Write second character
            SPI_Write2(i,led2[i-1]);
        wait(1);                    // 1 sec delay
        
        myled = 1; // LED is ON
        wait(0.5); // 200 ms
        myled = 0; // LED is OFF
        wait(0.5); // 1 sec
    }
}
 
 */
