#include "mbed.h"

DigitalOut myled(LED1);
AnalogIn FSR1(p20);
AnalogIn FSR2(p19);


int8_t AD5245_write_result;

float fsr1_value;
float fsr2_value;
int truncated_fsr1_value;

int8_t AD5245_addr = 0x2C;
//TODO: LTC4151 address will be change.
int8_t LTC4151_addr = 0xCE;

char data[2];

Serial pc(USBTX, USBRX);

I2C i2c(p9,p10);

int msb = 0;
int main()
{
    pc.baud(115200);

    while(1) {
        data[0] = 0x04;
        fsr1_value=FSR1.read();
        truncated_fsr1_value=fsr1_value*255;
        pc.printf("Truncated Value: %d\n",truncated_fsr1_value);
        i2c.start();
        i2c.write(AD5245_addr);
        i2c.write(truncated_fsr1_value);
        i2c.stop();

        wait(0.01);
#if 1
        i2c.start();                // I2C start
        i2c.write(0xCE);            // I2C slave address - 0xCE
        i2c.write(0x04);            // I2C slave register address - C_register 02h
        i2c.start();                // I2C start
        i2c.write(0xCF);            // I2C slave address - 0xCE
        msb=i2c.read(0);        // I2C read with NAK (not-acknowledge)
        i2c.stop();

        pc.printf("Msb: %d\n",msb);
#endif
#if 0
        data[0] = 0x02;  //register we want to read
        int ret = i2c.write(LTC4151_addr, data, 1, true);  //Write one byte, dont transmit stop condition, check if we get ACK

        if (ret == 0)
            printf("Succesfull write\n\r");
        else
            printf("Returned: %X\n\r", ret);

        i2c.read(LTC4151_addr, data, 2);
        pc.printf("Byte 1: 0x%x Byte 2: 0x%x\n",data[0],data[1]);
        pc.printf("Data = %d\n\r", (data[0]<<8) + data[1]);
#endif

        wait(0.5);
        if(myled) {
            myled = 0;
        } else {
            myled = 1;
        }
    }
}
