
// --------------------------------------------------------------------------- Inclusiones
#include "mbed.h"
#include "string.h"
using namespace std;

#define     Si              1
#define     No              0
#define     numMuestreos    5
#define     CoeficienteB    3950
#define     NominalTermistor    10000
#define     TempNominal     25
#define     ResistSerie     100
#define     Encendido       0
#define     Apagado         1





// --------------------------------------------------------------------------- Variables y objetos
Serial pc(USBTX, USBRX);  // Inicializo el puerto serie para comunicarme con la computadora
                          // La frecuencia por default es de 9600
                          
// Variables
unsigned int tiempoFinal; // Variable para almacenar el tiempo máximo
float tempTrabajo;        // Temperatura a la cual se debe mantener el sistema
float tempSen1;           // Temperatura del sensor 1
float tempSen2;           // Temperatura del sensor 2   
float tempSen3;           // Temperatura del sensor 3  
float tempSen4;           // Temperatura del sensor 4 
float proSen1;            // Promedio para conversión sensor 1 
float proSen2;            // Promedio para conversión sensor 2 
float proSen3;            // Promedio para conversión sensor 3 
float proSen4;            // Promedio para conversión sensor 4 
uint16_t adcTempSen1[numMuestreos];     // Variable para almacenar valor de adc sensor 1
uint16_t adcTempSen2[numMuestreos];     // Variable para almacenar valor de adc sensor 2  
uint16_t adcTempSen3[numMuestreos];     // Variable para almacenar valor de adc sensor 3
uint16_t adcTempSen4[numMuestreos];     // Variable para almacenar valor de adc sensor 4
Timer timmer;             // Timer para medir el tiempo transcurrido
bool inicioProceso = No;  // Variable para determinar si el proceso se inicia    
bool pausaProceso = No;   // Variable para pausar
bool finProceso = No;     // Variable finalizar el proceso  
char comando;             // Variable para leer el comando a ejecutar en el proceso  
char sTiempo[10];         // stringtiempo
char sTemperatura[10];    // string temperatura
bool curadoIniciado = No; 

  

//Pines de Salida
DigitalOut reflector1(p26);     // Salida para controlar el reflector 1
DigitalOut reflector2(p25);     // Salida para controlar el reflector 2
DigitalOut reflector3(p24);     // Salida para controlar el reflector 3
DigitalOut reflector4(p23);     // Salida para controlar el reflector 4
DigitalOut ventilador1(p22);    // Salida para controlar el ventilador 1
DigitalOut ventilador2(p21);    // Salida para controlar el ventilador 2

// Pines de Entrada
AnalogIn pinSen1(p16);         // Entrada para leer la temperatura del sensor 1 
AnalogIn pinSen2(p17);         // Entrada para leer la temperatura del sensor 2 
AnalogIn pinSen3(p18);         // Entrada para leer la temperatura del sensor 3 
AnalogIn pinSen4(p19);         // Entrada para leer la temperatura del sensor 4  


// --------------------------------------------------------------------------- Prototipos
void LeerSerie (void);         // Función para leer el puerto serie  
void LeerSensores (void);      // Función para leer temperatura delos sensores 
float convertirTemp(float promedio); // Función para convertir la lectura ADC a temperatura               


// --------------------------------------------------------------------------- Programa principal
int main() 
{
    pc.baud(9600);
    pc.printf("Iniciando\n\r");        // Se imprime y se da enter
    pc.attach(&LeerSerie);
    
    while(inicioProceso == No)
    {
        wait(0.1);
        //pc.printf("y");
    }// Espera a recibir comando 
    
    pc.printf("Proceso Iniciado\r\n");
    // Encender Ventiladores
    ventilador1 = 1;  
    ventilador2 = 1;
    pc.printf("Ventiladores Encendidos\r\n");
    reflector1 = Encendido;
    reflector2 = Encendido;
    reflector3 = Encendido;
    reflector4 = Encendido;
    pc.printf("Reflectores Encendidos\r\n");
    
    
    // Espera a que todos los sensores alcancen la temperatura de trabajo, que el curado inicie
    while(curadoIniciado == No)
    {
        LeerSensores();
        if((tempSen1 >= tempTrabajo) && (tempSen2 >= tempTrabajo) && (tempSen3 >= tempTrabajo) && (tempSen4 >= tempTrabajo))
        {
            curadoIniciado = Si;
        }
    }
    
    pc.printf("Curado Iniciado\r\n");
    // Activar timer
      
// --------------------------------------------------------------------------- PROCESO
    while(finProceso == No) 
    {
        
        LeerSensores();
        
        // ------------------------------ Controlar Reflector 1
        if(tempSen1 > tempTrabajo)
        {
            reflector1 = Apagado;
            pc.printf("Reflector 1: Apagado\r\n");
        }
        else if(tempSen1 < tempTrabajo)
        {
            reflector1 = Encendido;
            pc.printf("Reflector 1: Encendido\r\n");
        }
        
        // ------------------------------ Controlar Reflector 2
        if(tempSen2 > tempTrabajo)
        {
            reflector2 = Apagado;
            pc.printf("Reflector 2: Apagado\r\n");
        }
        else if(tempSen2 < tempTrabajo)
        {
            reflector2 = Encendido;
            pc.printf("Reflector 2: Encendido\r\n");
        }
        
        // ------------------------------ Controlar Reflector 3
        if(tempSen3 > tempTrabajo)
        {
            reflector3 = Apagado;
            pc.printf("Reflector 3: Apagado\r\n");
        }
        else if(tempSen3 < tempTrabajo)
        {
            reflector3 = Encendido;
            pc.printf("Reflector 3: Encendido\r\n");
        }
        
        // ------------------------------ Controlar Reflector 4
        if(tempSen4 > tempTrabajo)
        {
            reflector4 = Apagado;
            pc.printf("Reflector 4: Apagado\r\n");
        }
        else if(tempSen4 < tempTrabajo)
        {
            reflector4 = Encendido;
            pc.printf("Reflector 4: Encendido\r\n");
        }
        
        while(pausaProceso == Si)  // ---------------------------------------- Proceso Pausado
        {
            pc.printf("Proceso Puasado\r\n");
             // Apagar Ventiladores
            ventilador1 = 0;  
            ventilador2 = 0;
            pc.printf("Ventiladores Apagados\r\n");
            reflector1 = Apagado;
            reflector2 = Apagado;
            reflector3 = Apagado;
            reflector4 = Apagado;
            pc.printf("Reflectores Apagados\r\n");
            wait(1);
        }
    }
    
    pc.printf("Proceso Terminado\r\n");
}


// --------------------------------------------------------------------------- Funciones

// --------------------------------------------------------------------------- LeerSerie
void LeerSerie(void)
{
    comando = pc.getc();
    switch(comando)
    {
        case 'I':
                inicioProceso = Si;
                // Guardar Tiempo
                // Guardar Temperatura
                pc.scanf("%s %s",sTiempo, sTemperatura);
                pc.printf("\r\n");
                pc.printf(sTiempo);
                pc.printf("\r\n");
                pc.printf(sTemperatura);
                pc.printf("\r\n");
                
                tiempoFinal = atoi(sTiempo);
                tempTrabajo = atoi(sTemperatura);
                break;
                
        case 'P':
                pausaProceso = Si;
                break;
                
        case 'F':
                finProceso = Si;
                break;
                
        case 'R':
                pausaProceso = No;
                break;
        
    }
}

    
 //----------------------------------------------------Leer temperatura  
void LeerSensores(void)
{
        /*int i;
        //-------------------------------------------------------------------------- sensor 1
        //----------------------------- Se realizan múltiples lecturas para sacar un promedio de voltaje
        for ( i=0; i< numMuestreos; i++) 
        {
         adcTempSen1[i] = pinSen1.read_u16();
         wait(0.01);
        }
        // ---------------------------- Se calcula el promedio
        proSen1 = 0;
        for (i=0; i< numMuestreos; i++) 
        {
            proSen1 += adcTempSen1[i];
        }
        proSen1 /= numMuestreos;
        
        
        //-------------------------------------------------------------------------- sensor 2
        //----------------------------- Se realizan múltiples lecturas para sacar un promedio de voltaje
        for ( i=0; i< numMuestreos; i++) 
        {
         adcTempSen2[i] = pinSen2.read_u16();
         wait(0.01);
        }
        // ---------------------------- Se calcula el promedio
        proSen2 = 0;
        for (i=0; i< numMuestreos; i++) 
        {
            proSen2 += adcTempSen2[i];
        }
        proSen2 /= numMuestreos;
        
        
        //-------------------------------------------------------------------------- sensor 3
        //----------------------------- Se realizan múltiples lecturas para sacar un promedio de voltaje
        for ( i=0; i< numMuestreos; i++) 
        {
         adcTempSen3[i] = pinSen3.read_u16();
         wait(0.01);
        }
        // ---------------------------- Se calcula el promedio
        proSen3 = 0;
        for (i=0; i< numMuestreos; i++) 
        {
            proSen3 += adcTempSen3[i];
        }
        proSen3 /= numMuestreos;
        
        
        //-------------------------------------------------------------------------- sensor 4
        //----------------------------- Se realizan múltiples lecturas para sacar un promedio de voltaje
        for ( i=0; i< numMuestreos; i++) 
        {
         adcTempSen4[i] = pinSen4.read_u16();
         wait(0.01);
        }
        // ---------------------------- Se calcula el promedio
        proSen4 = 0;
        for (i=0; i< numMuestreos; i++) 
        {
            proSen4 += adcTempSen4[i];
        }
        proSen4 /= numMuestreos;
        
        
        tempSen1 = convertirTemp(proSen1);
        tempSen2 = convertirTemp(proSen2);
        tempSen3 = convertirTemp(proSen3);
        tempSen4 = convertirTemp(proSen4);*/
        
        // SOLO TEST
        tempSen1 = 50;
        tempSen2 = 50;
        tempSen3 = 50;
        tempSen4 = 50;
        // ----- TEST
        
        pc.printf("Sensor1: %.2f C. /r /n ", tempSen1);
        pc.printf("Sensor2: %.2f C. /r /n ", tempSen2);
        pc.printf("Sensor3: %.2f C. /r /n ", tempSen3);
        pc.printf("Sensor4: %.2f C. /r /n ", tempSen4);
        
}

// --------------------------------------------------------------------------- convertirTemp
float convertirTemp(float promedio)
{
  float temperatura;
  
   // convertir el promedio a resistencia
  promedio = 65535 / promedio - 1;
  promedio = ResistSerie / promedio;
  temperatura = promedio / NominalTermistor;     // (R/Ro)
  temperatura = log(temperatura);                // ln(R/Ro)
  temperatura /= CoeficienteB;                   // 1/B * ln(R/Ro)
  temperatura += 1.0 / (TempNominal + 273.15);   // + (1/To)
  temperatura = 1.0 / temperatura;               // Invertir
  temperatura -= 273.15;                         // convertir a C
  return temperatura;
}

    