
// --------------------------------------------------------------------------- Inclusiones
#include "mbed.h"
#include "string.h"
using namespace std;

#define     Si          1
#define     No          0




// --------------------------------------------------------------------------- Variables y objetos
Serial pc(USBTX, USBRX);  // Inicializo el puerto serie para comunicarme con la computadora
                          // La frecuencia por default es de 9600
                          
// Variables
unsigned int tiempoFinal; // Variable para almacenar el tiempo máximo
float tempTrabajo;        // Temperatura a la cual se debe mantener el sistema
float tempSen1;           // Temperatura del sensor 1
float tempSen2;           // Temperatura del sensor 2   
float tempSen3;           // Temperatura del sensor 3  
float tempSen4;           // Temperatura del sensor 4 
float volSen1;            // Voltaje para conversión sensor 1 
float volSen2;            // Voltaje para conversión sensor 2 
float volSen3;            // Voltaje para conversión sensor 3 
float volSen4;            // Voltaje para conversión sensor 4 
uint16_t adcTempSen1;     // Variable para almacenar valor de voltaje sensor 1
uint16_t adcTempSen2;     // Variable para almacenar valor de voltaje sensor 2 son variables nuevas 
uint16_t adcTempSen3;     // Variable para almacenar valor de voltaje sensor 3
uint16_t adcTempSen4;     // Variable para almacenar valor de voltaje sensor 4
Timer timmer;             // Timer para medir el tiempo transcurrido
bool inicioProceso = No;  // Variable para determinar si el proceso se inicia    
bool pausaProceso = No;   // Variable para pausar
bool finProceso = No;     // Variable finalizar el proceso  
char comando;             // Variable para leer el comando a ejecutar en el proceso  
char sTiempo[10];         // stringtiempo
char sTemperatura[10];    // string temperatura 

  

//Pines de Salida
DigitalOut reflector1(p26);     // Salida para controlar el reflector 1
DigitalOut reflector2(p25);     // Salida para controlar el reflector 2
DigitalOut reflector3(p24);     // Salida para controlar el reflector 3
DigitalOut reflector4(p23);     // Salida para controlar el reflector 4
DigitalOut ventilador1(p22);    // Salida para controlar el ventilador 1
DigitalOut ventilador2(p21);    // Salida para controlar el ventilador 2

// Pines de Entrada
AnalogIn pinSen1(p16);         // Entrada para leer la temperatura del sensor 1 
AnalogIn pinSen2(p17);         // Entrada para leer la temperatura del sensor 2 
AnalogIn pinSen3(p18);         // Entrada para leer la temperatura del sensor 3 
AnalogIn pinSen4(p19);         // Entrada para leer la temperatura del sensor 4  


// --------------------------------------------------------------------------- Prototipos
void LeerSerie (void);         // Función para leer el puerto serie  
void LeerSensores (void);      // Función para leer temperatura delos sensores                


// --------------------------------------------------------------------------- Programa principal
int main() 
{
    pc.baud(9600);
    pc.printf("Iniciando\n\r");        // Se imprime y se da enter
    pc.attach(&LeerSerie);
    pc.attach(&LeerSensores);
    
    while(inicioProceso == No)
    {
        wait(0.1);
        //pc.printf("y");
    }// Espera a recibir comando 
    
    pc.printf("Proceso Iniciado\r\n");
    
  
// --------------------------------------------------------------------------- PROCESO
    while(finProceso == No) 
    {
        
        
        
        while(pausaProceso == Si)  // ---------------------------------------- Proceso Pausado
        {
            pc.printf("Proceso Puasado\r\n");
            wait(0.1);
        }
    }
    
    pc.printf("Proceso Terminado\r\n");
}


// --------------------------------------------------------------------------- Funciones

// --------------------------------------------------------------------------- LeerSerie
void LeerSerie(void)
{
    comando = pc.getc();
    switch(comando)
    {
        case 'I':
                inicioProceso = Si;
                // Guardar Tiempo
                // Guardar Temperatura
                pc.scanf("%s %s",sTiempo, sTemperatura);
                pc.printf("\r\n");
                pc.printf(sTiempo);
                pc.printf("\r\n");
                pc.printf(sTemperatura);
                pc.printf("\r\n");
                
                tiempoFinal = atoi(sTiempo);
                tempTrabajo = atoi(sTemperatura);
                break;
                
        case 'P':
                pausaProceso = Si;
                break;
                
        case 'F':
                finProceso = Si;
                break;
                
        case 'R':
                pausaProceso = No;
                break;
        
    }
    
 //----------------------------------------------------Leer temperatura   
void LeerSensores(void)
{
        adcTempSen1 = pinSen1.read_u16();
        volSen1 = adcTempSen1 *5 / 65535;
        tempSen1 =
        pc.printf("Senor1: %1, %.2f volts, %.2f celcius. /r /n " ,  adcTempSen1, volSen1, tempSen1);
        
        adcTempSen2= pinSen2.read_u16();
        volSen2= adcTempSen2*5 / 65535;
        tempSen2=
        pc.printf("Senor2: %1, %.2f volts, %.2f celcius. /r /n " ,  adcTempSen2, volSen2, tempSen2);
        
        adcTempSen3= pinSen3.read_u16();
        volSen3= adcTempSen3*5 / 65535;
        tempSen3=
        pc.printf("Senor3: %1, %.2f volts, %.2f celcius. /r /n " ,  adcTempSen3, volSen3, tempSen3);
        
        adcTempSen1 = pinSen1.read_u16();
        volSen1 = adcTempSen1 *5 / 65535;
        tempSen1 =
        pc.printf("Senor4: %1, %.2f volts, %.2f celcius. /r /n " ,  adcTempSen4, volSen4, tempSen4);
        
        
        wait(0.1);
        
  
  
  
  
  }
    
    
    
}