
// --------------------------------------------------------------------------- Inclusiones
#include "mbed.h"



// --------------------------------------------------------------------------- Variables y objetos
Serial pc(USBTX, USBRX);  // Inicializo el puerto serie para comunicarme con la computadora
                          // La frecuencia por default es de 9600
                          
// Variables
int tiempoMaximo;         // Variable para almacenar el tiempo máximo
int tiempoTranscurrido;   // Variable para medir el tiempo transcurrido  
float tempTrabajo;        // Temperatura a la cual se debe mantener el sistema
float tempSen1;           // Temperatura del sensor 1  
float tempSen2;           // Temperatura del sensor 2   
float tempSen3;           // Temperatura del sensor 3  
float tempSen4;           // Temperatura del sensor 4   
float consConver = 1;     // Constante para convertir la lectura del ADC a temperatura  
Timer timer;              // Timer para medir el tiempo transcurrido  

//Pines de Salida
DigitalOut reflector1(p26);     // Salida para controlar el reflector 1
DigitalOut reflector2(p25);     // Salida para controlar el reflector 2
DigitalOut reflector3(p24);     // Salida para controlar el reflector 3
DigitalOut reflector4(p23);     // Salida para controlar el reflector 4
DigitalOut ventilador1(p22);    // Salida para controlar el ventilador 1
DigitalOut ventilador2(p21);    // Salida para controlar el ventilador 2

// Pines de Entrada
AnalogIn pinSen1(p16);         // Entrada para leer la temperatura del sensor 1 
AnalogIn pinSen2(p17);         // Entrada para leer la temperatura del sensor 2 
AnalogIn pinSen3(p18);         // Entrada para leer la temperatura del sensor 3 
AnalogIn pinSen4(p19);         // Entrada para leer la temperatura del sensor 4                           


// --------------------------------------------------------------------------- Programa principal
int main() 
{
    printf("Iniciando...\n\r");        // Se imprime y se da enter  
// --------------------------------------------------------------------------- Ciclo infinito
    while(1) 
    {
       
       // TEST de salidas
       reflector1 = 1;
       printf("Reflector 1 ON\n\r");        
       wait(3);
       reflector1 = 0;
       printf("Reflector 1 OFF\n\r");
       
       reflector2 = 1;
       printf("Reflector 2 ON\n\r");        
       wait(3);
       reflector2 = 0;
       printf("Reflector 2 OFF\n\r");
       
       reflector3 = 1;
       printf("Reflector 3 ON\n\r");        
       wait(3);
       reflector3 = 0;
       printf("Reflector 3 OFF\n\r");
       
       reflector4 = 1;
       printf("Reflector 4 ON\n\r");        
       wait(3);
       reflector4 = 0;
       printf("Reflector 4 OFF\n\r");
       
       ventilador1 = 1;
       printf("Ventilador 1 ON\n\r");        
       wait(3);
       ventilador1 = 0;
       printf("Ventilador 1 OFF\n\r"); 
       
       ventilador2 = 1;
       printf("Ventilador 2 ON\n\r");        
       wait(3);
       ventilador2 = 0;
       printf("Ventilador 2 OFF\n\r");
    }
}
