
#ifndef DISPLAY_H
#define DISPLAY_H

#include "mbed.h"

void pong_init_ttempro(Serial &pc){

    pc.printf("\033[2J");       //Efface la console
    pc.printf("\033[?25l");     //Cache le curseur
    
    for(int i=0; i <= 128 ; i++){
        pc.printf("\033[0;%dH",i);     //Place le curseur à 0:0
        pc.printf("X");     //Place le curseur à 0:0
        pc.printf("\033[32;%dH",i);     //Place le curseur à 0:0
        pc.printf("X");     //Place le curseur à 0:0
    }
    
    for(int i=0; i <= 32 ; i++){
        pc.printf("\033[%d;0H",i);     //Place le curseur à 0:0
        pc.printf("X");     //Place le curseur à 0:0
        pc.printf("\033[%d;128H",i);     //Place le curseur à 0:0
        pc.printf("X");     //Place le curseur à 0:0
    }
    
}

void print_cursor_ttempro(Serial &pc, int *pos1, int *pos1prec, int *pos2, int *pos2prec){
    for(int i=0;i<=29;i++){
        if( pos1[i] != pos1prec[i] ){
            if(pos1[i] == 1){
                pc.printf("\033[%d;3H",i+2);     //Place le curseur à 0:0
                pc.printf("X");     //Place le curseur à 0:0  
            }
            else{
                pc.printf("\033[%d;3H",i+2);     //Place le curseur à 0:0
                pc.printf(" ");     //Place le curseur à 0:0  
            }
        }
                
        if( pos2[i] != pos2prec[i] ){
            if(pos2[i] == 1){
                pc.printf("\033[%d;126H",i+2);     //Place le curseur à 0:0
                pc.printf("X");     //Place le curseur à 0:0  
            }
            else{
                pc.printf("\033[%d;126H",i+2);     //Place le curseur à 0:0
                pc.printf(" ");     //Place le curseur à 0:0  
            }
        }   
    } 
}

void set_pos_vector(int *pos, int distance){
            
    if(distance <= 10){
        for(int i=0;i<=5;i++){ pos[i] = 1; }
    }
    else if(distance >= 34){
        for(int i=24;i<=29;i++){ pos[i] = 1; }
    }
    else{
        for(int i=(distance-10);i<=(distance-4);i++){ pos[i] = 1; }
    }   
}

int set_print_ball(Serial &pc, int *pos1,int *pos2,double *posBallX, double *posBallY, double *angBall){
    pc.printf("\033[%d;%dH",(int)*posBallY, (int)*posBallX);     //Place le curseur à 0:0
    pc.printf(" ");     //Place le curseur à 0:0  
    *posBallX = *posBallX + 2.0*cos((double)*angBall*3.1415/180.0);
    *posBallY = *posBallY - 2.0*sin((double)*angBall*3.1415/180.0);
    
    if(*posBallX <= 4){
        if(pos1[(int)*posBallY] == 1){
            *posBallX = 8 - *posBallX;
            *angBall = 180 - *angBall;
        }
        else{ return 1; }
        }
    else if(*posBallX >= 125){
        if(pos2[(int)*posBallY] == 1){
            *posBallX = 250 - *posBallX;
            *angBall = 180 - *angBall;
        }
        else{ return 2; }
    }
        
        
    if(*posBallY <= 2){
        *posBallY = -*posBallY+4;
        *angBall = -*angBall;
    }
    else if(*posBallY >= 31){
        *posBallY = 62 - *posBallY;
        *angBall = -*angBall;
    }
    pc.printf("\033[%d;%dH",(int)*posBallY, (int)*posBallX);     //Place le curseur à 0:0
    pc.printf("o");     //Place le curseur à 0:0  
    return 3;
}


#endif