#include "mbed.h"
#include "HCSR04.h"
#include <math.h>

#define ECHO_1  PA_8
#define ECHO_2  PB_4
#define TRIG_1  PB_10
#define TRIG_2  PB_5
#define PUSH    USER_BUTTON //PC_13
#define LED_1   LED1

//------------------------------------
// Hyperterminal configuration
// 115200 bauds, 8-bit data, no parity
//------------------------------------


Serial pc(USBTX, USBRX);    //UART
DigitalOut led(LED_1);      //Led d'état
DigitalIn bp(USER_BUTTON);

HCSR04 sensor1(TRIG_1, ECHO_1);
HCSR04 sensor2(TRIG_2, ECHO_2); 

void pong_init_ttempro(){

    pc.printf("\033[2J");       //Efface la console
    pc.printf("\033[?25l");     //Cache le curseur
    
    for(int i=0; i <= 128 ; i++){
        pc.printf("\033[0;%dH",i);     //Place le curseur à 0:0
        pc.printf("X");     //Place le curseur à 0:0
        pc.printf("\033[32;%dH",i);     //Place le curseur à 0:0
        pc.printf("X");     //Place le curseur à 0:0
    }
    
    for(int i=0; i <= 32 ; i++){
        pc.printf("\033[%d;0H",i);     //Place le curseur à 0:0
        pc.printf("X");     //Place le curseur à 0:0
        pc.printf("\033[%d;128H",i);     //Place le curseur à 0:0
        pc.printf("X");     //Place le curseur à 0:0
    }
    
}

void print_cursor_ttempro(int *pos1, int *pos1prec, int *pos2, int *pos2prec){
    for(int i=0;i<=29;i++){
        if( pos1[i] != pos1prec[i] ){
            if(pos1[i] == 1){
                pc.printf("\033[%d;3H",i+2);     //Place le curseur à 0:0
                pc.printf("X");     //Place le curseur à 0:0  
            }
            else{
                pc.printf("\033[%d;3H",i+2);     //Place le curseur à 0:0
                pc.printf(" ");     //Place le curseur à 0:0  
            }
        }
                
        if( pos2[i] != pos2prec[i] ){
            if(pos2[i] == 1){
                pc.printf("\033[%d;126H",i+2);     //Place le curseur à 0:0
                pc.printf("X");     //Place le curseur à 0:0  
            }
            else{
                pc.printf("\033[%d;126H",i+2);     //Place le curseur à 0:0
                pc.printf(" ");     //Place le curseur à 0:0  
            }
        }   
    } 
}

void set_pos_vector(int *pos, int distance){
            
    if(distance <= 10){
        for(int i=0;i<=5;i++){ pos[i] = 1; }
    }
    else if(distance >= 34){
        for(int i=24;i<=29;i++){ pos[i] = 1; }
    }
    else{
        for(int i=(distance-10);i<=(distance-4);i++){ pos[i] = 1; }
    }   
}

int set_print_ball(int *pos1,int *pos2,double *posBallX, double *posBallY, double *angBall){
    
    pc.printf("\033[%d;%dH",(int)*posBallY, (int)*posBallX);     //Place le curseur à 0:0
    pc.printf(" ");     //Place le curseur à 0:0  
    *posBallX = *posBallX + 2.0*cos((double)*angBall*3.1415/180.0);
    *posBallY = *posBallY - 2.0*sin((double)*angBall*3.1415/180.0);
    
    if(*posBallX <= 4){
        if(pos1[(int)*posBallY] == 1){
            *posBallX = 8 - *posBallX;
            *angBall = 180 - *angBall;
        }
        else{ return 1; }
        }
    else if(*posBallX >= 125){
        if(pos2[(int)*posBallY] == 1){
            *posBallX = 250 - *posBallX;
            *angBall = 180 - *angBall;
        }
        else{ return 2; }
        }
    }
        
        
    if(*posBallY <= 2){
        *posBallY = -*posBallY+4;
        *angBall = -*angBall;
    }
    else if(*posBallY >= 31){
        *posBallY = 62 - *posBallY;
        *angBall = -*angBall;
    }
    pc.printf("\033[%d;%dH",(int)*posBallY, (int)*posBallX);     //Place le curseur à 0:0
    pc.printf("o");     //Place le curseur à 0:0  
    return 3;
}

int main() {
    int pos1prec[30];
    int pos2prec[30];
    int pos1[30];
    int pos2[30];
    double posBallX;
    double posBallY;
    double angBall;
    int distance1;
    int distance2;
    
    int state;
    int p1_score;
    int p2_score;

    pc.baud(115200);
    pong_init_ttempro();
    posBallX = 5.0;
    posBallY = 19.0;
    angBall = 25.0;
    state = 0;
    p1_score = 0;
    p2_score = 0;
    wait(1);
    led=1;
    //Initialisation de l'interruption : en appuyant sur le bouton bleu de la carte, le programme change d'état
    
    
    //Boucle d'exécution du programme
    while(1) { 
        switch(state){
        case 0 :    if(bp.read() != 1){ 
                    state = 3; 
                    pong_init_ttempro();
                    }
                    break;
                    
        case 3 :    for(int i=0; i<=29; i++){
                        pos1prec[i]= pos1[i];
                        pos2prec[i]= pos2[i];
                        pos1[i]= 0;
                        pos2[i]= 0;
                    }
                    distance1 = 22;//sensor1.distance(1);
                    distance2 = 10;//sensor2.distance(1);
                    set_pos_vector(pos1,distance1);
                    set_pos_vector(pos2,distance2);     
                    print_cursor_ttempro(pos1,pos1prec,pos2,pos2prec);
                    state = set_print_ball(pos1,pos2,&posBallX,&posBallY,&angBall);
                    break;
                    
        case 1 :    p2_score++;
                    if( p2_score >= 3){ 
                        pc.printf("\033[2J");       //Efface la console
                        pc.printf("\033[16;60H"); 
                        pc.printf("P2  WIN ");
                        p1_score = 0;
                        p2_score = 0;
                        posBallX = 5.0;
                        posBallY = 19.0;
                        angBall = 25.0;
                    }
                    else{
                        pc.printf("\033[2J");       //Efface la console
                        pc.printf("\033[10;60H"); 
                        pc.printf("P1 : %d  // P2 : %d",p1_score,p2_score);
                        posBallX = 5.0;
                        posBallY = 19.0;
                        angBall = 25.0;
                        
                    }
                    state = 0;
                    break;
                    
        case 2 :    p1_score++;
                    if( p1_score >= 3){ 
                        pc.printf("\033[2J");       //Efface la console
                        pc.printf("\033[16;60H"); 
                        pc.printf("P1  WIN ");
                        p1_score = 0;
                        p2_score = 0; 
                        posBallX = 124.0;
                        posBallY = 19.0;
                        angBall = 145.0; 
                    }
                    else{
                        pc.printf("\033[2J");       //Efface la console
                        pc.printf("\033[10;60H"); 
                        pc.printf("P1 : %d  // P2 : %d",p1_score,p2_score);
                        posBallX = 124.0;
                        posBallY = 19.0;
                        angBall = 145.0;
                    }
                    state = 0;
                    break;
        }
        wait(0.1);   
    }
}

 