#include "mbed.h"
#include "hcsr04.h"
#include "contest.h"
#include <math.h>

#define ECHO_1  PB_9
#define ECHO_2  PA_5
#define TRIG_1  PB_8
#define TX      PA_2
#define RX      PA_3
#define PUSH    USER_BUTTON //PC_13
#define LED_1   LED1

//------------------------------------
// Hyperterminal configuration
// 9600 bauds, 8-bit data, no parity
//------------------------------------


Serial pc(TX, RX);          //UART
DigitalOut led(LED_1);      //Led d'état
InterruptIn button(PUSH);   //Bouton d'interruption

HCSR04 sensor(TRIG_1, ECHO_1); 
Control ctrl;

void changeEtat(){
    pc.printf("\033[2J");   //Efface la console
    ctrl.marcheArret();
}
float distancePrec=0;



int main() {
    float distance;
    pc.printf("\033[2J");       //Efface la console
    pc.printf("\033[0;0H");     //Place le curseur à 0:0
    pc.printf("\033[?25l");     //Cache le curseur
    //pc.printf("\033[?25h");   //Affiche le curseur
    pc.printf("Initialisation...   ");
    
    //Initialisation de l'interruption : en appuyant sur le bouton bleu de la carte, le programme change d'état
    button.fall(&changeEtat);
    
    pc.printf("Ready !\n\r");
    
    //Boucle d'exécution du programme
    while(1) { 
        if(ctrl.isActive()){
            led=1;
            distance = sensor.distance();               //Mesure de la distance
            print_distance(distance, distancePrec);     //Affichage à l'écran
            distancePrec=distance;                      //Mise en mémoire
        }else{
            led=0;
        }
    wait(0.001);
    }
}
 