#ifndef BUZZER_H
#define BUZZER_H

#include "mbed.h"

DigitalOut buzz(PB_8);

class Buzzer{
    public :
    Buzzer(){
        TsilenceMs=100;
        etat = BipInit;
        t.reset();
        i=0;
    }
    int TsilenceMs;
    
    typedef enum {BipInit, BipUp, BipDown, Silent} defetat;
    defetat etat;
    Timer t;
    int i;
    
    void changeMode(int value);
    void run();
};

/*
Buzzer::Buzzer(){
    TsilenceMs=100;
    etat = BipInit;
    t.reset();
    i=0;
}
*/

/* 
 * Initialisation des différents modes de fonctionnement :
 * 
 *   0 < d <  25  --> 0 : 5 b/s
 *  25 < d <  50  --> 1 : 4 b/s
 *  50 < d < 100  --> 2 : 3 b/s
 * 100 < d < 150  --> 3 : 2 b/s
 * 150 < d < 200  --> 4 : 1 b/s
 * 200 < d        --> 5 : 0 b/s
 
 fonction bip : (400µs+400µs)*50 = 40ms
 -> timer sur interruption en fonction du temps à attendre avant le prochain bip
        0 --> 5 b/s --> TsilenceMs 0,16s
        1 --> 4 b/s --> TsilenceMs 0,21s
        2 --> 3 b/s --> TsilenceMs 0,29s
        3 --> 2 b/s --> TsilenceMs 0,46s
        4 --> 1 b/s --> TsilenceMs 0,96s
        5 -->           TsilenceMs 1s
 
 */


//Modifie la valeur du temps de silence entre 2 bips en fonction de la distance
void Buzzer::changeMode(int value){
    if(value<=25){                      //0
        TsilenceMs=160;
    }else if(value>25 && value<=50){    //1
        TsilenceMs=210;
    }else if(value>50 && value<=100){   //2
        TsilenceMs=290;
    }else if(value>100 && value<=150){   //3
        TsilenceMs=460;
    }else if(value>150 && value<=200){  //4
        TsilenceMs=960;
    }else{                              //5
        TsilenceMs=1000;
    }
}

/*
Si la valeur sort de son intervalle de fonctionnement,
on modifie le mode de fonctionnement courant.

fonction bip : (400µs+400µs)*50 = 40ms
 -> timer sur interruption en fonction du temps à attendre avant le prochain bip
        0 --> 5 b/s --> silence 0,16s
        1 --> 4 b/s --> silence 0,21s
        2 --> 3 b/s --> silence 0,29s
        3 --> 2 b/s --> silence 0,46s
        4 --> 1 b/s --> silence 0,96s
        5 -->           silence 1s

Etat : BipInit
        Timer t Start
        Bip=0
        i=0
        Etat = BipUp
Etat : BipUp
        si (t>=400µs && i<50)
            bipCarreUp
            i++
            Etat = BipDown
            t Restart
        si (i>=50) Etat = Silence;
            t Restart
Etat : BipDown
        si (t>=400µs && i<50)
            bipCarreUp
            i++
            Etat = BipUp
            t Restart
        si (i>=50) Etat = Silence;
            t Restart
Etat : Silence
        si (t>=Tsilence)
            Etat=BipInit

*/

void Buzzer::run(){ // paramètre : t (Timer), i, etat
    switch(etat){
        
        case BipInit :
            buzz=0;
            i=0;
            etat = BipUp;
            t.start();
            break;
            
        case BipUp :
            if(t.read_us()>=400 && i<50){
                buzz=1;
                i++;
                etat = BipDown;
                t.reset();
                t.start();
            }
            if(i>=50){
                etat = Silent;
                t.reset();
                t.start();
            }
            break;
            
        case BipDown :
            if(t.read_us()>=400 && i<50){
                buzz=0;
                i++;
                etat = BipUp;
                t.reset();
                t.start();
            }
            if(i>=50){
                etat = Silent;
                t.reset();
                t.start();
            }
            break; 
            
        case Silent :
            if(t.read_ms()>=TsilenceMs){
                etat=BipInit;
            }
            break;
            
        default :
            etat = BipInit;
            break;
    }
}


#endif