#include "UART_Radar.h"
#include "mbed.h"
#include <string.h>
Serial carte(PA_9, PA_10); //emission --- tx, rx


void USART1_puts(char *text){
    while(*text != '\0'){
        
        if(carte.writeable()){ 
            carte.putc(*text);
            text++;
        }
        
    }
}
        

void format(char *msg, char *msg_formated){
    int somme=5;
    int i=0;
    msg_formated[0]=2;
    //pc.printf("\n\r");
    while(msg[i]!=0){
        somme= somme + msg[i];
        msg_formated[i+1]=msg[i];
        i++;
    }
    if(somme>255){
            somme++;
    }
    somme=somme%256;
    msg_formated[i+1]=~somme;
    msg_formated[i+2]=3;
    msg_formated[i+3]=0;

   //A supprimer
    /*i=0;
    while(msg_formated[i]!=0){
        printf("[%d] ", msg_formated[i]);
        i++;
    }*/
}


void send(char *data){
        char trame[52]="";
        format(data, trame);
        USART1_puts(trame);
}

int receive(char *frame){
    int I;
    unsigned int sommeBuffer;
    char r;
    Timer timeout;
    timeout.start();
    while(1){
        if(timeout.read_ms() > 100) return 2;
        if(carte.readable()){
            r = carte.getc();
            
            switch(r){
                case 2: //Start
                    I=0;
                    sommeBuffer=2;
                    break;
                    
                case 3: //Stop
                    frame[I]=0;
                    sommeBuffer+=3;
                    
                    if(sommeBuffer>255){
                        sommeBuffer++;
                    }
                    sommeBuffer=~sommeBuffer;
                    sommeBuffer=sommeBuffer%256;
                
                    if(sommeBuffer==0){ //Les sommes concordent, les données sont valides
                        frame[I-1]=0;
                        return 0;
                    }else{ //Message invalidé par la somme
                        return 1;
                    }
                    
                default : 
                    frame[I]=r;
                    sommeBuffer+=r;        
                    I++;
                    break;
                }
            }
        }
}

int controle(char *frame){
    if (*frame == 6) return 0;
    else return 1;  
}